/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.appium;

import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.OutOfBoundsException;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.appium.EyesAppiumDriver;
import com.applitools.eyes.selenium.capture.EyesWebDriverScreenshot;
import com.applitools.eyes.selenium.wrappers.EyesWebDriver;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;

public class EyesAppiumScreenshot
extends EyesWebDriverScreenshot {
    private final EyesAppiumDriver driver;

    public EyesAppiumScreenshot(Logger logger, EyesAppiumDriver driver, BufferedImage image) {
        super(logger, (EyesWebDriver)driver, image);
        this.driver = driver;
    }

    public EyesAppiumScreenshot(Logger logger, EyesAppiumDriver driver, BufferedImage image, Region screenshotRegion) {
        super(logger, (EyesWebDriver)driver, image, screenshotRegion);
        this.driver = driver;
    }

    public EyesAppiumScreenshot(Logger logger, EyesAppiumDriver driver, BufferedImage image, RectangleSize entireFrameSize) {
        super(logger, (EyesWebDriver)driver, image, entireFrameSize);
        this.driver = driver;
    }

    public Location getLocationInScreenshot(Location location, CoordinatesType coordinatesType) throws OutOfBoundsException {
        return location;
    }

    public Location getLocationInScreenshot(Location location, Location originalLocation, CoordinatesType coordinatesType) throws OutOfBoundsException {
        if (location.getY() < originalLocation.getY()) {
            return location;
        }
        return new Location(location.getX(), location.getY() - this.driver.getStatusBarHeight());
    }

    public EyesAppiumScreenshot getSubScreenshot(Region region, boolean throwIfClipped) {
        BufferedImage subImage = ImageUtils.getImagePart((BufferedImage)this.image, (Region)region);
        return new EyesAppiumScreenshot(this.logger, this.driver, subImage, new RectangleSize(subImage.getWidth(), subImage.getHeight()));
    }

    public EyesWebDriverScreenshot getSubScreenshotForRegion(Region region, boolean throwIfClipped) {
        return super.getSubScreenshotForRegion(region, throwIfClipped);
    }

    public Location convertLocation(Location location, CoordinatesType from, CoordinatesType to) {
        return location;
    }
}

