/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.appium;

import com.applitools.eyes.Logger;
import com.applitools.eyes.appium.ContentSize;
import com.applitools.eyes.appium.LastScrollData;
import com.applitools.eyes.selenium.EyesSeleniumUtils;
import com.applitools.utils.ArgumentGuard;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.ScreenOrientation;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;

public class EyesAppiumUtils
extends EyesSeleniumUtils {
    private static final String NATIVE_APP = "NATIVE_APP";
    private static String SCROLLVIEW_XPATH = "//*[@scrollable='true']";
    private static String FIRST_VIS_XPATH = "/*[@firstVisible='true']";

    public static boolean isMobileDevice(WebDriver driver) {
        driver = EyesAppiumUtils.getUnderlyingDriver((WebDriver)driver);
        return driver instanceof AppiumDriver;
    }

    public static boolean isAndroid(WebDriver driver) {
        driver = EyesAppiumUtils.getUnderlyingDriver((WebDriver)driver);
        return driver instanceof AndroidDriver;
    }

    public static boolean isIOS(WebDriver driver) {
        driver = EyesAppiumUtils.getUnderlyingDriver((WebDriver)driver);
        return driver instanceof IOSDriver;
    }

    public static String getPlatformVersion(HasCapabilities driver) {
        Capabilities capabilities = driver.getCapabilities();
        Object platformVersionObj = capabilities.getCapability("platformVersion");
        return platformVersionObj == null ? null : String.valueOf(platformVersionObj);
    }

    public static WebElement getFirstScrollableView(WebDriver driver) {
        return driver.findElement(By.xpath((String)SCROLLVIEW_XPATH));
    }

    public static WebElement getFirstVisibleChild(WebElement element) {
        return element.findElement(By.xpath((String)FIRST_VIS_XPATH));
    }

    public static void scrollByDirection(AppiumDriver driver, String direction) {
        EyesAppiumUtils.scrollByDirection(driver, direction, 1.0);
    }

    public static void scrollByDirection(AppiumDriver driver, String direction, double distanceRatio) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("direction", direction);
        args.put("distance", Double.toString(distanceRatio));
        driver.executeScript("mobile: scroll", new Object[]{args});
    }

    public static void scrollBackToElement(AndroidDriver driver, RemoteWebElement scroller, RemoteWebElement scrollToEl) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("elementId", scroller.getId());
        args.put("elementToId", scrollToEl.getId());
        driver.executeScript("mobile: scrollBackTo", new Object[]{args});
    }

    public static ContentSize getContentSize(AppiumDriver driver, WebElement element) throws IOException {
        ContentSize contentSize;
        try {
            String contentSizeJson = element.getAttribute("contentSize");
            ObjectMapper objectMapper = new ObjectMapper();
            contentSize = (ContentSize)objectMapper.readValue(contentSizeJson, ContentSize.class);
            contentSize.setDriver(driver);
        }
        catch (WebDriverException e) {
            contentSize = new ContentSize();
            contentSize.height = element.getSize().getHeight();
            contentSize.width = element.getSize().getWidth();
            contentSize.top = element.getLocation().getY();
            contentSize.left = element.getLocation().getX();
            contentSize.scrollableOffset = element.getSize().getHeight();
        }
        return contentSize;
    }

    @Nullable
    public static LastScrollData getLastScrollData(AppiumDriver driver) {
        Map scrollData = (Map)driver.getSessionDetail("lastScrollData");
        if (scrollData == null) {
            return null;
        }
        return new LastScrollData(scrollData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLandscapeOrientation(Logger logger, WebDriver driver) {
        if (EyesAppiumUtils.isMobileDevice(driver)) {
            AppiumDriver appiumDriver = (AppiumDriver)EyesAppiumUtils.getUnderlyingDriver((WebDriver)driver);
            String originalContext = null;
            try {
                originalContext = appiumDriver.getContext();
                if (appiumDriver.getContextHandles().size() > 1 && !originalContext.equalsIgnoreCase(NATIVE_APP)) {
                    appiumDriver.context(NATIVE_APP);
                } else {
                    originalContext = null;
                }
            }
            catch (WebDriverException e) {
                originalContext = null;
            }
            try {
                ScreenOrientation orientation = appiumDriver.getOrientation();
                boolean bl = orientation == ScreenOrientation.LANDSCAPE;
                return bl;
            }
            catch (Exception e) {
                logger.log("WARNING: Couldn't get device orientation. Assuming Portrait.");
                boolean bl = false;
                return bl;
            }
            finally {
                if (originalContext != null) {
                    appiumDriver.context(originalContext);
                }
            }
        }
        return false;
    }

    public static int tryAutomaticRotation(Logger logger, WebDriver driver, BufferedImage image) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        int degrees = 0;
        try {
            logger.verbose("Trying to automatically normalize rotation...");
            if (EyesAppiumUtils.isMobileDevice(driver) && EyesAppiumUtils.isLandscapeOrientation(logger, driver) && image.getHeight() > image.getWidth()) {
                degrees = EyesAppiumUtils.isAndroid(driver) ? 90 : -90;
            }
        }
        catch (Exception e) {
            logger.verbose("Got exception: " + e.getMessage());
            logger.verbose("Skipped automatic rotation handling.");
        }
        return degrees;
    }
}

