/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.appium.locators;

import com.applitools.eyes.IServerConnector;
import com.applitools.eyes.Logger;
import com.applitools.eyes.Region;
import com.applitools.eyes.appium.EyesAppiumDriver;
import com.applitools.eyes.appium.locators.BaseVisualLocatorProvider;
import com.applitools.eyes.debug.DebugScreenshotsProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AndroidVisualLocatorProvider
extends BaseVisualLocatorProvider {
    AndroidVisualLocatorProvider(EyesAppiumDriver driver, Logger logger, IServerConnector serverConnector, DebugScreenshotsProvider debugScreenshotsProvider) {
        super(driver, serverConnector, logger, debugScreenshotsProvider);
    }

    public Map<String, List<Region>> adjustVisualLocators(Map<String, List<Region>> map) {
        this.logger.verbose("Adjust visual locators size and coordinates according to device pixel ratio = " + this.getDevicePixelRatio());
        HashMap<String, List<Region>> result = new HashMap<String, List<Region>>();
        for (String key : map.keySet()) {
            ArrayList<Region> regions = new ArrayList<Region>();
            if (map.get(key) == null) continue;
            for (Region region : map.get(key)) {
                region.setLeft((int)((double)region.getLeft() * this.getDevicePixelRatio()));
                region.setTop((int)((double)region.getTop() * this.getDevicePixelRatio()));
                region.setHeight((int)((double)region.getHeight() * this.getDevicePixelRatio()));
                region.setWidth((int)((double)region.getWidth() * this.getDevicePixelRatio()));
                regions.add(region);
            }
            result.put(key, regions);
        }
        return result;
    }
}

