/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.appium.locators;

import com.applitools.eyes.IServerConnector;
import com.applitools.eyes.Logger;
import com.applitools.eyes.Region;
import com.applitools.eyes.VisualLocatorsData;
import com.applitools.eyes.appium.EyesAppiumDriver;
import com.applitools.eyes.debug.DebugScreenshotsProvider;
import com.applitools.eyes.locators.IVisualLocatorProvider;
import com.applitools.eyes.locators.IVisualLocatorSettings;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.OutputType;

public abstract class BaseVisualLocatorProvider
implements IVisualLocatorProvider {
    protected Logger logger;
    private IServerConnector serverConnector;
    protected EyesAppiumDriver driver;
    private double devicePixelRatio;
    private DebugScreenshotsProvider debugScreenshotsProvider;

    BaseVisualLocatorProvider(EyesAppiumDriver driver, IServerConnector serverConnector, Logger logger, DebugScreenshotsProvider debugScreenshotsProvider) {
        this.driver = driver;
        this.serverConnector = serverConnector;
        this.logger = logger;
        this.devicePixelRatio = driver.getEyes().getDevicePixelRatio();
        this.debugScreenshotsProvider = debugScreenshotsProvider;
    }

    private BufferedImage getViewPortScreenshot() {
        this.logger.verbose("Getting screenshot as base64...");
        String base64Image = (String)this.driver.getScreenshotAs(OutputType.BASE64);
        this.logger.verbose("Done getting base64! Creating BufferedImage...");
        BufferedImage image = ImageUtils.imageFromBase64((String)base64Image);
        this.logger.verbose("Scale image with the scale ratio - " + 1.0 / this.getDevicePixelRatio());
        return ImageUtils.scaleImage((BufferedImage)image, (double)(1.0 / this.getDevicePixelRatio()));
    }

    public Map<String, List<Region>> getLocators(IVisualLocatorSettings visualLocatorSettings) {
        ArgumentGuard.notNull((Object)visualLocatorSettings, (String)"visualLocatorSettings");
        this.logger.verbose("Get locators with given names: " + visualLocatorSettings.getNames());
        this.logger.verbose("Requested viewport screenshot for visual locators...");
        BufferedImage viewPortScreenshot = this.getViewPortScreenshot();
        this.debugScreenshotsProvider.save(viewPortScreenshot, "visual_locators_" + String.join((CharSequence)"_", visualLocatorSettings.getNames()));
        this.logger.verbose("Convert screenshot from BufferedImage to base64...");
        byte[] image = ImageUtils.encodeAsPng((BufferedImage)viewPortScreenshot);
        this.logger.verbose("Post visual locators screenshot...");
        String viewportScreenshotUrl = this.serverConnector.postViewportImage(image);
        this.logger.verbose("Screenshot URL: " + viewportScreenshotUrl);
        VisualLocatorsData data = new VisualLocatorsData(this.driver.getEyes().getAppName(), viewportScreenshotUrl, visualLocatorSettings.isFirstOnly(), visualLocatorSettings.getNames());
        this.logger.verbose("Post visual locators: " + data.toString());
        Map result = this.serverConnector.postLocators(data);
        this.logger.verbose("Done! Response: " + result.toString());
        return this.adjustVisualLocators(result);
    }

    double getDevicePixelRatio() {
        return this.devicePixelRatio;
    }
}

