/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.appium.locators;

import com.applitools.eyes.IServerConnector;
import com.applitools.eyes.Logger;
import com.applitools.eyes.appium.EyesAppiumDriver;
import com.applitools.eyes.appium.EyesAppiumUtils;
import com.applitools.eyes.appium.locators.AndroidVisualLocatorProvider;
import com.applitools.eyes.appium.locators.IOSVisualLocatorProvider;
import com.applitools.eyes.debug.DebugScreenshotsProvider;
import com.applitools.eyes.locators.IVisualLocatorProvider;
import org.openqa.selenium.WebDriver;

public class VisualLocatorProviderFactory {
    private EyesAppiumDriver driver;
    private Logger logger;
    private IServerConnector serverConnector;
    private DebugScreenshotsProvider debugScreenshotsProvider;

    public VisualLocatorProviderFactory(EyesAppiumDriver driver, Logger logger, IServerConnector serverConnector, DebugScreenshotsProvider debugScreenshotsProvider) {
        this.driver = driver;
        this.logger = logger;
        this.serverConnector = serverConnector;
        this.debugScreenshotsProvider = debugScreenshotsProvider;
    }

    public IVisualLocatorProvider getProvider() {
        if (EyesAppiumUtils.isAndroid((WebDriver)this.driver.getRemoteWebDriver())) {
            return new AndroidVisualLocatorProvider(this.driver, this.logger, this.serverConnector, this.debugScreenshotsProvider);
        }
        if (EyesAppiumUtils.isIOS((WebDriver)this.driver.getRemoteWebDriver())) {
            return new IOSVisualLocatorProvider(this.driver, this.logger, this.serverConnector, this.debugScreenshotsProvider);
        }
        throw new Error("Could not find driver type for getting visual locator provider");
    }
}

