/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.appium;

import com.applitools.ICheckSettings;
import com.applitools.eyes.AutProxySettings;
import com.applitools.eyes.appium.AppiumCheckSettings;
import com.applitools.eyes.appium.AppiumCodedRegionReferenceMapper;
import com.applitools.eyes.appium.AppiumTAccessibilityRegionMapper;
import com.applitools.eyes.appium.AppiumTFloatingRegionMapper;
import com.applitools.eyes.appium.AppiumTRegionMapper;
import com.applitools.eyes.config.Configuration;
import com.applitools.eyes.universal.ManagerType;
import com.applitools.eyes.universal.dto.CheckSettingsDto;
import com.applitools.eyes.universal.dto.ImageCropRectDto;
import com.applitools.eyes.universal.mapper.NMGOptionsMapper;
import com.applitools.eyes.universal.mapper.ProxyMapper;
import com.applitools.eyes.universal.mapper.VisualGridOptionMapper;
import java.util.Arrays;
import java.util.List;

public class AppiumCheckSettingsMapper {
    public static CheckSettingsDto toCheckSettingsDto(ICheckSettings checkSettings) {
        if (!(checkSettings instanceof AppiumCheckSettings)) {
            return null;
        }
        AppiumCheckSettings appiumCheckSettings = (AppiumCheckSettings)checkSettings;
        CheckSettingsDto checkSettingsDto = new CheckSettingsDto();
        checkSettingsDto.setName(appiumCheckSettings.getName());
        checkSettingsDto.setDisableBrowserFetching(appiumCheckSettings.isDisableBrowserFetching());
        checkSettingsDto.setUfgOptions(VisualGridOptionMapper.toVisualGridOptionDtoList((List)appiumCheckSettings.getVisualGridOptions()));
        checkSettingsDto.setHooks(appiumCheckSettings.getScriptHooks());
        checkSettingsDto.setMatchLevel(appiumCheckSettings.getMatchLevel() == null ? null : appiumCheckSettings.getMatchLevel().getName());
        checkSettingsDto.setSendDom(appiumCheckSettings.isSendDom());
        checkSettingsDto.setUseDom(appiumCheckSettings.isUseDom());
        checkSettingsDto.setEnablePatterns(appiumCheckSettings.isEnablePatterns());
        checkSettingsDto.setIgnoreCaret(appiumCheckSettings.getIgnoreCaret());
        checkSettingsDto.setIgnoreDisplacements(appiumCheckSettings.isIgnoreDisplacements());
        checkSettingsDto.setAccessibilitySettings(null);
        checkSettingsDto.setIgnoreRegions(AppiumCodedRegionReferenceMapper.toCodedRegionReferenceList(Arrays.asList(appiumCheckSettings.getIgnoreRegions())));
        checkSettingsDto.setLayoutRegions(AppiumCodedRegionReferenceMapper.toCodedRegionReferenceList(Arrays.asList(appiumCheckSettings.getLayoutRegions())));
        checkSettingsDto.setStrictRegions(AppiumCodedRegionReferenceMapper.toCodedRegionReferenceList(Arrays.asList(appiumCheckSettings.getStrictRegions())));
        checkSettingsDto.setContentRegions(AppiumCodedRegionReferenceMapper.toCodedRegionReferenceList(Arrays.asList(appiumCheckSettings.getContentRegions())));
        checkSettingsDto.setFloatingRegions(AppiumTFloatingRegionMapper.toTFloatingRegionDtoList(Arrays.asList(appiumCheckSettings.getFloatingRegions())));
        checkSettingsDto.setAccessibilityRegions(AppiumTAccessibilityRegionMapper.toTAccessibilityRegionDtoList(Arrays.asList(appiumCheckSettings.getAccessibilityRegions())));
        checkSettingsDto.setPageId(appiumCheckSettings.getPageId());
        checkSettingsDto.setLazyLoad(appiumCheckSettings.getLazyLoadOptions());
        checkSettingsDto.setWebview(appiumCheckSettings.getWebview() != null ? appiumCheckSettings.getWebview() : (appiumCheckSettings.getIsDefaultWebview() != null ? appiumCheckSettings.getIsDefaultWebview() : null));
        checkSettingsDto.setRegion(AppiumTRegionMapper.toTRegionFromCheckSettings(checkSettings));
        checkSettingsDto.setFully(appiumCheckSettings.getStitchContent());
        checkSettingsDto.setScrollRootElement(AppiumTRegionMapper.toTRegionDtoFromScrolls(appiumCheckSettings.getScrollRootElementSelector(), appiumCheckSettings.getScrollRootElement()));
        return checkSettingsDto;
    }

    public static CheckSettingsDto toCheckSettingsDtoV3(ICheckSettings checkSettings, Configuration config) {
        if (!(checkSettings instanceof AppiumCheckSettings)) {
            return null;
        }
        AppiumCheckSettings appiumCheckSettings = (AppiumCheckSettings)checkSettings;
        CheckSettingsDto checkSettingsDto = new CheckSettingsDto();
        checkSettingsDto.setRegion(AppiumTRegionMapper.toTRegionFromCheckSettings(checkSettings));
        checkSettingsDto.setFully(appiumCheckSettings.getStitchContent());
        checkSettingsDto.setScrollRootElement(AppiumTRegionMapper.toTRegionDtoFromScrolls(appiumCheckSettings.getScrollRootElementSelector(), appiumCheckSettings.getScrollRootElement()));
        checkSettingsDto.setStitchMode(config.getStitchMode() == null ? null : config.getStitchMode().getName());
        checkSettingsDto.setHideScrollbars(config.getHideScrollbars());
        checkSettingsDto.setHideCaret(config.getHideCaret());
        ImageCropRectDto overlap = new ImageCropRectDto();
        overlap.setBottom(config.getStitchOverlap());
        checkSettingsDto.setOverlap(config.getStitchOverlap() == null ? null : overlap);
        checkSettingsDto.setWaitBeforeCapture(appiumCheckSettings.getWaitBeforeCapture());
        checkSettingsDto.setLazyLoad(appiumCheckSettings.getLazyLoadOptions());
        checkSettingsDto.setIgnoreDisplacements(appiumCheckSettings.isIgnoreDisplacements());
        checkSettingsDto.setWebview(appiumCheckSettings.getWebview() != null ? appiumCheckSettings.getWebview() : (appiumCheckSettings.getIsDefaultWebview() != null ? appiumCheckSettings.getIsDefaultWebview() : null));
        checkSettingsDto.setDebugImages(null);
        checkSettingsDto.setName(appiumCheckSettings.getName());
        checkSettingsDto.setPageId(appiumCheckSettings.getPageId());
        checkSettingsDto.setIgnoreRegions(AppiumCodedRegionReferenceMapper.toCodedRegionReferenceList(Arrays.asList(appiumCheckSettings.getIgnoreRegions())));
        checkSettingsDto.setLayoutRegions(AppiumCodedRegionReferenceMapper.toCodedRegionReferenceList(Arrays.asList(appiumCheckSettings.getLayoutRegions())));
        checkSettingsDto.setStrictRegions(AppiumCodedRegionReferenceMapper.toCodedRegionReferenceList(Arrays.asList(appiumCheckSettings.getStrictRegions())));
        checkSettingsDto.setContentRegions(AppiumCodedRegionReferenceMapper.toCodedRegionReferenceList(Arrays.asList(appiumCheckSettings.getContentRegions())));
        checkSettingsDto.setFloatingRegions(AppiumTFloatingRegionMapper.toTFloatingRegionDtoList(Arrays.asList(appiumCheckSettings.getFloatingRegions())));
        checkSettingsDto.setAccessibilityRegions(AppiumTAccessibilityRegionMapper.toTAccessibilityRegionDtoList(Arrays.asList(appiumCheckSettings.getAccessibilityRegions())));
        checkSettingsDto.setAccessibilitySettings(null);
        checkSettingsDto.setMatchLevel(appiumCheckSettings.getMatchLevel() == null ? null : appiumCheckSettings.getMatchLevel().getName());
        checkSettingsDto.setRetryTimeout(config.getMatchTimeout());
        checkSettingsDto.setSendDom(appiumCheckSettings.isSendDom());
        checkSettingsDto.setUseDom(appiumCheckSettings.isUseDom());
        checkSettingsDto.setEnablePatterns(appiumCheckSettings.isEnablePatterns());
        checkSettingsDto.setIgnoreCaret(appiumCheckSettings.getIgnoreCaret());
        checkSettingsDto.setUfgOptions(VisualGridOptionMapper.toVisualGridOptionDtoList((List)appiumCheckSettings.getVisualGridOptions()));
        checkSettingsDto.setLayoutBreakpoints(null);
        checkSettingsDto.setDisableBrowserFetching(appiumCheckSettings.isDisableBrowserFetching());
        checkSettingsDto.setAutProxy(ProxyMapper.toAutProxyDto((AutProxySettings)config.getAutProxy()));
        checkSettingsDto.setHooks(appiumCheckSettings.getScriptHooks());
        checkSettingsDto.setType(NMGOptionsMapper.toNMGOptionsMapperDtoList(appiumCheckSettings.getNMGOptions()) == null ? null : ManagerType.CLASSIC.value);
        return checkSettingsDto;
    }
}

