/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.appium;

import com.applitools.ICheckSettings;
import com.applitools.eyes.AbstractProxySettings;
import com.applitools.eyes.BatchInfo;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesRunner;
import com.applitools.eyes.IEyesBase;
import com.applitools.eyes.ImageMatchSettings;
import com.applitools.eyes.LogHandler;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchLevel;
import com.applitools.eyes.ProxySettings;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.SessionType;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.WebDriverProxySettings;
import com.applitools.eyes.appium.AppiumCheckSettingsMapper;
import com.applitools.eyes.appium.AppiumRunner;
import com.applitools.eyes.appium.Target;
import com.applitools.eyes.config.Configuration;
import com.applitools.eyes.exceptions.TestFailedException;
import com.applitools.eyes.locators.BaseOcrRegion;
import com.applitools.eyes.locators.TextRegion;
import com.applitools.eyes.locators.TextRegionSettings;
import com.applitools.eyes.locators.VisualLocatorSettings;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.selenium.ClassicRunner;
import com.applitools.eyes.selenium.positioning.ImageRotation;
import com.applitools.eyes.selenium.universal.dto.DriverTargetDto;
import com.applitools.eyes.selenium.universal.mapper.DriverMapper;
import com.applitools.eyes.universal.dto.CheckSettingsDto;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.DesiredCapabilities;

public class Eyes
implements IEyesBase {
    private com.applitools.eyes.selenium.Eyes originEyes;

    public static void setNMGCapabilities(DesiredCapabilities caps) {
        Eyes.setNMGCapabilities(caps, null, null, null);
    }

    public static void setNMGCapabilities(DesiredCapabilities caps, String apiKey) {
        Eyes.setNMGCapabilities(caps, apiKey, null, null);
    }

    public static void setNMGCapabilities(DesiredCapabilities caps, String apiKey, String eyesServerUrl) {
        Eyes.setNMGCapabilities(caps, apiKey, eyesServerUrl, null);
    }

    public static void setNMGCapabilities(DesiredCapabilities caps, String apiKey, String eyesServerUrl, ProxySettings proxySettings) {
        String proxyFromEnv;
        String iosCapsKey = "processArguments";
        String iosCapValue = "{\"args\": [], \"env\":{\"DYLD_INSERT_LIBRARIES\":\"@executable_path/Frameworks/UFG_lib.xcframework/ios-arm64/UFG_lib.framework/UFG_lib:@executable_path/Frameworks/UFG_lib.xcframework/ios-arm64_x86_64-simulator/UFG_lib.framework/UFG_lib\"";
        String iosCapValueSuffix = "}}";
        String androidCapKey = "optionalIntentArguments";
        String androidCapValue = "--es APPLITOOLS '{";
        String androidCapValueSuffix = "}'";
        if (apiKey == null && ((apiKey = GeneralUtils.getEnvString((String)"APPLITOOLS_API_KEY")) == null || apiKey.equalsIgnoreCase(""))) {
            throw new EyesException("No API key was given, or is an empty string.");
        }
        androidCapValue = androidCapValue + "\"NML_API_KEY\":\"" + apiKey + "\"";
        iosCapValue = iosCapValue + ",\"NML_API_KEY\":\"" + apiKey + "\"";
        if (eyesServerUrl == null) {
            String envVar = GeneralUtils.getEnvString((String)"APPLITOOLS_SERVER_URL");
            String string = eyesServerUrl = envVar != null ? envVar : "https://eyesapi.applitools.com";
        }
        if (eyesServerUrl != null && !eyesServerUrl.equalsIgnoreCase("")) {
            androidCapValue = androidCapValue + ",\"NML_SERVER_URL\":\"" + eyesServerUrl + "\"";
            iosCapValue = iosCapValue + ",\"NML_SERVER_URL\":\"" + eyesServerUrl + "\"";
        }
        if (proxySettings == null && (proxyFromEnv = GeneralUtils.getEnvString((String)"APPLITOOLS_HTTP_PROXY")) != null && !proxyFromEnv.equalsIgnoreCase("")) {
            proxySettings = new ProxySettings(proxyFromEnv);
        }
        if (proxySettings != null) {
            androidCapValue = androidCapValue + ",\"NML_PROXY_URL\":\"" + proxySettings + "\"";
            iosCapValue = iosCapValue + ",\"NML_PROXY_URL\":\"" + proxySettings + "\"";
        }
        androidCapValue = androidCapValue + androidCapValueSuffix;
        iosCapValue = iosCapValue + iosCapValueSuffix;
        caps.setCapability(androidCapKey, androidCapValue);
        caps.setCapability(iosCapsKey, iosCapValue);
    }

    public static void setMobileCapabilities(DesiredCapabilities caps) {
        Eyes.setMobileCapabilities(caps, null, null, null);
    }

    public static void setMobileCapabilities(DesiredCapabilities caps, String apiKey) {
        Eyes.setMobileCapabilities(caps, apiKey, null, null);
    }

    public static void setMobileCapabilities(DesiredCapabilities caps, String apiKey, String eyesServerUrl) {
        Eyes.setMobileCapabilities(caps, apiKey, eyesServerUrl, null);
    }

    public static void setMobileCapabilities(DesiredCapabilities caps, String apiKey, String eyesServerUrl, ProxySettings proxySettings) {
        String proxyFromEnv;
        String iosCapsKey = "processArguments";
        String iosCapValue = "{\"args\": [], \"env\":{\"DYLD_INSERT_LIBRARIES\":\"@executable_path/Frameworks/Applitools_iOS.xcframework/ios-arm64/Applitools_iOS.framework/Applitools_iOS:@executable_path/Frameworks/Applitools_iOS.xcframework/ios-arm64_x86_64-simulator/Applitools_iOS.framework/Applitools_iOS\"";
        String iosCapValueSuffix = "}}";
        String androidCapKey = "optionalIntentArguments";
        String androidCapValue = "--es APPLITOOLS '{";
        String androidCapValueSuffix = "}'";
        if (apiKey == null && ((apiKey = GeneralUtils.getEnvString((String)"APPLITOOLS_API_KEY")) == null || apiKey.equalsIgnoreCase(""))) {
            throw new EyesException("No API key was given, or is an empty string.");
        }
        androidCapValue = androidCapValue + "\"APPLITOOLS_API_KEY\":\"" + apiKey + "\"";
        iosCapValue = iosCapValue + ",\"APPLITOOLS_API_KEY\":\"" + apiKey + "\"";
        if (eyesServerUrl == null) {
            String envVar = GeneralUtils.getEnvString((String)"APPLITOOLS_SERVER_URL");
            String string = eyesServerUrl = envVar != null ? envVar : "https://eyesapi.applitools.com";
        }
        if (eyesServerUrl != null && !eyesServerUrl.equalsIgnoreCase("")) {
            androidCapValue = androidCapValue + ",\"APPLITOOLS_SERVER_URL\":\"" + eyesServerUrl + "\"";
            iosCapValue = iosCapValue + ",\"APPLITOOLS_SERVER_URL\":\"" + eyesServerUrl + "\"";
        }
        if (proxySettings == null && (proxyFromEnv = GeneralUtils.getEnvString((String)"APPLITOOLS_HTTP_PROXY")) != null && !proxyFromEnv.equalsIgnoreCase("")) {
            proxySettings = new ProxySettings(proxyFromEnv);
        }
        if (proxySettings != null) {
            androidCapValue = androidCapValue + ",\"APPLITOOLS_PROXY_URL\":\"" + proxySettings + "\"";
            iosCapValue = iosCapValue + ",\"APPLITOOLS_PROXY_URL\":\"" + proxySettings + "\"";
        }
        androidCapValue = androidCapValue + androidCapValueSuffix;
        iosCapValue = iosCapValue + iosCapValueSuffix;
        caps.setCapability(androidCapKey, androidCapValue);
        caps.setCapability(iosCapsKey, iosCapValue);
    }

    public Eyes() {
        this.originEyes = new com.applitools.eyes.selenium.Eyes((EyesRunner)new AppiumRunner());
    }

    public Eyes(EyesRunner runner0) {
        if (runner0.getClass() == ClassicRunner.class) {
            String warning = GeneralUtils.createEyesMessageWithLevel((String)"Eyes Appium was run with ClassicRunner. We recommend using AppiumRunner for full compatibility.", (String)"warning");
            System.out.println(warning);
        }
        this.originEyes = new com.applitools.eyes.selenium.Eyes(runner0);
    }

    public com.applitools.eyes.selenium.Configuration getConfiguration() {
        return this.originEyes.getConfiguration();
    }

    public void setConfiguration(Configuration configuration) {
        configuration.setUseCeilForViewportSize(Boolean.valueOf(true));
        this.originEyes.setConfiguration(configuration);
    }

    public Configuration configure() {
        return this.originEyes.configure();
    }

    public String getApiKey() {
        return this.configure().getApiKey();
    }

    public void setApiKey(String apiKey) {
        this.configure().setApiKey(apiKey);
    }

    public URI getServerUrl() {
        return this.originEyes.getServerUrl();
    }

    public void setServerUrl(String serverUrl) {
        this.configure().setServerUrl(serverUrl);
    }

    public void setServerUrl(URI serverUri) {
        this.configure().setServerUrl(serverUri.toString());
    }

    public void setProxy(AbstractProxySettings proxySettings) {
        this.originEyes.setProxy(proxySettings);
    }

    public AbstractProxySettings getProxy() {
        return this.originEyes.getProxy();
    }

    public void setIsDisabled(Boolean isDisabled) {
        this.configure().setIsDisabled(isDisabled);
    }

    public Boolean getIsDisabled() {
        return this.configure().getIsDisabled();
    }

    public ImageRotation getRotation() {
        return this.originEyes.getRotation();
    }

    public void setRotation(ImageRotation rotation) {
        this.originEyes.setRotation(rotation);
    }

    public void setForceFullPageScreenshot(boolean shouldForce) {
        this.configure().setForceFullPageScreenshot(shouldForce);
    }

    public Boolean getForceFullPageScreenshot() {
        return this.originEyes.getForceFullPageScreenshot();
    }

    public void setMatchTimeout(int ms) {
        this.originEyes.setMatchTimeout(ms);
    }

    public Integer getMatchTimeout() {
        return this.configure().getMatchTimeout();
    }

    public void setSaveNewTests(boolean saveNewTests) {
        this.configure().setSaveNewTests(Boolean.valueOf(saveNewTests));
    }

    public Boolean getSaveNewTests() {
        return this.configure().getSaveNewTests();
    }

    public void setSaveDiffs(Boolean saveDiffs) {
        this.configure().setSaveDiffs(saveDiffs);
    }

    public Boolean getSaveDiffs() {
        return this.configure().getSaveDiffs();
    }

    public void setDefaultMatchSettings(ImageMatchSettings defaultMatchSettings) {
        this.configure().setDefaultMatchSettings(defaultMatchSettings);
    }

    public ImageMatchSettings getDefaultMatchSettings() {
        return this.configure().getDefaultMatchSettings();
    }

    public Integer getStitchOverlap() {
        return this.configure().getStitchOverlap();
    }

    public void setStitchOverlap(int pixels) {
        this.configure().setStitchOverlap(Integer.valueOf(pixels));
    }

    public void setBranchName(String branchName) {
        this.configure().setBranchName(branchName);
    }

    public String getBranchName() {
        return this.configure().getBranchName();
    }

    public void setParentBranchName(String branchName) {
        this.configure().setParentBranchName(branchName);
    }

    public String getParentBranchName() {
        return this.configure().getParentBranchName();
    }

    public Configuration setBatch(BatchInfo batch) {
        return this.configure().setBatch(batch);
    }

    public BatchInfo getBatch() {
        return this.configure().getBatch();
    }

    public void setAgentId(String agentId) {
        this.configure().setAgentId(agentId);
    }

    public String getAgentId() {
        return this.configure().getAgentId();
    }

    public String getFullAgentId() {
        return this.originEyes.getFullAgentId();
    }

    public void setHostOS(String hostOS) {
        this.configure().setHostOS(hostOS);
    }

    public String getHostOS() {
        return this.configure().getHostOS();
    }

    public void setHostApp(String hostApp) {
        this.configure().setHostApp(hostApp);
    }

    public String getHostApp() {
        return this.configure().getHostOS();
    }

    public Boolean getIgnoreCaret() {
        return this.configure().getIgnoreCaret();
    }

    public void setIgnoreCaret(boolean value) {
        this.configure().setIgnoreCaret(Boolean.valueOf(value));
    }

    public void setMatchLevel(MatchLevel matchLevel) {
        this.configure().getDefaultMatchSettings().setMatchLevel(matchLevel);
    }

    public MatchLevel getMatchLevel() {
        return this.configure().getDefaultMatchSettings().getMatchLevel();
    }

    public void setEnvName(String envName) {
        this.configure().setEnvironmentName(envName);
    }

    public String getEnvName() {
        return this.configure().getEnvironmentName();
    }

    public void setBaselineEnvName(String baselineEnvName) {
        this.configure().setBaselineEnvName(baselineEnvName);
    }

    public String getBaselineEnvName() {
        return this.configure().getBaselineEnvName();
    }

    public void setBaselineBranchName(String branchName) {
        this.configure().setBaselineBranchName(branchName);
    }

    public String getBaselineBranchName() {
        return this.configure().getBaselineBranchName();
    }

    public void setIgnoreDisplacements(boolean isIgnoreDisplacements) {
        this.configure().setIgnoreDisplacements(Boolean.valueOf(isIgnoreDisplacements));
    }

    public Boolean getIgnoreDisplacements() {
        return this.configure().getIgnoreDisplacements();
    }

    public WebDriver open(WebDriver driver, Configuration configuration) {
        this.originEyes.setConfiguration(configuration);
        return this.originEyes.open(driver);
    }

    public WebDriver open(WebDriver driver, String appName, String testName, RectangleSize viewportSize) {
        return this.originEyes.open(driver, appName, testName);
    }

    public WebDriver open(WebDriver driver, String appName, String testName) {
        return this.originEyes.open(driver, appName, testName);
    }

    protected WebDriver open(WebDriver driver, String appName, String testName, RectangleSize viewportSize, SessionType sessionType) {
        return this.originEyes.open(driver, appName, testName, viewportSize);
    }

    public boolean getIsOpen() {
        return this.originEyes.getIsOpen();
    }

    public void checkWindow() {
        this.checkWindow(null);
    }

    public void checkWindow(String tag) {
        this.check(tag, (ICheckSettings)Target.window());
    }

    public void checkWindow(int matchTimeout, String tag) {
        this.check(tag, Target.window().timeout(matchTimeout));
    }

    public void checkWindow(String tag, boolean fully) {
        this.check(tag, (ICheckSettings)Target.window().fully(fully));
    }

    public void check(String name, ICheckSettings checkSettings) {
        if (Boolean.TRUE.equals(this.getIsDisabled())) {
            return;
        }
        ArgumentGuard.notNull((Object)checkSettings, (String)"checkSettings");
        checkSettings = checkSettings.withName(name);
        this.check(checkSettings);
    }

    @Deprecated
    public void setScrollToRegion(boolean shouldScroll) {
    }

    @Deprecated
    public boolean getScrollToRegion() {
        return this.originEyes.getScrollToRegion();
    }

    public boolean shouldStitchContent() {
        return this.originEyes.shouldStitchContent();
    }

    public PositionProvider getPositionProvider() {
        return this.originEyes.getPositionProvider();
    }

    public void setPositionProvider(PositionProvider positionProvider) {
        this.originEyes.setPositionProvider(positionProvider);
    }

    public void setLogHandler(LogHandler logHandler) {
        this.originEyes.setLogHandler(logHandler);
    }

    public LogHandler getLogHandler() {
        return this.originEyes.getLogHandler();
    }

    public Logger getLogger() {
        return this.originEyes.getLogger();
    }

    public void addProperty(String name, String value) {
        this.originEyes.addProperty(name, value);
    }

    public void clearProperties() {
        this.originEyes.clearProperties();
    }

    public void setSaveDebugScreenshots(Boolean saveDebugScreenshots) {
        this.originEyes.setSaveDebugScreenshots(saveDebugScreenshots);
    }

    public Boolean getSaveDebugScreenshots() {
        return this.originEyes.getSaveDebugScreenshots();
    }

    public String getBaseAgentId() {
        return this.configure().getAgentId();
    }

    public WebDriver getDriver() {
        return this.originEyes.getDriver();
    }

    public double getDevicePixelRatio() {
        return this.originEyes.getDevicePixelRatio();
    }

    public void check(ICheckSettings ... checkSettings) {
        this.originEyes.check(checkSettings);
    }

    public void check(ICheckSettings checkSettings) {
        CheckSettingsDto checkSettingsDto = AppiumCheckSettingsMapper.toCheckSettingsDto(checkSettings, this.configure());
        DriverTargetDto driverTargetDto = DriverMapper.toDriverTargetDto((WebDriver)this.getDriver(), (WebDriverProxySettings)this.configure().getWebDriverProxy());
        this.checkDto(checkSettingsDto, driverTargetDto);
    }

    private void checkDto(CheckSettingsDto checkSettingsDto, DriverTargetDto driverTargetDto) throws EyesException {
        try {
            Method checkDto = this.originEyes.getClass().getDeclaredMethod("checkDto", CheckSettingsDto.class, DriverTargetDto.class);
            checkDto.setAccessible(true);
            checkDto.invoke((Object)this.originEyes, checkSettingsDto, driverTargetDto);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            System.out.println("Got a failure trying to activate checkDTO using reflection! Error " + e.getMessage());
            throw new EyesException("Got a failure trying to activate checkDTO using reflection! Error " + e.getMessage());
        }
        catch (Exception e) {
            String errorMessage = GeneralUtils.createErrorMessageFromExceptionWithText((Exception)e, (String)"Got a failure trying to perform a 'check'!");
            System.out.println(errorMessage);
            throw new EyesException(errorMessage, (Throwable)e);
        }
    }

    public void checkElement(WebElement element) {
        this.originEyes.checkElement(element);
    }

    public void checkElement(WebElement element, String tag) {
        this.originEyes.checkElement(element, tag);
    }

    public void checkElement(WebElement element, int matchTimeout, String tag) {
        this.originEyes.checkElement(element, matchTimeout, tag);
    }

    public void checkElement(By selector) {
        this.originEyes.checkElement(selector);
    }

    public void checkElement(By selector, String tag) {
        this.originEyes.checkElement(selector, tag);
    }

    public void checkElement(By selector, int matchTimeout, String tag) {
        this.originEyes.checkElement(selector, matchTimeout, tag);
    }

    public void checkRegion(Region region) {
        this.originEyes.checkRegion(region);
    }

    public void checkRegion(Region region, int matchTimeout, String tag) throws TestFailedException {
        this.originEyes.checkRegion(region, matchTimeout, tag);
    }

    public void checkRegion(WebElement element) {
        this.originEyes.checkRegion(element);
    }

    public void checkRegion(WebElement element, String tag, boolean stitchContent) {
        this.originEyes.checkRegion(element, tag, stitchContent);
    }

    public void checkRegion(WebElement element, int matchTimeout, String tag) {
        this.originEyes.checkRegion(element, matchTimeout, tag);
    }

    public void checkRegion(WebElement element, int matchTimeout, String tag, boolean stitchContent) {
        this.originEyes.checkRegion(element, matchTimeout, tag, stitchContent);
    }

    public void checkRegion(By selector) {
        this.originEyes.checkRegion(selector);
    }

    public void checkRegion(By selector, boolean stitchContent) {
        this.originEyes.checkRegion(selector, stitchContent);
    }

    public void checkRegion(By selector, String tag) {
        this.originEyes.checkRegion(selector, tag);
    }

    public void checkRegion(By selector, String tag, boolean stitchContent) {
        this.originEyes.checkRegion(selector, tag, stitchContent);
    }

    public void checkRegion(By selector, int matchTimeout, String tag) {
        this.originEyes.checkRegion(selector, matchTimeout, tag);
    }

    public void checkRegion(By selector, int matchTimeout, String tag, boolean stitchContent) {
        this.originEyes.checkRegion(selector, matchTimeout, tag, stitchContent);
    }

    public Map<String, List<Region>> locate(VisualLocatorSettings visualLocatorSettings) {
        return this.originEyes.locate(visualLocatorSettings);
    }

    public Map<String, List<TextRegion>> extractTextRegions(TextRegionSettings textRegionSettings) {
        return this.originEyes.extractTextRegions(textRegionSettings);
    }

    public List<String> extractText(BaseOcrRegion ... ocrRegions) {
        return this.originEyes.extractText(ocrRegions);
    }

    public TestResults close() {
        return this.originEyes.close();
    }

    public TestResults close(boolean shouldThrowException) {
        return this.originEyes.close(shouldThrowException);
    }

    public void closeAsync() {
        this.originEyes.closeAsync();
    }

    public TestResults abortIfNotClosed() {
        return this.abort();
    }

    public TestResults abort() {
        return this.originEyes.abort();
    }

    public void abortAsync() {
        this.originEyes.abortAsync();
    }

    @Deprecated
    protected Configuration getConfigurationInstance() {
        return this.configure();
    }

    public void setScaleRatio(Double scaleRatio) {
        this.originEyes.setScaleRatio(scaleRatio);
    }

    public Double getScaleRatio() {
        return this.originEyes.getScaleRatio();
    }
}

