/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.appium;

import com.applitools.eyes.Region;
import com.applitools.eyes.appium.AppiumSelectorRegionMapper;
import com.applitools.eyes.fluent.GetRegion;
import com.applitools.eyes.fluent.SimpleRegionByRectangle;
import com.applitools.eyes.selenium.fluent.SimpleRegionByElement;
import com.applitools.eyes.selenium.fluent.SimpleRegionBySelector;
import com.applitools.eyes.selenium.universal.dto.ElementRegionDto;
import com.applitools.eyes.selenium.universal.mapper.ElementRegionMapper;
import com.applitools.eyes.universal.dto.CodedRegionReference;
import com.applitools.eyes.universal.dto.RectangleRegionDto;
import com.applitools.eyes.universal.dto.SelectorRegionDto;
import com.applitools.eyes.universal.dto.TRegion;
import com.applitools.eyes.universal.mapper.RectangleRegionMapper;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openqa.selenium.WebElement;

public class AppiumCodedRegionReferenceMapper {
    public static CodedRegionReference toCodedRegionReference(GetRegion getSimpleRegion) {
        if (getSimpleRegion == null) {
            return null;
        }
        CodedRegionReference codedRegionReference = new CodedRegionReference();
        if (getSimpleRegion instanceof SimpleRegionByRectangle) {
            SimpleRegionByRectangle simpleRegionByRectangle = (SimpleRegionByRectangle)getSimpleRegion;
            RectangleRegionDto region = RectangleRegionMapper.toRectangleRegionDto((Region)simpleRegionByRectangle.getRegion());
            codedRegionReference.setRegion((TRegion)region);
            codedRegionReference.setRegionId(simpleRegionByRectangle.getRegion().getRegionId());
        } else if (getSimpleRegion instanceof SimpleRegionByElement) {
            SimpleRegionByElement simpleRegionByElement = (SimpleRegionByElement)getSimpleRegion;
            ElementRegionDto region = ElementRegionMapper.toElementRegionDto((WebElement)simpleRegionByElement.getElement());
            codedRegionReference.setRegion((TRegion)region);
            codedRegionReference.setRegionId(simpleRegionByElement.getRegionId());
        } else if (getSimpleRegion instanceof SimpleRegionBySelector) {
            SimpleRegionBySelector simpleRegionBySelector = (SimpleRegionBySelector)getSimpleRegion;
            SelectorRegionDto region = AppiumSelectorRegionMapper.toAppiumSelectorRegionDto(simpleRegionBySelector.getSelector());
            codedRegionReference.setRegion((TRegion)region);
            codedRegionReference.setRegionId(simpleRegionBySelector.getRegionId());
        }
        return codedRegionReference;
    }

    public static List<CodedRegionReference> toCodedRegionReferenceList(List<GetRegion> getSimpleRegionList) {
        if (getSimpleRegionList == null || getSimpleRegionList.isEmpty()) {
            return null;
        }
        return getSimpleRegionList.stream().filter(Objects::nonNull).map(AppiumCodedRegionReferenceMapper::toCodedRegionReference).collect(Collectors.toList());
    }
}

