/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.appium;

import com.applitools.eyes.AccessibilityRegionType;
import com.applitools.eyes.LazyLoadOptions;
import com.applitools.eyes.Region;
import com.applitools.eyes.appium.ElementType;
import com.applitools.eyes.fluent.CheckSettings;
import com.applitools.eyes.fluent.GetRegion;
import com.applitools.eyes.selenium.fluent.AccessibilityRegionByElement;
import com.applitools.eyes.selenium.fluent.AccessibilityRegionBySelector;
import com.applitools.eyes.selenium.fluent.FloatingRegionByElement;
import com.applitools.eyes.selenium.fluent.FloatingRegionBySelector;
import com.applitools.eyes.selenium.fluent.SimpleRegionByElement;
import com.applitools.eyes.selenium.fluent.SimpleRegionBySelector;
import com.applitools.eyes.serializers.BySerializer;
import com.applitools.eyes.serializers.WebElementSerializer;
import com.applitools.eyes.visualgrid.model.NMGOptions;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class AppiumCheckSettings
extends CheckSettings {
    @JsonSerialize(using=BySerializer.class)
    private By targetSelector;
    @JsonSerialize(using=WebElementSerializer.class)
    private WebElement targetElement;
    @JsonSerialize(using=BySerializer.class)
    private By cutElementSelector;
    private ElementType cutElementType;
    private Boolean statusBarExists;
    private String scrollRootElementId;
    @JsonSerialize(using=BySerializer.class)
    private By scrollRootElementSelector;
    @JsonSerialize(using=WebElementSerializer.class)
    private WebElement scrollRootElement;
    private Boolean captureStatusBar;
    private String pageId;
    private Boolean isDefaultWebview;
    private String webview;
    private List<NMGOptions> nmgOptions = new ArrayList<NMGOptions>();
    private Boolean useSystemScreenshot;

    protected AppiumCheckSettings() {
    }

    protected AppiumCheckSettings(Region region) {
        super(region);
    }

    protected AppiumCheckSettings(By selector) {
        this.targetSelector = selector;
    }

    protected AppiumCheckSettings(WebElement webElement) {
        this.targetElement = webElement;
    }

    protected AppiumCheckSettings(boolean isWebView) {
        this.isDefaultWebview = isWebView;
    }

    protected AppiumCheckSettings(String webview) {
        this.webview = webview;
        this.isDefaultWebview = false;
    }

    public AppiumCheckSettings clone() {
        AppiumCheckSettings clone = new AppiumCheckSettings();
        super.populateClone((CheckSettings)clone);
        clone.targetSelector = this.targetSelector;
        clone.targetElement = this.targetElement;
        clone.cutElementSelector = this.cutElementSelector;
        clone.cutElementType = this.cutElementType;
        clone.scrollRootElementId = this.scrollRootElementId;
        clone.scrollRootElementSelector = this.scrollRootElementSelector;
        clone.scrollRootElement = this.scrollRootElement;
        clone.captureStatusBar = this.captureStatusBar;
        clone.pageId = this.pageId;
        clone.isDefaultWebview = this.isDefaultWebview;
        clone.webview = this.webview;
        clone.nmgOptions = this.nmgOptions;
        clone.useSystemScreenshot = this.useSystemScreenshot;
        return clone;
    }

    public AppiumCheckSettings layout(By regionSelector, By ... regionSelectors) {
        AppiumCheckSettings clone = this.clone();
        clone.layout_((GetRegion)new SimpleRegionBySelector(regionSelector));
        for (By selector : regionSelectors) {
            clone.layout_((GetRegion)new SimpleRegionBySelector(selector));
        }
        return clone;
    }

    public AppiumCheckSettings layout(WebElement[] elements) {
        AppiumCheckSettings clone = this.clone();
        for (WebElement e : elements) {
            clone.layout_((GetRegion)new SimpleRegionByElement(e));
        }
        return clone;
    }

    public AppiumCheckSettings layout(WebElement element, WebElement ... elements) {
        AppiumCheckSettings clone = this.clone();
        clone.layout_((GetRegion)new SimpleRegionByElement(element));
        for (WebElement e : elements) {
            clone.layout_((GetRegion)new SimpleRegionByElement(e));
        }
        return clone;
    }

    public AppiumCheckSettings ignore(By regionSelector, By ... regionSelectors) {
        AppiumCheckSettings clone = this.clone();
        clone.ignore_((GetRegion)new SimpleRegionBySelector(regionSelector));
        for (By selector : regionSelectors) {
            clone.ignore_((GetRegion)new SimpleRegionBySelector(selector));
        }
        return clone;
    }

    public AppiumCheckSettings ignore(WebElement element, WebElement ... elements) {
        AppiumCheckSettings clone = this.clone();
        clone.ignore_((GetRegion)new SimpleRegionByElement(element));
        for (WebElement e : elements) {
            clone.ignore_((GetRegion)new SimpleRegionByElement(e));
        }
        return clone;
    }

    public AppiumCheckSettings ignore(WebElement[] elements) {
        AppiumCheckSettings clone = this.clone();
        for (WebElement e : elements) {
            clone.ignore_((GetRegion)new SimpleRegionByElement(e));
        }
        return clone;
    }

    public AppiumCheckSettings strict(By regionSelector, By ... regionSelectors) {
        AppiumCheckSettings clone = this.clone();
        clone.strict_((GetRegion)new SimpleRegionBySelector(regionSelector));
        for (By selector : regionSelectors) {
            clone.strict_((GetRegion)new SimpleRegionBySelector(selector));
        }
        return clone;
    }

    public AppiumCheckSettings strict(WebElement element, WebElement ... elements) {
        AppiumCheckSettings clone = this.clone();
        clone.strict_((GetRegion)new SimpleRegionByElement(element));
        for (WebElement e : elements) {
            clone.strict_((GetRegion)new SimpleRegionByElement(e));
        }
        return clone;
    }

    public AppiumCheckSettings strict(WebElement[] elements) {
        AppiumCheckSettings clone = this.clone();
        for (WebElement e : elements) {
            clone.strict_((GetRegion)new SimpleRegionByElement(e));
        }
        return clone;
    }

    public AppiumCheckSettings content(By regionSelector, By ... regionSelectors) {
        AppiumCheckSettings clone = this.clone();
        clone.content_((GetRegion)new SimpleRegionBySelector(regionSelector));
        for (By selector : regionSelectors) {
            clone.content_((GetRegion)new SimpleRegionBySelector(selector));
        }
        return clone;
    }

    public AppiumCheckSettings content(WebElement element, WebElement ... elements) {
        AppiumCheckSettings clone = this.clone();
        clone.content_((GetRegion)new SimpleRegionByElement(element));
        for (WebElement e : elements) {
            clone.content_((GetRegion)new SimpleRegionByElement(e));
        }
        return clone;
    }

    public AppiumCheckSettings content(WebElement[] elements) {
        AppiumCheckSettings clone = this.clone();
        for (WebElement e : elements) {
            clone.content_((GetRegion)new SimpleRegionByElement(e));
        }
        return clone;
    }

    public AppiumCheckSettings floating(By regionSelector, int maxUpOffset, int maxDownOffset, int maxLeftOffset, int maxRightOffset) {
        AppiumCheckSettings clone = this.clone();
        clone.floating((GetRegion)new FloatingRegionBySelector(regionSelector, maxUpOffset, maxDownOffset, maxLeftOffset, maxRightOffset));
        return clone;
    }

    public AppiumCheckSettings floating(WebElement element, int maxUpOffset, int maxDownOffset, int maxLeftOffset, int maxRightOffset) {
        AppiumCheckSettings clone = this.clone();
        clone.floating((GetRegion)new FloatingRegionByElement(element, maxUpOffset, maxDownOffset, maxLeftOffset, maxRightOffset));
        return clone;
    }

    public AppiumCheckSettings accessibility(By regionSelector, AccessibilityRegionType regionType) {
        AppiumCheckSettings clone = this.clone();
        clone.accessibility_((GetRegion)new AccessibilityRegionBySelector(regionSelector, regionType));
        return clone;
    }

    public AppiumCheckSettings accessibility(WebElement element, AccessibilityRegionType regionType) {
        AppiumCheckSettings clone = this.clone();
        clone.accessibility((GetRegion)new AccessibilityRegionByElement(element, regionType));
        return clone;
    }

    public AppiumCheckSettings accessibility(AccessibilityRegionType regionType, WebElement[] elementsToIgnore) {
        AppiumCheckSettings clone = this.clone();
        for (WebElement element : elementsToIgnore) {
            clone.accessibility((GetRegion)new AccessibilityRegionByElement(element, regionType));
        }
        return clone;
    }

    public AppiumCheckSettings cut(@Nonnull ElementType type, @Nonnull By selector) {
        AppiumCheckSettings clone = this.clone();
        clone.cutElementSelector = selector;
        clone.cutElementType = type;
        return clone;
    }

    public ElementType getCutElementType() {
        return this.cutElementType;
    }

    public By getCutElementSelector() {
        return this.cutElementSelector;
    }

    public AppiumCheckSettings statusBarExists() {
        AppiumCheckSettings clone = this.clone();
        clone.statusBarExists = true;
        return clone;
    }

    public AppiumCheckSettings statusBarExists(boolean statusBarExists) {
        AppiumCheckSettings clone = this.clone();
        clone.statusBarExists = statusBarExists;
        return clone;
    }

    public Boolean getStatusBarExists() {
        return this.statusBarExists;
    }

    public By getTargetSelector() {
        return this.targetSelector;
    }

    public WebElement getTargetElement() {
        return this.targetElement;
    }

    public AppiumCheckSettings fully() {
        return (AppiumCheckSettings)super.fully();
    }

    public AppiumCheckSettings fully(Boolean fully) {
        return (AppiumCheckSettings)super.fully(fully);
    }

    public AppiumCheckSettings scrollRootElement(String elementId) {
        AppiumCheckSettings clone = this.clone();
        clone.scrollRootElementId = elementId;
        return clone;
    }

    public AppiumCheckSettings scrollRootElement(By selector) {
        AppiumCheckSettings clone = this.clone();
        clone.scrollRootElementSelector = selector;
        return clone;
    }

    public AppiumCheckSettings scrollRootElement(WebElement element) {
        AppiumCheckSettings clone = this.clone();
        clone.scrollRootElement = element;
        return clone;
    }

    public AppiumCheckSettings captureStatusBar() {
        AppiumCheckSettings clone = this.clone();
        clone.captureStatusBar = true;
        return clone;
    }

    public AppiumCheckSettings captureStatusBar(boolean captureStatusBar) {
        AppiumCheckSettings clone = this.clone();
        clone.captureStatusBar = captureStatusBar;
        return clone;
    }

    public String getScrollRootElementId() {
        return this.scrollRootElementId;
    }

    public By getScrollRootElementSelector() {
        return this.scrollRootElementSelector;
    }

    public WebElement getScrollRootElement() {
        return this.scrollRootElement;
    }

    public Boolean getCaptureStatusBar() {
        return this.captureStatusBar;
    }

    public boolean isNotRegion() {
        return this.getTargetRegion() == null && this.getTargetElement() == null && this.getTargetSelector() == null;
    }

    public AppiumCheckSettings pageId(String pageId) {
        AppiumCheckSettings clone = this.clone();
        clone.pageId = pageId;
        return clone;
    }

    public String getPageId() {
        return this.pageId;
    }

    public AppiumCheckSettings lazyLoad() {
        return (AppiumCheckSettings)super.lazyLoad();
    }

    public AppiumCheckSettings lazyLoad(LazyLoadOptions lazyLoadOptions) {
        return (AppiumCheckSettings)super.lazyLoad(lazyLoadOptions);
    }

    public LazyLoadOptions getLazyLoadOptions() {
        return super.getLazyLoadOptions();
    }

    public AppiumCheckSettings densityMetrics(int xDpi, int yDpi) {
        return (AppiumCheckSettings)super.densityMetrics(xDpi, yDpi);
    }

    public AppiumCheckSettings densityMetrics(int xDpi, int yDpi, Double scaleRatio) {
        return (AppiumCheckSettings)super.densityMetrics(xDpi, yDpi, scaleRatio);
    }

    public AppiumCheckSettings webview() {
        AppiumCheckSettings clone = this.clone();
        clone.isDefaultWebview = true;
        return clone;
    }

    public AppiumCheckSettings webview(Boolean isWebView) {
        AppiumCheckSettings clone = this.clone();
        clone.isDefaultWebview = isWebView;
        return clone;
    }

    public AppiumCheckSettings webview(String webView) {
        AppiumCheckSettings clone = this.clone();
        clone.isDefaultWebview = false;
        clone.webview = webView;
        return clone;
    }

    public Boolean getIsDefaultWebview() {
        return this.isDefaultWebview;
    }

    public String getWebview() {
        return this.webview;
    }

    public List<NMGOptions> getNMGOptions() {
        return this.nmgOptions;
    }

    public AppiumCheckSettings NMGOptions(NMGOptions ... options) {
        AppiumCheckSettings clone = this.clone();
        clone.nmgOptions.clear();
        if (options != null) {
            clone.nmgOptions.addAll(Arrays.asList(options));
            clone.nmgOptions.remove(null);
        }
        return clone;
    }

    public Boolean getScreenshotMode() {
        return this.useSystemScreenshot;
    }

    public AppiumCheckSettings useSystemScreenshot() {
        AppiumCheckSettings clone = this.clone();
        clone.useSystemScreenshot = true;
        return clone;
    }

    public AppiumCheckSettings useSystemScreenshot(Boolean useSystemScreenshot) {
        AppiumCheckSettings clone = this.clone();
        clone.useSystemScreenshot = useSystemScreenshot;
        return clone;
    }
}

