package com.applitools.eyes.appium;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.selenium.universal.mapper.SelectorRegionMapper;
import com.applitools.eyes.universal.dto.SelectorRegionDto;
import com.applitools.utils.GeneralUtils;
import io.appium.java_client.AppiumBy;
import org.openqa.selenium.By;

import java.lang.reflect.Field;
import java.util.List;

public class AppiumSelectorRegionMapper {

  public static SelectorRegionDto toAppiumSelectorRegionDto(By by) {
    if (by == null) {
      return null;
    }

    String byClassName = by.getClass().getName();
    if (byClassName.equals("io.appium.java_client.pagefactory.bys.builder.ByAll") ||
            byClassName.equals("org.openqa.selenium.support.pagefactory.ByAll")){
      return toAppiumSelectorRegionDto_ByAll(by);
    } else if (byClassName.equals("io.appium.java_client.pagefactory.bys.builder.ByChained") ||
            byClassName.equals("org.openqa.selenium.support.pagefactory.ByChained")) {
      return toAppiumSelectorRegionDto_ByChained(by);
    }
    return toDto(by);
  }

  private static SelectorRegionDto toDto(By by) {
    SelectorRegionDto selectorRegionDto = new SelectorRegionDto();
    String selector = GeneralUtils.getLastWordOfStringWithRegex(by.toString(), ":");
    selectorRegionDto.setSelector(selector);

    if (by instanceof AppiumBy.ById) {
      selectorRegionDto.setType("id");
    } else if (by instanceof AppiumBy.ByXPath) {
      selectorRegionDto.setType("xpath");
    } else if (by instanceof AppiumBy.ByLinkText) {
      selectorRegionDto.setType("link text");
    } else if (by instanceof AppiumBy.ByPartialLinkText) {
      selectorRegionDto.setType("partial link text");
    } else if (by instanceof AppiumBy.ByName) {
      selectorRegionDto.setType("name");
    } else if (by instanceof AppiumBy.ByTagName) {
      selectorRegionDto.setType("tag name");
    } else if (by instanceof AppiumBy.ByClassName) {
      selectorRegionDto.setType("class name");
    } else if (by instanceof AppiumBy.ByCssSelector) {
      selectorRegionDto.setType("css selector");
    } else if (by instanceof AppiumBy.ByAccessibilityId) {
      selectorRegionDto.setType("accessibility id");
    } else if (by instanceof AppiumBy.ByAndroidUIAutomator) {
      selectorRegionDto.setType("-android uiautomator");
    } else if (by instanceof AppiumBy.ByAndroidViewTag) {
      selectorRegionDto.setType("-android viewtag");
    } else if ("ByIosUIAutomation".equals(by.getClass().getSimpleName())) {
      selectorRegionDto.setType("-ios uiautomation");
    } else if (by instanceof AppiumBy.ByIosNsPredicate) {
      selectorRegionDto.setType("-ios predicate string");
    } else if (by instanceof AppiumBy.ByIosClassChain) {
      selectorRegionDto.setType("-ios class chain");
    } else if (by instanceof AppiumBy.ByImage) {
      selectorRegionDto.setType("-image");
    } else if (by instanceof AppiumBy.ByCustom) {
      selectorRegionDto.setType("-custom");
    } else {
      // MobileBy was removed in Appium java-client 9.0 and no replacement for ByWindowsAutomation was provided.
      // We use reflection for backward compatibility
      String byClassName = by.getClass().getName();
      if (byClassName.equals("io.appium.java_client.MobileBy$ByWindowsAutomation")){
        selectorRegionDto.setType("-windows uiautomation");
      }
      // if there are no appium instances, try selenium
      else {
        selectorRegionDto = SelectorRegionMapper.toSelectorRegionDto(by);
      }
    }
    return selectorRegionDto;
  }

  private static SelectorRegionDto toAppiumSelectorRegionDto_ByAll(By byAll) {
    try {
      By[] bys = getBys(byAll);

      SelectorRegionDto fallback = null;
      SelectorRegionDto region = null;
      for (int i = bys.length-1; i >= 0; i--) {
        region = toDto(bys[i]);
        region.setFallback(fallback);
        fallback = region;
      }

      return region;
    } catch (NoSuchFieldException | IllegalAccessException e) {
      System.out.println("Got a failure trying to find By[] using reflection! Error " + e.getMessage());
      throw new EyesException("Got a failure trying to find By[] using reflection! Error " + e.getMessage());
    }
  }
  private static SelectorRegionDto toAppiumSelectorRegionDto_ByChained(By byChained) {
    try {
      By[] bys = getBys(byChained);
      SelectorRegionDto child = null;
      SelectorRegionDto region = null;
      for (int i = bys.length-1; i >= 0; i--) {
        region = toDto(bys[i]);
        region.setChild(child);
        child = region;
      }

      return region;
    } catch (NoSuchFieldException | IllegalAccessException e) {
      System.out.println("Got a failure trying to find By[] using reflection! Error " + e.getMessage());
      throw new EyesException("Got a failure trying to find By[] using reflection! Error " + e.getMessage());
    }
  }

  private static By[] getBys(By byMany) throws NoSuchFieldException, IllegalAccessException {
    Field bys_ = byMany.getClass().getDeclaredField("bys");
    bys_.setAccessible(true);

    By[] bys;
    Object bysObj = bys_.get(byMany);
    if (bys_.getType().isArray()){
      bys = (By[])bysObj;
    } else if (bys_.getType() == List.class && (bys_.getGenericType().toString()).equals("java.util.List<org.openqa.selenium.By>")) {
      //noinspection unchecked
      bys = ((List<By>) bysObj).toArray(new By[0]);
    }
    else {
      bys = new By[0];
    }
    return bys;
  }
}