/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.AppEnvironment;
import com.applitools.eyes.BatchInfo;
import com.applitools.eyes.ImageMatchSettings;
import com.applitools.eyes.PropertyData;
import com.applitools.eyes.SessionType;
import com.applitools.eyes.config.IConfigurationGetter;
import com.applitools.utils.ArgumentGuard;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.List;

@JsonRootName(value="startInfo")
public class SessionStartInfo {
    private String agentId;
    private SessionType sessionType;
    private String appIdOrName;
    private String verId;
    private String scenarioIdOrName;
    private BatchInfo batchInfo;
    private String baselineEnvName;
    private String environmentName;
    private AppEnvironment environment;
    private String branchName;
    private String parentBranchName;
    private String baselineBranchName;
    private Boolean saveDiffs;
    private ImageMatchSettings defaultMatchSettings;
    private List<PropertyData> properties;

    public SessionStartInfo(String agentId, SessionType sessionType, String appIdOrName, String verId, String scenarioIdOrName, BatchInfo batchInfo, String baselineEnvName, String environmentName, AppEnvironment environment, ImageMatchSettings defaultMatchSettings, String branchName, String parentBranchName, String baselineBranchName, Boolean saveDiffs, List<PropertyData> properties) {
        ArgumentGuard.notNullOrEmpty(agentId, "agentId");
        ArgumentGuard.notNullOrEmpty(appIdOrName, "appIdOrName");
        ArgumentGuard.notNullOrEmpty(scenarioIdOrName, "scenarioIdOrName");
        ArgumentGuard.notNull(batchInfo, "batchInfo");
        ArgumentGuard.notNull(environment, "environment");
        ArgumentGuard.notNull(defaultMatchSettings, "defaultMatchSettings");
        this.agentId = agentId;
        this.sessionType = sessionType;
        this.appIdOrName = appIdOrName;
        this.verId = verId;
        this.scenarioIdOrName = scenarioIdOrName;
        this.batchInfo = batchInfo;
        this.baselineEnvName = baselineEnvName;
        this.environmentName = environmentName;
        this.environment = environment;
        this.defaultMatchSettings = defaultMatchSettings;
        this.branchName = branchName;
        this.parentBranchName = parentBranchName;
        this.baselineBranchName = baselineBranchName;
        this.saveDiffs = saveDiffs;
        this.properties = properties;
    }

    public SessionStartInfo(IConfigurationGetter config, String agentId, String verId, AppEnvironment environment, ImageMatchSettings defaultMatchSettings, List<PropertyData> properties) {
        ArgumentGuard.notNull(config, "config");
        ArgumentGuard.notNullOrEmpty(agentId, "agentId");
        ArgumentGuard.notNull(environment, "environment");
        ArgumentGuard.notNull(defaultMatchSettings, "defaultMatchSettings");
        this.agentId = agentId;
        this.sessionType = config.getSessionType();
        this.appIdOrName = config.getAppName();
        this.verId = verId;
        this.scenarioIdOrName = config.getTestName();
        this.batchInfo = config.getBatch();
        this.baselineEnvName = config.getBaselineEnvName();
        this.environmentName = config.getEnvironmentName();
        this.environment = environment;
        this.defaultMatchSettings = defaultMatchSettings;
        this.branchName = config.getBranchName();
        this.parentBranchName = config.getParentBranchName();
        this.baselineBranchName = config.getBaselineBranchName();
        this.saveDiffs = config.getSaveDiffs();
        this.properties = properties;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public SessionType getSessionType() {
        return this.sessionType;
    }

    public String getAppIdOrName() {
        return this.appIdOrName;
    }

    public String getVerId() {
        return this.verId;
    }

    public String getScenarioIdOrName() {
        return this.scenarioIdOrName;
    }

    public BatchInfo getBatchInfo() {
        return this.batchInfo;
    }

    public String getBaselineEnvName() {
        return this.baselineEnvName;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public AppEnvironment getEnvironment() {
        return this.environment;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public String getParentBranchName() {
        return this.parentBranchName;
    }

    public String getBaselineBranchName() {
        return this.baselineBranchName;
    }

    public Boolean getSaveDiffs() {
        return this.saveDiffs;
    }

    public ImageMatchSettings getDefaultMatchSettings() {
        return this.defaultMatchSettings;
    }

    public List<PropertyData> getProperties() {
        return this.properties;
    }
}

