/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.exceptions.NotSupportedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UserAgent {
    private static final String MAJOR_MINOR = "(?<major>\\d+)(?:[_.](?<minor>\\d+))?";
    private static final String PRODUCT = "(?:(?<product>%s)/(?<major>\\d+)(?:[_.](?<minor>\\d+))?)";
    private static final Pattern VERSION_REGEX = Pattern.compile(String.format("(?:(?<product>%s)/(?<major>\\d+)(?:[_.](?<minor>\\d+))?)", "Version"));
    private static final Pattern[] BROWSER_REGEXES = new Pattern[]{Pattern.compile(String.format("(?:(?<product>%s)/(?<major>\\d+)(?:[_.](?<minor>\\d+))?)", "Opera")), Pattern.compile(String.format("(?:(?<product>%s)/(?<major>\\d+)(?:[_.](?<minor>\\d+))?)", "Chrome")), Pattern.compile(String.format("(?:(?<product>%s)/(?<major>\\d+)(?:[_.](?<minor>\\d+))?)", "Safari")), Pattern.compile(String.format("(?:(?<product>%s)/(?<major>\\d+)(?:[_.](?<minor>\\d+))?)", "Firefox")), Pattern.compile(String.format("(?:(?<product>%s)/(?<major>\\d+)(?:[_.](?<minor>\\d+))?)", "Edge")), Pattern.compile("(?:MS(?<product>IE) (?<major>\\d+)(?:[_.](?<minor>\\d+))?)")};
    private static final Pattern[] OS_REGEXES = new Pattern[]{Pattern.compile("(?:(?<os>Windows NT) (?<major>\\d+)(?:[_.](?<minor>\\d+))?)"), Pattern.compile("(?:(?<os>Windows XP))"), Pattern.compile("(?:(?<os>Windows 2000))"), Pattern.compile("(?:(?<os>Windows NT))"), Pattern.compile("(?:(?<os>Windows))"), Pattern.compile("(?:(?<os>Mac OS X) (?<major>\\d+)(?:[_.](?<minor>\\d+))?)"), Pattern.compile("(?:(?<os>Android) (?<major>\\d+)(?:[_.](?<minor>\\d+))?)"), Pattern.compile("(?:(?<os>CPU(?: i[a-zA-Z]+)? OS) (?<major>\\d+)(?:[_.](?<minor>\\d+))?)"), Pattern.compile("(?:(?<os>Mac OS X))"), Pattern.compile("(?:(?<os>Mac_PowerPC))"), Pattern.compile("(?:(?<os>Linux))"), Pattern.compile("(?:(?<os>CrOS))"), Pattern.compile("(?:(?<os>SymbOS))")};
    private static final Pattern HIDDEN_IE_REGEX = Pattern.compile("(?:(?:rv:(?<major>\\d+)(?:[_.](?<minor>\\d+))?\\) like Gecko))");
    private static final Pattern EDGE_REGEX = Pattern.compile(String.format("(?:(?<product>%s)/(?<major>\\d+)(?:[_.](?<minor>\\d+))?)", "Edge"));
    private String originalUserAgentString;
    private String os;
    private String osMajorVersion;
    private String osMinorVersion;
    private String browser;
    private String browserMajorVersion;
    private String browserMinorVersion;

    public static UserAgent parseUserAgentString(String userAgent) {
        return UserAgent.parseUserAgentString(userAgent, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UserAgent parseUserAgentString(String userAgent, boolean unknowns) {
        Matcher versionMatch;
        if (userAgent == null) {
            return null;
        }
        userAgent = userAgent.trim();
        UserAgent result = new UserAgent();
        result.originalUserAgentString = userAgent;
        HashMap<String, Matcher> oss = new HashMap<String, Matcher>();
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        for (Pattern osRegex : OS_REGEXES) {
            Matcher matcher = osRegex.matcher(userAgent);
            if (!matcher.find()) continue;
            matchers.add(matcher);
            break;
        }
        for (Matcher m : matchers) {
            String os = m.group("os");
            if (os == null) continue;
            oss.put(os.toLowerCase(), m);
        }
        if (matchers.size() == 0) {
            if (!unknowns) throw new NotSupportedException("Unknown os: " + userAgent);
            result.os = "Unknown";
        } else {
            Matcher osMatch = oss.size() > 1 && oss.containsKey("android") ? (Matcher)oss.get("android") : oss.values().toArray(new Matcher[0])[0];
            result.os = osMatch.group("os");
            if (osMatch.groupCount() > 1) {
                result.osMajorVersion = osMatch.group("major");
            }
            if (result.osMajorVersion == null) {
                result.osMajorVersion = "";
            }
            if (osMatch.groupCount() > 2) {
                result.osMinorVersion = osMatch.group("minor");
                if (result.osMinorVersion == null || result.osMinorVersion.length() == 0) {
                    result.osMinorVersion = "0";
                }
            }
            if (result.osMinorVersion == null) {
                result.osMinorVersion = "";
            }
        }
        if (result.os.toUpperCase().startsWith("CPU")) {
            result.os = "IOS";
        } else if (result.os.equals("Windows XP")) {
            result.os = "Windows";
            result.osMajorVersion = "5";
            result.osMinorVersion = "1";
        } else if (result.os.equals("Windows 2000")) {
            result.os = "Windows";
            result.osMajorVersion = "5";
            result.osMinorVersion = "0";
        } else if (result.os.equals("Windows NT")) {
            result.os = "Windows";
            if (result.osMajorVersion.equals("6") && result.osMinorVersion.equals("1")) {
                result.osMajorVersion = "7";
                result.osMinorVersion = "0";
            } else if (result.osMajorVersion.trim().length() == 0) {
                result.osMajorVersion = "4";
                result.osMinorVersion = "0";
            }
        } else if (result.os.equals("Mac_PowerPC")) {
            result.os = "Macintosh";
        } else if (result.os.equals("CrOS")) {
            result.os = "ChromeOS";
        }
        boolean browserOK = false;
        for (Pattern browserRegex : BROWSER_REGEXES) {
            Matcher matcher = browserRegex.matcher(userAgent);
            if (!matcher.find()) continue;
            result.browser = matcher.group("product");
            result.browserMajorVersion = matcher.group("major");
            result.browserMinorVersion = matcher.group("minor");
            browserOK = true;
            break;
        }
        if (result.os.equals("Windows")) {
            Matcher iematch;
            Matcher edgeMatch = EDGE_REGEX.matcher(userAgent);
            if (edgeMatch.find()) {
                result.browser = "Edge";
                result.browserMajorVersion = edgeMatch.group("major");
                result.browserMinorVersion = edgeMatch.group("minor");
            }
            if ((iematch = HIDDEN_IE_REGEX.matcher(userAgent)).find()) {
                result.browser = "IE";
                result.browserMajorVersion = iematch.group("major");
                result.browserMinorVersion = iematch.group("minor");
                browserOK = true;
            }
        }
        if (!browserOK) {
            if (!unknowns) throw new NotSupportedException("Unknown browser: " + userAgent);
            result.browser = "Unknown";
        }
        if (!(versionMatch = VERSION_REGEX.matcher(userAgent)).find()) return result;
        result.browserMajorVersion = versionMatch.group("major");
        result.browserMinorVersion = versionMatch.group("minor");
        return result;
    }

    public String getOriginalUserAgentString() {
        return this.originalUserAgentString;
    }

    public String getOS() {
        return this.os;
    }

    public String getOSMajorVersion() {
        return this.osMajorVersion;
    }

    public String getOSMinorVersion() {
        return this.osMinorVersion;
    }

    public String getBrowser() {
        return this.browser;
    }

    public String getBrowserMajorVersion() {
        return this.browserMajorVersion;
    }

    public String getBrowserMinorVersion() {
        return this.browserMinorVersion;
    }

    public String toString() {
        return String.format("%s %s.%s / %s %s.%s", this.os, this.osMajorVersion, this.osMinorVersion, this.browser, this.browserMajorVersion, this.browserMinorVersion);
    }
}

