/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium;

import com.applitools.eyes.ImageMatchSettings;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.selenium.BrowserType;
import com.applitools.eyes.selenium.IConfigurationGetter;
import com.applitools.eyes.selenium.IConfigurationSetter;
import com.applitools.eyes.selenium.StitchMode;
import com.applitools.eyes.visualgrid.model.ChromeEmulationInfo;
import com.applitools.eyes.visualgrid.model.DeviceName;
import com.applitools.eyes.visualgrid.model.RenderBrowserInfo;
import com.applitools.eyes.visualgrid.model.ScreenOrientation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Configuration
extends com.applitools.eyes.config.Configuration
implements IConfigurationGetter,
IConfigurationSetter {
    private static final int DEFAULT_WAIT_BEFORE_SCREENSHOTS = 100;
    private Boolean forceFullPageScreenshot;
    private int waitBeforeScreenshots = 100;
    private StitchMode stitchMode = StitchMode.SCROLL;
    private boolean hideScrollbars = true;
    private boolean hideCaret = true;
    private Boolean isRenderingConfig = false;
    private List<RenderBrowserInfo> browsersInfo = new ArrayList<RenderBrowserInfo>();

    public Configuration(IConfigurationGetter other) {
        super(other);
        this.forceFullPageScreenshot = other.getForceFullPageScreenshot();
        this.waitBeforeScreenshots = other.getWaitBeforeScreenshots();
        this.stitchMode = other.getStitchMode();
        this.hideScrollbars = other.getHideScrollbars();
        this.hideCaret = other.getHideCaret();
        this.isRenderingConfig = other.isRenderingConfig();
        this.browsersInfo.addAll(other.getBrowsersInfo());
        this.defaultMatchSettings = new ImageMatchSettings(other.getDefaultMatchSettings());
    }

    public Configuration() {
    }

    public Configuration(RectangleSize viewportSize) {
        ArrayList<RenderBrowserInfo> browsersInfo = new ArrayList<RenderBrowserInfo>();
        browsersInfo.add(new RenderBrowserInfo(viewportSize.getWidth(), viewportSize.getHeight(), BrowserType.CHROME, null));
        this.browsersInfo = browsersInfo;
    }

    public Configuration(String testName) {
        this.testName = testName;
    }

    public Configuration(String appName, String testName, RectangleSize viewportSize) {
        ArrayList<RenderBrowserInfo> browsersInfo = new ArrayList<RenderBrowserInfo>();
        if (viewportSize != null) {
            browsersInfo.add(new RenderBrowserInfo(viewportSize.getWidth(), viewportSize.getHeight(), BrowserType.CHROME, null));
        }
        this.browsersInfo = browsersInfo;
        this.testName = testName;
        this.viewportSize = viewportSize;
        this.setAppName(appName);
    }

    @Override
    public Boolean getForceFullPageScreenshot() {
        return this.forceFullPageScreenshot;
    }

    @Override
    public int getWaitBeforeScreenshots() {
        return this.waitBeforeScreenshots;
    }

    @Override
    public IConfigurationSetter setWaitBeforeScreenshots(int waitBeforeScreenshots) {
        this.waitBeforeScreenshots = waitBeforeScreenshots <= 0 ? 100 : waitBeforeScreenshots;
        return this;
    }

    @Override
    public StitchMode getStitchMode() {
        return this.stitchMode;
    }

    @Override
    public IConfigurationSetter setStitchMode(StitchMode stitchMode) {
        this.stitchMode = stitchMode;
        return this;
    }

    @Override
    public boolean getHideScrollbars() {
        return this.hideScrollbars;
    }

    @Override
    public IConfigurationSetter setHideScrollbars(boolean hideScrollbars) {
        this.hideScrollbars = hideScrollbars;
        return this;
    }

    @Override
    public boolean getHideCaret() {
        return this.hideCaret;
    }

    @Override
    public IConfigurationSetter setHideCaret(boolean hideCaret) {
        this.hideCaret = hideCaret;
        return this;
    }

    @Override
    public IConfigurationSetter addBrowsers(RenderBrowserInfo ... browsersInfo) {
        this.browsersInfo.addAll(Arrays.asList(browsersInfo));
        return this;
    }

    @Override
    public IConfigurationSetter addBrowser(RenderBrowserInfo browserInfo) {
        this.addBrowserInfo(browserInfo);
        return this;
    }

    @Override
    public IConfigurationSetter addBrowser(int width, int height, BrowserType browserType, String baselineEnvName) {
        RenderBrowserInfo browserInfo = new RenderBrowserInfo(width, height, browserType, baselineEnvName);
        this.addBrowser(browserInfo);
        return this;
    }

    @Override
    public IConfigurationSetter addBrowser(int width, int height, BrowserType browserType) {
        return this.addBrowser(width, height, browserType, this.baselineEnvName);
    }

    private void addBrowserInfo(RenderBrowserInfo browserInfo) {
        this.browsersInfo.add(browserInfo);
    }

    @Override
    public IConfigurationSetter addDeviceEmulation(DeviceName deviceName, ScreenOrientation orientation) {
        ChromeEmulationInfo emulationInfo = new ChromeEmulationInfo(deviceName, orientation);
        RenderBrowserInfo browserInfo = new RenderBrowserInfo(emulationInfo, this.baselineEnvName);
        this.addBrowserInfo(browserInfo);
        return this;
    }

    @Override
    public IConfigurationSetter addDeviceEmulation(DeviceName deviceName) {
        ChromeEmulationInfo emulationInfo = new ChromeEmulationInfo(deviceName, ScreenOrientation.PORTRAIT);
        RenderBrowserInfo browserInfo = new RenderBrowserInfo(emulationInfo, this.baselineEnvName);
        this.addBrowserInfo(browserInfo);
        return this;
    }

    @Override
    public IConfigurationSetter addDeviceEmulation(DeviceName deviceName, String baselineEnvName) {
        ChromeEmulationInfo emulationInfo = new ChromeEmulationInfo(deviceName, ScreenOrientation.PORTRAIT);
        RenderBrowserInfo browserInfo = new RenderBrowserInfo(emulationInfo, baselineEnvName);
        this.addBrowserInfo(browserInfo);
        return this;
    }

    @Override
    public IConfigurationSetter addDeviceEmulation(DeviceName deviceName, ScreenOrientation orientation, String baselineEnvName) {
        ChromeEmulationInfo emulationInfo = new ChromeEmulationInfo(deviceName, orientation);
        RenderBrowserInfo browserInfo = new RenderBrowserInfo(emulationInfo, baselineEnvName);
        this.addBrowserInfo(browserInfo);
        return this;
    }

    @Override
    public List<RenderBrowserInfo> getBrowsersInfo() {
        if (this.browsersInfo != null && !this.browsersInfo.isEmpty()) {
            return this.browsersInfo;
        }
        if (this.viewportSize != null) {
            RenderBrowserInfo renderBrowserInfo = new RenderBrowserInfo(this.viewportSize.getWidth(), this.viewportSize.getHeight(), BrowserType.CHROME, this.baselineEnvName);
            return Collections.singletonList(renderBrowserInfo);
        }
        return this.browsersInfo;
    }

    @Override
    public IConfigurationSetter setBrowsersInfo(List<RenderBrowserInfo> browsersInfo) {
        this.browsersInfo = browsersInfo;
        return this;
    }

    @Override
    public String getTestName() {
        return this.testName;
    }

    @Override
    public IConfigurationSetter setTestName(String testName) {
        this.testName = testName;
        return this;
    }

    @Override
    public Configuration cloneConfig() {
        return new Configuration(this);
    }

    @Override
    public RectangleSize getViewportSize() {
        if (this.isRenderingConfig.booleanValue()) {
            RenderBrowserInfo renderBrowserInfo = this.browsersInfo.get(0);
            return new RectangleSize(renderBrowserInfo.getWidth(), renderBrowserInfo.getHeight());
        }
        return this.viewportSize;
    }

    @Override
    public Boolean isForceFullPageScreenshot() {
        return this.forceFullPageScreenshot;
    }

    @Override
    public IConfigurationSetter setForceFullPageScreenshot(boolean forceFullPageScreenshot) {
        this.forceFullPageScreenshot = forceFullPageScreenshot;
        return this;
    }

    @Override
    public boolean isRenderingConfig() {
        return this.isRenderingConfig;
    }

    @Override
    public IConfigurationSetter setRenderingConfig(boolean renderingConfig) {
        this.isRenderingConfig = renderingConfig;
        return this;
    }

    @Override
    public String toString() {
        return super.toString() + "\n\tforceFullPageScreenshot = " + this.forceFullPageScreenshot + "\n\twaitBeforeScreenshots = " + this.waitBeforeScreenshots + "\n\tstitchMode = " + (Object)((Object)this.stitchMode) + "\n\thideScrollbars = " + this.hideScrollbars + "\n\thideCaret = " + this.hideCaret;
    }

    @Override
    public IConfigurationSetter setIgnoreDisplacements(boolean ignoreDisplacements) {
        super.setIgnoreDisplacements(ignoreDisplacements);
        return this;
    }
}

