/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.visualgrid;

import com.applitools.eyes.IServerConnector;
import com.applitools.eyes.Logger;
import com.applitools.eyes.visualgrid.model.RGridResource;
import com.applitools.eyes.visualgrid.services.IResourceFuture;
import com.applitools.utils.GeneralUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class ResourceFuture
implements IResourceFuture {
    private Future responseFuture;
    private String url;
    private Logger logger;
    private IServerConnector serverConnector;
    private RGridResource rgResource;
    private String userAgent;

    public ResourceFuture(String url, Logger logger, IServerConnector serverConnector, String userAgent) {
        this.url = url;
        this.logger = logger;
        this.serverConnector = serverConnector;
        this.userAgent = userAgent;
    }

    public ResourceFuture(RGridResource rgResource, Logger logger, IServerConnector serverConnector, String userAgent) {
        this.url = rgResource.getUrl();
        this.rgResource = rgResource;
        this.logger = logger;
        this.serverConnector = serverConnector;
        this.userAgent = userAgent;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.responseFuture.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.responseFuture.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.responseFuture.isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RGridResource get() throws InterruptedException {
        this.logger.verbose("entering - " + this.url);
        if (this.rgResource != null) {
            return this.rgResource;
        }
        String string = this.url;
        synchronized (string) {
            if (this.responseFuture == null) {
                try {
                    IResourceFuture newFuture = this.serverConnector.downloadResource(new URL(this.url), this.userAgent, this);
                    this.responseFuture = ((ResourceFuture)newFuture).responseFuture;
                }
                catch (MalformedURLException malformedUrlException) {
                    GeneralUtils.logExceptionStackTrace(this.logger, malformedUrlException);
                }
            }
            int retryCount = 3;
            while (this.rgResource == null && retryCount > 0) {
                try {
                    this.responseFuture.get();
                }
                catch (Throwable e) {
                    GeneralUtils.logExceptionStackTrace(this.logger, e);
                    this.logger.verbose("Entering retry for - " + this.url);
                    try {
                        Thread.sleep(300L);
                        IResourceFuture newFuture = this.serverConnector.downloadResource(new URL(this.url), this.userAgent, this);
                        this.responseFuture = ((ResourceFuture)newFuture).responseFuture;
                    }
                    catch (MalformedURLException malformedUrlException) {
                        GeneralUtils.logExceptionStackTrace(this.logger, malformedUrlException);
                    }
                }
                finally {
                    --retryCount;
                }
            }
        }
        this.logger.verbose("enter -1 this.rgResource: " + this.rgResource);
        this.logger.verbose("exit");
        return this.rgResource;
    }

    @Override
    public RGridResource get(long timeout, TimeUnit unit) {
        try {
            return this.get();
        }
        catch (InterruptedException e) {
            GeneralUtils.logExceptionStackTrace(this.logger, e);
            return null;
        }
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setResource(RGridResource rgResource) {
        this.rgResource = rgResource;
    }

    @Override
    public void setResponseFuture(Future responseFuture) {
        this.responseFuture = responseFuture;
    }
}

