/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.visualgrid.model;

import com.applitools.eyes.Logger;
import com.applitools.eyes.visualgrid.model.RGridResource;
import com.applitools.utils.GeneralUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RGridDom {
    public static final String CONTENT_TYPE = "x-applitools-html/cdt";
    @JsonIgnore
    private List domNodes = null;
    @JsonIgnore
    private Map<String, RGridResource> resources = new HashMap<String, RGridResource>();
    @JsonIgnore
    private String sha256;
    @JsonInclude
    private String hashFormat = "sha256";
    @JsonIgnore
    private String url;
    @JsonIgnore
    private Logger logger;
    @JsonIgnore
    private String msg;
    @JsonIgnore
    private RGridResource gridResource;

    public RGridDom() {
    }

    public RGridDom(List domNodes, Map<String, RGridResource> resources, String url, Logger logger, String msg) {
        this.domNodes = domNodes;
        this.resources = resources;
        this.url = url;
        this.logger = logger;
        this.msg = msg;
    }

    public void addResource(RGridResource resource) {
        this.resources.put(resource.getUrl(), resource);
    }

    public List getDomNodes() {
        return this.domNodes;
    }

    public void setDomNodes(List domNodes) {
        this.domNodes = domNodes;
    }

    public Map<String, RGridResource> getResources() {
        return this.resources;
    }

    public void setResources(Map<String, RGridResource> resources) {
        this.resources = resources;
    }

    @JsonProperty(value="hash")
    public String getSha256() throws JsonProcessingException {
        if (this.sha256 == null) {
            this.sha256 = GeneralUtils.getSha256hash(this.getStringObjectMap().getBytes(StandardCharsets.UTF_8));
        }
        return this.sha256;
    }

    private String getStringObjectMap() throws JsonProcessingException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("domNodes", this.domNodes);
        map.put("resources", this.resources);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        return objectMapper.writeValueAsString(map);
    }

    public String getHashFormat() {
        return this.hashFormat;
    }

    public RGridResource asResource() throws JsonProcessingException {
        if (this.gridResource == null) {
            this.gridResource = new RGridResource(this.url, CONTENT_TYPE, this.getStringObjectMap().getBytes(StandardCharsets.UTF_8), this.logger, "RGridDom - " + this.msg);
        }
        return this.gridResource;
    }

    public void addResources(ArrayList<RGridResource> frameResourceUrlsMapping) {
        for (RGridResource gridResource : frameResourceUrlsMapping) {
            this.resources.put(gridResource.getUrl(), gridResource);
        }
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }
}

