/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.visualgrid.model;

import com.applitools.eyes.Logger;
import com.applitools.utils.GeneralUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public class RGridResource {
    @JsonIgnore
    private static final int MAX_RESOURCE_SIZE = 0xF00000;
    @JsonIgnore
    private String url;
    @JsonInclude
    private final String contentType;
    @JsonIgnore
    private final byte[] content;
    @JsonProperty(value="hash")
    private final String sha256;
    @JsonInclude
    private final String hashFormat = "sha256";
    @JsonIgnore
    private Logger logger;
    @JsonIgnore
    private AtomicBoolean isResourceParsed = new AtomicBoolean(false);

    public String getUrl() {
        return this.url;
    }

    public RGridResource(String url, String contentType, byte[] content, Logger logger, String msg) {
        this.contentType = contentType;
        this.content = content.length > 0xF00000 ? Arrays.copyOf(content, 0xF00000) : content;
        this.logger = logger;
        this.sha256 = GeneralUtils.getSha256hash(this.content);
        this.url = url;
    }

    public String getContentType() {
        return this.contentType;
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getHashFormat() {
        return "sha256";
    }

    public String getSha256() {
        return this.sha256;
    }

    public String toString() {
        return "RGridResource{url='" + this.url + '\'' + '}';
    }

    public void setIsResourceParsed(Boolean isResourceParsed) {
        this.isResourceParsed.set(isResourceParsed);
    }

    @JsonIgnore
    public boolean isResourceParsed() {
        return this.isResourceParsed.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RGridResource)) {
            return false;
        }
        RGridResource that = (RGridResource)o;
        return Arrays.equals(this.getContent(), that.getContent()) && this.getSha256().equals(that.getSha256()) && this.getHashFormat().equals(that.getHashFormat());
    }

    public int hashCode() {
        int result = Objects.hash(this.getSha256(), this.getHashFormat());
        result = 31 * result + Arrays.hashCode(this.getContent());
        return result;
    }
}

