/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.visualgrid.services;

import com.applitools.eyes.Logger;
import com.applitools.eyes.TestResultContainer;
import com.applitools.eyes.visualgrid.services.EyesService;
import com.applitools.utils.GeneralUtils;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;

public class OpenerService
extends EyesService {
    private AtomicInteger concurrentSession = new AtomicInteger();
    private final Object concurrencyLock;

    public OpenerService(String serviceName, ThreadGroup servicesGroup, Logger logger, int threadPoolSize, Object openerServiceLock, EyesService.EyesServiceListener listener, Object debugLock, EyesService.Tasker tasker) {
        super(serviceName, servicesGroup, logger, threadPoolSize, debugLock, listener, tasker);
        this.concurrencyLock = openerServiceLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void runNextTask() {
        if (!this.isServiceOn) {
            return;
        }
        if (this.threadPoolSize > this.concurrentSession.get()) {
            FutureTask<TestResultContainer> task = this.listener.getNextTask(this.tasker);
            if (task != null) {
                this.concurrentSession.incrementAndGet();
                this.pauseIfNeeded();
                this.logger.verbose("open concurrent sessions: " + this.concurrentSession);
                this.executor.submit(task);
            }
        } else {
            Object object = this.concurrencyLock;
            synchronized (object) {
                try {
                    this.logger.verbose("Waiting for concurrency to be free");
                    this.concurrencyLock.wait();
                    this.logger.verbose("concurrency free");
                }
                catch (InterruptedException e) {
                    GeneralUtils.logExceptionStackTrace(this.logger, e);
                }
            }
        }
    }

    @Override
    void stopService() {
        this.logger.verbose("concurrency on stop = " + this.concurrentSession);
        super.stopService();
    }

    public synchronized int decrementConcurrency() {
        return this.concurrentSession.decrementAndGet();
    }
}

