/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.visualgrid.services;

import com.applitools.ICheckSettings;
import com.applitools.ICheckSettingsInternal;
import com.applitools.eyes.IRegion;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.RunningSession;
import com.applitools.eyes.TestResultContainer;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.exceptions.DiffsFoundException;
import com.applitools.eyes.selenium.IConfigurationGetter;
import com.applitools.eyes.visualgrid.model.CompletableTask;
import com.applitools.eyes.visualgrid.model.RenderBrowserInfo;
import com.applitools.eyes.visualgrid.model.RenderStatusResults;
import com.applitools.eyes.visualgrid.model.RenderingTask;
import com.applitools.eyes.visualgrid.model.VGRegion;
import com.applitools.eyes.visualgrid.model.VisualGridSelector;
import com.applitools.eyes.visualgrid.services.IEyesConnector;
import com.applitools.eyes.visualgrid.services.RunningTest;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;

public class VisualGridTask
implements Callable<TestResultContainer>,
CompletableTask {
    private final Logger logger;
    private boolean isSent;
    private String source;
    private IConfigurationGetter configurationGetter;
    private TestResults testResults;
    private IEyesConnector eyesConnector;
    private TaskType type;
    private RenderStatusResults renderResult;
    private List<TaskListener> listeners = new ArrayList<TaskListener>();
    private ICheckSettingsInternal checkSettings;
    private RunningTest runningTest;
    private Throwable exception;
    private RenderingTask renderingTask = null;
    private AtomicBoolean isTaskComplete = new AtomicBoolean(false);
    private final List<VisualGridSelector[]> regionSelectors;

    public VisualGridTask(IConfigurationGetter seleniumConfigurationProvider, TestResults testResults, IEyesConnector eyesConnector, TaskType type, TaskListener runningTestListener, ICheckSettings checkSettings, RunningTest runningTest, List<VisualGridSelector[]> regionSelectors, String source) {
        this.configurationGetter = seleniumConfigurationProvider;
        this.testResults = testResults;
        this.eyesConnector = eyesConnector;
        this.type = type;
        this.regionSelectors = regionSelectors;
        this.listeners.add(runningTestListener);
        this.logger = runningTest.getLogger();
        this.source = source;
        if (checkSettings != null) {
            this.checkSettings = (ICheckSettingsInternal)((Object)checkSettings);
            this.checkSettings = this.checkSettings.clone();
        }
        this.runningTest = runningTest;
    }

    public RenderBrowserInfo getBrowserInfo() {
        return this.runningTest.getBrowserInfo();
    }

    public TaskType getType() {
        return this.type;
    }

    boolean isSent() {
        return this.isSent;
    }

    void setIsSent() {
        this.isSent = true;
    }

    @Override
    public TestResultContainer call() {
        try {
            this.testResults = null;
            switch (this.type) {
                case OPEN: {
                    this.logger.verbose("VisualGridTask.run opening task");
                    if (this.renderResult != null) {
                        String userAgent = this.renderResult.getUserAgent();
                        RectangleSize deviceSize = this.renderResult.getDeviceSize();
                        this.eyesConnector.setUserAgent(userAgent);
                        this.eyesConnector.setDeviceSize(deviceSize);
                    } else {
                        RenderBrowserInfo browserInfo = this.runningTest.getBrowserInfo();
                        this.eyesConnector.setDeviceSize(browserInfo.getViewportSize());
                    }
                    this.eyesConnector.open(this.configurationGetter, this.runningTest.getAppName(), this.runningTest.getTestName());
                    this.logger.verbose("Eyes Open Done.");
                    break;
                }
                case CHECK: {
                    VisualGridSelector[] targetSelector;
                    this.logger.verbose("VisualGridTask.run check task");
                    String imageLocation = this.renderResult.getImageLocation();
                    String domLocation = this.renderResult.getDomLocation();
                    List<VGRegion> vgRegions = this.renderResult.getSelectorRegions();
                    ArrayList<VGRegion> regions = new ArrayList<VGRegion>();
                    if (vgRegions != null) {
                        for (VGRegion reg : vgRegions) {
                            if (reg.getError() != null) {
                                this.logger.log(String.format("Warning: region error: %s", reg.getError()));
                                continue;
                            }
                            regions.add(reg);
                        }
                    }
                    if (imageLocation == null) {
                        this.logger.verbose("CHECKING IMAGE WITH NULL LOCATION - ");
                        this.logger.verbose(this.renderResult.toString());
                    }
                    Location location = null;
                    if (this.regionSelectors.size() > 0 && (targetSelector = this.regionSelectors.get(this.regionSelectors.size() - 1)).length > 0 && "target".equals(targetSelector[0].getCategory())) {
                        location = ((IRegion)regions.get(regions.size() - 1)).getLocation();
                    }
                    this.eyesConnector.matchWindow(imageLocation, domLocation, (ICheckSettings)((Object)this.checkSettings), regions, this.regionSelectors, location, this.renderResult.getRenderId(), this.source);
                    this.logger.verbose("match done");
                    break;
                }
                case CLOSE: {
                    this.logger.verbose("VisualGridTask.run close task");
                    try {
                        this.testResults = this.eyesConnector.close(true);
                    }
                    catch (Throwable e) {
                        GeneralUtils.logExceptionStackTrace(this.logger, e);
                        if (e instanceof DiffsFoundException) {
                            DiffsFoundException diffException = (DiffsFoundException)((Object)e);
                            this.testResults = diffException.getTestResults();
                        }
                        this.exception = e;
                    }
                    this.logger.verbose("Eyes Close Done.");
                    break;
                }
                case ABORT: {
                    this.logger.verbose("VisualGridTask.run abort task");
                    this.testResults = this.eyesConnector.abortIfNotClosed();
                    this.logger.verbose("Closing a not opened test");
                }
            }
            TestResultContainer testResultContainer = new TestResultContainer(this.testResults, this.runningTest.getBrowserInfo(), this.exception);
            this.notifySuccessAllListeners();
            this.isTaskComplete.set(true);
            return testResultContainer;
        }
        catch (Throwable e) {
            GeneralUtils.logExceptionStackTrace(this.logger, e);
            this.exception = new Error(e);
            this.notifyFailureAllListeners(new Error(e));
            return null;
        }
    }

    private String craftUserAgent(RenderBrowserInfo browserInfo) {
        String browserType = browserInfo.getBrowserType();
        String platform = VisualGridTask.toPascalCase(browserInfo.getPlatform());
        if (!browserType.startsWith("ie")) {
            browserType = VisualGridTask.toPascalCase(browserType);
            return "Mozilla/5.0 (" + platform + ") " + browserType + "/0.0";
        }
        if (browserType.equals("ie")) {
            return "Mozilla/5.0 (" + platform + "; MSIE 11.0)";
        }
        if (browserType.equals("ie10")) {
            return "Mozilla/5.0 (" + platform + "; MSIE 10.0)";
        }
        return "Mozilla/5.0 (" + platform + "; Unknown)";
    }

    public static String toPascalCase(String str) {
        ArgumentGuard.notNullOrEmpty(str, "str");
        return str.substring(0, 1).toUpperCase() + str.substring(1).toLowerCase();
    }

    private void notifySuccessAllListeners() {
        for (TaskListener listener : this.listeners) {
            listener.onTaskComplete(this);
        }
    }

    private void notifyFailureAllListeners(Error e) {
        for (TaskListener listener : this.listeners) {
            listener.onTaskFailed(e, this);
        }
    }

    private void notifyRenderCompleteAllListeners() {
        for (TaskListener listener : this.listeners) {
            listener.onRenderComplete(this.renderingTask, this.exception);
        }
    }

    public IEyesConnector getEyesConnector() {
        return this.eyesConnector;
    }

    public void setRenderResult(RenderStatusResults renderResult) {
        this.logger.verbose("enter");
        this.renderResult = renderResult;
        this.notifyRenderCompleteAllListeners();
        this.logger.verbose("exit");
    }

    public boolean isTaskReadyToCheck() {
        return this.renderResult != null || this.exception != null;
    }

    public RunningTest getRunningTest() {
        return this.runningTest;
    }

    @Override
    public boolean getIsTaskComplete() {
        return this.isTaskComplete.get();
    }

    public void addListener(TaskListener listener) {
        this.listeners.add(listener);
    }

    public void setRenderError(String renderId, String error) {
        this.logger.verbose("enter - renderId: " + renderId);
        for (TaskListener listener : this.listeners) {
            this.exception = new Error("Render Failed for " + this.getBrowserInfo() + " (renderId: " + renderId + ") with reason: " + error);
            listener.onTaskFailed(this.exception, this);
        }
        this.logger.verbose("exit - renderId: " + renderId);
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public void setExceptionAndAbort(Throwable exception) {
        this.logger.verbose("aborting task with exception");
        this.exception = exception;
        if (this.type == TaskType.CLOSE) {
            this.type = TaskType.ABORT;
        }
        this.abortRunningTest(exception);
    }

    public void abortRunningTest(Throwable exception) {
        this.runningTest.abort(true, exception);
    }

    public String toString() {
        return "VisualGridTask - Type: " + (Object)((Object)this.type) + " ; Browser Info: " + this.getBrowserInfo();
    }

    public void setRenderingTask(RenderingTask renderingTask) {
        this.renderingTask = renderingTask;
    }

    public RunningSession getSession() {
        return this.eyesConnector.getSession();
    }

    static interface TaskListener {
        public void onTaskComplete(VisualGridTask var1);

        public void onTaskFailed(Throwable var1, VisualGridTask var2);

        public void onRenderComplete(RenderingTask var1, Throwable var2);
    }

    public static enum TaskType {
        OPEN,
        CHECK,
        CLOSE,
        ABORT;

    }
}

