/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.utils;

import java.util.Map;

public class EfficientStringReplace {
    public static String efficientStringReplace(String refIdOpenToken, String refIdCloseToken, String input, Map<String, String> replacements) {
        int resultBufferSize = input.length();
        for (String rep : replacements.values()) {
            resultBufferSize += rep.length();
        }
        StringBuilder result = new StringBuilder(resultBufferSize);
        StringBuilder refId = new StringBuilder();
        int inLen = input.length();
        char[] refIdOpenChars = refIdOpenToken.toCharArray();
        int refOpenTokenLen = refIdOpenChars.length;
        char[] refIdCloseChars = refIdCloseToken.toCharArray();
        int refCloseTokenLen = refIdCloseChars.length;
        block1: for (int i = 0; i < inLen; ++i) {
            boolean refTokenEncountered;
            boolean bl = refTokenEncountered = input.charAt(i) == refIdOpenChars[0];
            if (refTokenEncountered) {
                for (int j = 1; j < refOpenTokenLen; ++j) {
                    if (input.charAt(i + j) == refIdOpenChars[j]) continue;
                    refTokenEncountered = false;
                    break;
                }
                if (refTokenEncountered) {
                    refId.setLength(0);
                    i += refOpenTokenLen;
                    while (i < inLen) {
                        boolean refEndTokenEncountered;
                        boolean bl2 = refEndTokenEncountered = input.charAt(i) == refIdCloseChars[0];
                        if (refEndTokenEncountered) {
                            String rep;
                            for (int j = 1; j < refCloseTokenLen; ++j) {
                                if (input.charAt(i + j) == refIdCloseChars[j]) continue;
                                refEndTokenEncountered = false;
                                break;
                            }
                            if (refEndTokenEncountered && (rep = replacements.get(refId.toString())) != null) {
                                result.append(rep);
                                i += refCloseTokenLen - 1;
                                continue block1;
                            }
                        }
                        if (!refEndTokenEncountered) {
                            refId.append(input.charAt(i));
                        }
                        ++i;
                    }
                }
            }
            if (refTokenEncountered) continue;
            result.append(input.charAt(i));
        }
        return result.toString();
    }

    public static String CleanForJSON(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        char c = '\u0000';
        int len = s.length();
        StringBuilder sb = new StringBuilder(len + 4);
        block8: for (int i = 0; i < len; ++i) {
            c = s.charAt(i);
            switch (c) {
                case '\"': 
                case '/': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block8;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block8;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                default: {
                    if (c < ' ') {
                        String t = String.format("%04x", Character.valueOf(c));
                        sb.append("\\u").append(t.substring(t.length() - 4));
                        continue block8;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

