/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.LogHandler;
import com.applitools.eyes.NullLogHandler;

public class Logger {
    private LogHandler logHandler = new NullLogHandler();
    private String sessionId = "";

    protected int getMethodsBack() {
        return 3;
    }

    public Logger() {
    }

    public Logger(LogHandler handler) {
        this();
        this.logHandler = handler;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public LogHandler getLogHandler() {
        return this.logHandler;
    }

    public void setLogHandler(LogHandler handler) {
        this.logHandler = handler == null ? NullLogHandler.instance : handler;
    }

    protected String getPrefix() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        String prefix = "{" + this.sessionId + "} ";
        prefix = prefix + "[" + Thread.currentThread().getId() + "] ";
        int methodsBack = this.getMethodsBack();
        if (stackTraceElements.length > methodsBack) {
            prefix = prefix + stackTraceElements[methodsBack].getClassName() + "." + stackTraceElements[methodsBack].getMethodName() + "(): ";
        }
        return prefix;
    }

    public void verbose(String message) {
        this.logHandler.onMessage(true, "[VERBOSE] " + this.getPrefix() + message);
    }

    public void log(String message) {
        this.logHandler.onMessage(false, "[LOG    ] " + this.getPrefix() + message);
    }
}

