/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.LogHandler;
import com.applitools.eyes.logging.ClientEvent;
import com.applitools.eyes.logging.TraceLevel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class MultiLogHandler
extends LogHandler {
    final Set<LogHandler> logHandlers = new HashSet<LogHandler>();

    public MultiLogHandler(LogHandler ... logHandlers) {
        super(TraceLevel.Debug);
        if (logHandlers == null || logHandlers.length == 0) {
            return;
        }
        this.logHandlers.addAll(Arrays.asList(logHandlers));
    }

    public void addLogHandler(LogHandler logHandler) {
        this.logHandlers.add(logHandler);
    }

    public void clear() {
        this.logHandlers.clear();
    }

    @Override
    public void open() {
        for (LogHandler logHandler : this.logHandlers) {
            logHandler.open();
        }
    }

    @Override
    public void onMessageInner(ClientEvent event) {
        for (LogHandler logHandler : this.logHandlers) {
            logHandler.onMessage(event);
        }
    }

    @Override
    public void close() {
        for (LogHandler logHandler : this.logHandlers) {
            logHandler.close();
        }
    }

    @Override
    public boolean isOpen() {
        return true;
    }
}

