/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.connectivity.api;

import com.applitools.connectivity.api.AsyncRequestCallback;
import com.applitools.connectivity.api.Response;
import com.applitools.eyes.Logger;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.eyes.logging.Type;
import com.applitools.utils.GeneralUtils;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.Future;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AsyncRequest {
    private static final int REQUEST_TIMEOUT = 60000;
    private static final int SLEEP_DURATION = 5000;
    private int timePassed = 0;
    protected Logger logger;
    protected final String requestId;

    public AsyncRequest(Logger logger) {
        this.logger = logger;
        this.requestId = UUID.randomUUID().toString();
    }

    public abstract AsyncRequest header(String var1, String var2);

    public abstract Future<?> method(String var1, AsyncRequestCallback var2, Object var3, String var4, boolean var5);

    public Future<?> method(final String method, final AsyncRequestCallback callback, final Object data, final String contentType) {
        this.header("x-applitools-eyes-client-request-id", this.requestId);
        this.logger.log(TraceLevel.Debug, new HashSet<String>(), Stage.GENERAL, Type.REQUEST_SENT, Pair.of((Object)"requestId", (Object)this.requestId));
        return this.method(method, new AsyncRequestCallback(){

            @Override
            public void onComplete(Response response) {
                AsyncRequest.this.logger.log(TraceLevel.Debug, new HashSet<String>(), Stage.GENERAL, Type.REQUEST_COMPLETED, Pair.of((Object)"requestId", (Object)AsyncRequest.this.requestId));
                response.setRequestId(AsyncRequest.this.requestId);
                try {
                    callback.onComplete(response);
                }
                catch (Throwable t) {
                    callback.onFail(t);
                }
            }

            @Override
            public void onFail(Throwable throwable) {
                if (AsyncRequest.this.timePassed >= 60000) {
                    AsyncRequest.this.logger.log(new HashSet<String>(), Stage.GENERAL, Type.REQUEST_FAILED, Pair.of((Object)"requestId", (Object)AsyncRequest.this.requestId));
                    callback.onFail(throwable);
                    return;
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                AsyncRequest.this.timePassed = AsyncRequest.this.timePassed + 5000;
                GeneralUtils.logExceptionStackTrace(AsyncRequest.this.logger, Stage.GENERAL, throwable, new String[0]);
                AsyncRequest.this.logger.log(new HashSet<String>(), Stage.GENERAL, Type.REQUEST_FAILED, Pair.of((Object)"requestId", (Object)AsyncRequest.this.requestId));
                AsyncRequest.this.method(method, callback, data, contentType);
            }
        }, data, contentType, true);
    }
}

