/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.connectivity.api;

import com.applitools.connectivity.api.AsyncRequestCallback;
import com.applitools.eyes.exceptions.EyesRequestTimeoutException;
import java.util.Timer;
import java.util.TimerTask;

public abstract class AsyncRequestCallbackWithTimeout
implements AsyncRequestCallback {
    private final Timer timeoutScheduler = new Timer("async callback timeout scheduler");
    protected final Object timeoutLock = new Object();
    private final String requestDescription;
    private static final int REQUEST_TIMEOUT_MS = 120000;
    private boolean isFulfilled = false;

    public AsyncRequestCallbackWithTimeout(final String requestDescription) {
        this.requestDescription = requestDescription != null ? requestDescription : "[no description]";
        this.timeoutScheduler.schedule(new TimerTask(){

            @Override
            public void run() {
                AsyncRequestCallbackWithTimeout.this.onFail(new EyesRequestTimeoutException("Timeout occurred for request:" + requestDescription));
            }
        }, 120000L);
    }

    public void markCallbackAsFulfilled() {
        this.timeoutScheduler.cancel();
        this.isFulfilled = true;
    }

    public boolean isFulfilled() {
        return this.isFulfilled;
    }
}

