/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.connectivity.api;

import com.applitools.eyes.Logger;

public abstract class Response {
    protected Logger logger;
    protected byte[] body;

    public Response(Logger logger) {
        this.logger = logger;
    }

    public abstract int getStatusCode();

    public abstract String getStatusPhrase();

    public abstract String getHeader(String var1, boolean var2);

    protected abstract void readEntity();

    public byte[] getBody() {
        return this.body;
    }

    public String getBodyString() {
        return new String(this.body);
    }

    public abstract void close();

    public void logIfError() {
        try {
            if (this.getStatusCode() >= 400) {
                this.logger.log(String.format("Got invalid response from the server. Status code: %s. Status Phrase: %s. Response body: %s", this.getStatusCode(), this.getStatusPhrase(), this.getBodyString()));
            }
        }
        catch (Exception e) {
            this.logger.log(String.format("Failed logging the response body. Status code: %s", this.getStatusCode()));
        }
    }
}

