/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.EyesException;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.applitools.utils.Iso8610CalendarSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.text.ParseException;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.UUID;

public class BatchInfo {
    private static final String BATCH_TIMEZONE = "UTC";
    private String id;
    private final String name;
    private final String startedAt;
    @JsonProperty(value="batchSequenceName")
    private String batchSequenceName;

    public BatchInfo(String name, Calendar startedAt) {
        ArgumentGuard.notNull(startedAt, "startedAt");
        String envVarBatchId = GeneralUtils.getEnvString("APPLITOOLS_BATCH_ID");
        this.id = envVarBatchId != null ? envVarBatchId : UUID.randomUUID().toString();
        this.name = name != null ? name : GeneralUtils.getEnvString("APPLITOOLS_BATCH_NAME");
        this.startedAt = GeneralUtils.toISO8601DateTime(startedAt);
        this.batchSequenceName = GeneralUtils.getEnvString("APPLITOOLS_BATCH_SEQUENCE");
    }

    public BatchInfo(String name) {
        this(name, Calendar.getInstance(TimeZone.getTimeZone(BATCH_TIMEZONE)));
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        ArgumentGuard.notNullOrEmpty(id, "id");
        this.id = id;
    }

    public BatchInfo withBatchId(String id) {
        ArgumentGuard.notNullOrEmpty(id, "id");
        this.id = id;
        return this;
    }

    @JsonSerialize(using=Iso8610CalendarSerializer.class)
    public Calendar getStartedAt() {
        try {
            return GeneralUtils.fromISO8601DateTime(this.startedAt);
        }
        catch (ParseException ex) {
            throw new EyesException("Failed to parse batch start time", ex);
        }
    }

    @JsonProperty(value="batchSequenceName")
    public String getSequenceName() {
        return this.batchSequenceName;
    }

    public void setSequenceName(String sequenceName) {
        this.batchSequenceName = sequenceName;
    }

    public String toString() {
        return "'" + this.name + "' - " + this.startedAt;
    }
}

