/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.utils.ArgumentGuard;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class RectangleSize {
    private int width;
    private int height;
    public static RectangleSize EMPTY = new RectangleSize(0, 0);

    @JsonCreator
    public RectangleSize(@JsonProperty(value="width") int width, @JsonProperty(value="height") int height) {
        ArgumentGuard.greaterThanOrEqualToZero(width, "width");
        ArgumentGuard.greaterThanOrEqualToZero(height, "height");
        this.width = width;
        this.height = height;
    }

    public boolean isEmpty() {
        return this.width == 0 && this.height == 0;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public static RectangleSize parse(String size) {
        ArgumentGuard.notNull(size, "size");
        String[] parts = size.split("x");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Not a valid size string: " + size);
        }
        return new RectangleSize(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
    }

    public RectangleSize scale(double scaleRatio) {
        return new RectangleSize((int)Math.ceil((double)this.width * scaleRatio), (int)Math.ceil((double)this.height * scaleRatio));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RectangleSize)) {
            return false;
        }
        RectangleSize other = (RectangleSize)obj;
        return this.width == other.width && this.height == other.height;
    }

    public int hashCode() {
        return this.width ^ this.height;
    }

    public String toString() {
        return this.width + "x" + this.height;
    }
}

