/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.connectivity.api;

import com.applitools.eyes.Logger;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.Type;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public abstract class Response {
    private String requestId;
    protected Logger logger;
    protected byte[] body;

    public Response(Logger logger) {
        this.logger = logger;
    }

    public abstract int getStatusCode();

    public abstract String getStatusPhrase();

    public abstract String getHeader(String var1, boolean var2);

    protected abstract Map<String, String> getHeaders();

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    protected abstract void readEntity();

    public byte[] getBody() {
        return this.body;
    }

    public String getBodyString() {
        return new String(this.body);
    }

    public abstract void close();

    public void logIfError() {
        try {
            if (this.getStatusCode() >= 300) {
                this.logger.log(new HashSet<String>(), Stage.GENERAL, Type.REQUEST_FAILED, Pair.of((Object)"statusCode", (Object)this.getStatusCode()), Pair.of((Object)"statusPhrase", (Object)this.getStatusPhrase()), Pair.of((Object)"headers", this.getHeaders()), Pair.of((Object)"body", (Object)this.getBodyString()), Pair.of((Object)"requestId", (Object)this.requestId));
            }
        }
        catch (Exception e) {
            this.logger.log(new HashSet<String>(), Stage.GENERAL, Type.REQUEST_FAILED, Pair.of((Object)"statusCode", (Object)this.getStatusCode()), Pair.of((Object)"statusPhrase", (Object)this.getStatusPhrase()), Pair.of((Object)"headers", this.getHeaders()), Pair.of((Object)"requestId", (Object)this.requestId));
        }
    }
}

