/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import java.util.Objects;

public abstract class AbstractProxySettings {
    public static final String PROXY_ENV_VAR_NAME = "APPLITOOLS_HTTP_PROXY";
    protected String uri;
    protected String username;
    protected String password;
    protected Integer port;

    public AbstractProxySettings(String uri, Integer port, String username, String password) {
        ArgumentGuard.notNull(uri, "uri");
        this.uri = uri;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    public AbstractProxySettings(String uri, Integer port) {
        this(uri, port, null, null);
    }

    public AbstractProxySettings(String uri, String username, String password) {
        this(uri, null, username, password);
    }

    public AbstractProxySettings(String uri) {
        this(uri, null, null, null);
    }

    public AbstractProxySettings() {
        this(GeneralUtils.getEnvString(PROXY_ENV_VAR_NAME));
    }

    public String getUri() {
        return this.uri;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractProxySettings that = (AbstractProxySettings)o;
        return Objects.equals(this.port, that.port) && Objects.equals(this.uri, that.uri) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.username, this.password, this.port);
    }

    public String toString() {
        String[] url = this.uri.split("://", 2);
        String protocol = url[0] + "://";
        String host = url[1];
        if (this.username != null && this.password != null) {
            return protocol + this.username + ':' + this.password + '@' + host;
        }
        return protocol + host;
    }
}

