/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.logging;

import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.Type;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Message {
    private String agentId;
    private Stage stage;
    private Type type;
    private Set<String> testId;
    private long threadId;
    private String stackTrace;
    private Map<String, Object> data;

    public Message() {
    }

    public Message(String agentId, Stage stage, Type type, Set<String> testId, long threadId, String stackTrace, Map<String, Object> data) {
        this.agentId = agentId;
        this.stage = stage;
        this.type = type;
        this.testId = testId == null ? new HashSet() : testId;
        this.threadId = threadId;
        this.stackTrace = stackTrace;
        this.data = data;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public Stage getStage() {
        return this.stage;
    }

    public Type getType() {
        return this.type;
    }

    public Set<String> getTestId() {
        return this.testId;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)o;
        return this.threadId == message.threadId && Objects.equals(this.agentId, message.agentId) && this.stage == message.stage && this.type == message.type && Objects.equals(this.testId, message.testId) && Objects.equals(this.stackTrace, message.stackTrace) && Objects.equals(this.data, message.data);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.agentId, this.stage, this.type, this.testId, this.threadId, this.stackTrace, this.data});
    }
}

