/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.LogHandler;
import com.applitools.eyes.logging.ClientEvent;
import com.applitools.eyes.logging.TraceLevel;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class MultiLogHandler
extends LogHandler {
    final Set<LogHandler> logHandlers = Collections.synchronizedSet(new HashSet());

    public MultiLogHandler(LogHandler ... logHandlers) {
        super(TraceLevel.Debug);
        if (logHandlers == null || logHandlers.length == 0) {
            return;
        }
        this.logHandlers.addAll(Arrays.asList(logHandlers));
    }

    public void addLogHandler(LogHandler logHandler) {
        this.logHandlers.add(logHandler);
    }

    public void clear() {
        this.logHandlers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        Set<LogHandler> set = this.logHandlers;
        synchronized (set) {
            for (LogHandler logHandler : this.logHandlers) {
                logHandler.open();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessageInner(ClientEvent event) {
        Set<LogHandler> set = this.logHandlers;
        synchronized (set) {
            for (LogHandler logHandler : this.logHandlers) {
                logHandler.onMessage(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Set<LogHandler> set = this.logHandlers;
        synchronized (set) {
            for (LogHandler logHandler : this.logHandlers) {
                logHandler.close();
            }
        }
    }

    @Override
    public boolean isOpen() {
        return true;
    }
}

