/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.AbstractProxySettings;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.RestClient;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.events.ISessionEventHandler;
import com.applitools.eyes.events.ValidationInfo;
import com.applitools.eyes.events.ValidationResult;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.net.URI;

public class RemoteSessionEventHandler
extends RestClient
implements ISessionEventHandler {
    private String autSessionId;
    private static final String SERVER_SUFFIX = "/applitools/sessions";
    private final String accessKey;
    private WebResource defaultEndPoint;
    private boolean throwExceptions = true;

    public RemoteSessionEventHandler(Logger logger, URI serverUrl, String accessKey, int timeout) {
        super(logger, serverUrl, timeout);
        this.accessKey = accessKey;
        this.defaultEndPoint = this.endPoint.queryParam("accessKey", accessKey).path(SERVER_SUFFIX);
    }

    public RemoteSessionEventHandler(Logger logger, URI serverUrl, String accessKey) {
        this(logger, serverUrl, accessKey, 30000);
    }

    public RemoteSessionEventHandler(URI serverUrl, String accessKey, int timeout) {
        this(new Logger(), serverUrl, accessKey, timeout);
    }

    public RemoteSessionEventHandler(URI serverUrl, String accessKey) {
        this(new Logger(), serverUrl, accessKey);
    }

    public void setProxy(AbstractProxySettings abstractProxySettings) {
        this.setProxyBase(abstractProxySettings);
        this.defaultEndPoint = this.endPoint.queryParam("accessKey", this.accessKey).path(SERVER_SUFFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(RestClient.HttpMethodCall method) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        String methodName = "";
        if (stackTraceElements.length >= 3) {
            methodName = stackTraceElements[2].getMethodName();
        }
        try (ClientResponse response = null;){
            response = method.call();
            if (response.getStatus() != 200) {
                this.logger.verbose("'" + methodName + "' notification handler returned an error: " + response.getStatusInfo());
            } else {
                this.logger.verbose("'" + methodName + "' succeeded: " + response);
            }
        }
    }

    public void initStarted() {
        this.sendMessage(new RestClient.HttpMethodCall(){

            @Override
            public ClientResponse call() {
                WebResource.Builder invocationBuilder = RemoteSessionEventHandler.this.defaultEndPoint.path(RemoteSessionEventHandler.this.autSessionId).accept(new String[]{"application/json"});
                return (ClientResponse)invocationBuilder.put(ClientResponse.class, (Object)"{\"action\": \"initStart\"}");
            }
        });
    }

    public void initEnded() {
        this.sendMessage(new RestClient.HttpMethodCall(){

            @Override
            public ClientResponse call() {
                WebResource.Builder invocationBuilder = RemoteSessionEventHandler.this.defaultEndPoint.path(RemoteSessionEventHandler.this.autSessionId).accept(new String[]{"application/json"});
                return (ClientResponse)invocationBuilder.put(ClientResponse.class, (Object)"{\"action\": \"initEnd\"}");
            }
        });
    }

    public void setSizeWillStart(RectangleSize sizeToSet) {
        final RectangleSize size = sizeToSet;
        this.sendMessage(new RestClient.HttpMethodCall(){

            @Override
            public ClientResponse call() {
                WebResource.Builder invocationBuilder = RemoteSessionEventHandler.this.defaultEndPoint.path(RemoteSessionEventHandler.this.autSessionId).type("application/json");
                return (ClientResponse)invocationBuilder.put(ClientResponse.class, (Object)("{\"action\": \"setSizeStart\", \"size\":{\"width\": " + size.getWidth() + ", \"height\": " + size.getHeight() + "}}"));
            }
        });
    }

    public void setSizeEnded() {
        this.sendMessage(new RestClient.HttpMethodCall(){

            @Override
            public ClientResponse call() {
                WebResource.Builder invocationBuilder = RemoteSessionEventHandler.this.defaultEndPoint.path(RemoteSessionEventHandler.this.autSessionId).accept(new String[]{"application/json"});
                return (ClientResponse)invocationBuilder.put(ClientResponse.class, (Object)"{\"action\": \"setSizeEnd\"}");
            }
        });
    }

    public void testStarted(String autSessionId) {
        final String autSessionIdFinal = autSessionId;
        this.sendMessage(new RestClient.HttpMethodCall(){

            @Override
            public ClientResponse call() {
                WebResource.Builder invocationBuilder = RemoteSessionEventHandler.this.defaultEndPoint.accept(new String[]{"application/json"});
                return (ClientResponse)invocationBuilder.post(ClientResponse.class, (Object)("{\"autSessionId\": \"" + autSessionIdFinal + "\"}"));
            }
        });
        this.autSessionId = autSessionId;
    }

    public void testEnded(String autSessionId, final TestResults testResults) {
        final String autSessionIdFinal = autSessionId;
        this.sendMessage(new RestClient.HttpMethodCall(){

            @Override
            public ClientResponse call() {
                String testResultJson;
                WebResource.Builder invocationBuilder = RemoteSessionEventHandler.this.defaultEndPoint.path(autSessionIdFinal).accept(new String[]{"application/json"});
                ObjectMapper jsonMapper = new ObjectMapper();
                try {
                    testResultJson = jsonMapper.writeValueAsString((Object)testResults);
                }
                catch (JsonProcessingException e) {
                    testResultJson = "{}";
                    e.printStackTrace();
                }
                return (ClientResponse)invocationBuilder.put(ClientResponse.class, (Object)("{\"action\": \"testEnd\", \"testResults\":" + testResultJson + "}"));
            }
        });
    }

    public void validationWillStart(String autSessionId, final ValidationInfo validationInfo) {
        final String autSessionIdFinal = autSessionId;
        this.sendMessage(new RestClient.HttpMethodCall(){

            @Override
            public ClientResponse call() {
                WebResource.Builder invocationBuilder = RemoteSessionEventHandler.this.defaultEndPoint.path(autSessionIdFinal).path("validations").accept(new String[]{"application/json"});
                return (ClientResponse)invocationBuilder.post(ClientResponse.class, (Object)validationInfo.toJsonString());
            }
        });
    }

    public void validationEnded(String autSessionId, final String validationId, final ValidationResult validationResult) {
        final String autSessionIdFinal = autSessionId;
        this.sendMessage(new RestClient.HttpMethodCall(){

            @Override
            public ClientResponse call() {
                WebResource.Builder invocationBuilder = RemoteSessionEventHandler.this.defaultEndPoint.path(autSessionIdFinal).path("validations").path(validationId).accept(new String[]{"application/json"});
                return (ClientResponse)invocationBuilder.put(ClientResponse.class, (Object)("{\"action\":\"validationEnd\", \"asExpected\":" + validationResult.isAsExpected() + "}"));
            }
        });
    }

    public boolean getThrowExceptions() {
        return this.throwExceptions;
    }

    public void setThrowExceptions(boolean throwExceptions) {
        this.throwExceptions = throwExceptions;
    }
}

