/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.AbstractProxySettings;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.Logger;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import com.sun.jersey.client.apache4.config.DefaultApacheHttpClient4Config;
import java.io.IOException;
import java.net.URI;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import javax.ws.rs.core.UriBuilder;

public class RestClient {
    private AbstractProxySettings abstractProxySettings;
    private int timeout;
    protected Logger logger;
    protected Client restClient;
    protected URI serverUrl;
    protected WebResource endPoint;
    protected ObjectMapper jsonMapper;

    static Client buildRestClient(int timeout, AbstractProxySettings abstractProxySettings) {
        DefaultApacheHttpClient4Config cc = new DefaultApacheHttpClient4Config();
        cc.getProperties().put("com.sun.jersey.client.property.connectTimeout", timeout);
        cc.getProperties().put("com.sun.jersey.client.property.readTimeout", timeout);
        if (abstractProxySettings != null) {
            String password;
            URI uri = URI.create(abstractProxySettings.getUri());
            UriBuilder uriBuilder = UriBuilder.fromUri((URI)uri);
            boolean changed = false;
            if (uri.getScheme() == null && uri.getHost() == null && uri.getPath() != null) {
                uriBuilder.scheme("http");
                uriBuilder.host(uri.getPath());
                uriBuilder.replacePath(null);
                changed = true;
            }
            if (uri.getPort() != abstractProxySettings.getPort()) {
                uriBuilder.port(abstractProxySettings.getPort());
                changed = true;
            }
            if (changed) {
                uri = uriBuilder.build(new Object[0]);
            }
            cc.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyURI", uri);
            String username = abstractProxySettings.getUsername();
            if (username != null) {
                cc.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyUsername", username);
            }
            if ((password = abstractProxySettings.getPassword()) != null) {
                cc.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyPassword", password);
            }
            ApacheHttpClient4 client = ApacheHttpClient4.create((ClientConfig)cc);
            return client;
        }
        return Client.create((ClientConfig)cc);
    }

    public RestClient(Logger logger, URI serverUrl, int timeout) {
        ArgumentGuard.notNull((Object)serverUrl, (String)"serverUrl");
        ArgumentGuard.greaterThanOrEqualToZero((long)timeout, (String)"timeout");
        this.logger = logger;
        this.jsonMapper = new ObjectMapper();
        this.jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.timeout = timeout;
        this.serverUrl = serverUrl;
        this.restClient = RestClient.buildRestClient(timeout, this.abstractProxySettings);
        this.endPoint = this.restClient.resource(serverUrl);
    }

    public void setLogger(Logger logger) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public RestClient(Logger logger, URI serverUrl) {
        this(logger, serverUrl, 300000);
    }

    public void setProxyBase(AbstractProxySettings abstractProxySettings) {
        this.abstractProxySettings = abstractProxySettings;
        this.restClient = RestClient.buildRestClient(this.timeout, abstractProxySettings);
        this.endPoint = this.restClient.resource(this.serverUrl);
    }

    public AbstractProxySettings getProxyBase() {
        return this.abstractProxySettings;
    }

    public void setTimeout(int timeout) {
        ArgumentGuard.greaterThanOrEqualToZero((long)timeout, (String)"timeout");
        this.timeout = timeout;
        this.restClient = RestClient.buildRestClient(timeout, this.abstractProxySettings);
        this.endPoint = this.restClient.resource(this.serverUrl);
    }

    public int getTimeout() {
        return this.timeout;
    }

    protected void setServerUrlBase(URI serverUrl) {
        ArgumentGuard.notNull((Object)serverUrl, (String)"serverUrl");
        this.serverUrl = serverUrl;
        this.endPoint = this.restClient.resource(serverUrl);
    }

    protected URI getServerUrlBase() {
        return this.serverUrl;
    }

    protected ClientResponse sendLongRequest(WebResource.Builder invocationBuilder, String method, Object entity, String mediaType) throws EyesException {
        this.logger.verbose("enter");
        String currentTime = GeneralUtils.toRfc1123((Calendar)Calendar.getInstance(TimeZone.getTimeZone("UTC")));
        invocationBuilder = (WebResource.Builder)((WebResource.Builder)invocationBuilder.header("Eyes-Expect", (Object)"202+location")).header("Eyes-Date", (Object)currentTime);
        if (entity != null && mediaType != null) {
            invocationBuilder = (WebResource.Builder)invocationBuilder.entity(entity, mediaType);
        } else if (entity != null) {
            invocationBuilder = (WebResource.Builder)invocationBuilder.entity(entity);
        }
        ClientResponse response = (ClientResponse)invocationBuilder.method(method, ClientResponse.class);
        String statusUrl = (String)response.getHeaders().getFirst((Object)"Location");
        int status = response.getStatus();
        if (statusUrl != null && status == 202) {
            response.close();
            int wait = 500;
            while (true) {
                if ((status = (response = this.get(statusUrl)).getStatus()) == 201) {
                    this.logger.verbose("exit (CREATED)");
                    return this.delete((String)response.getHeaders().getFirst((Object)"Location"));
                }
                if (response.getStatus() != 200) break;
                try {
                    Thread.sleep(wait);
                }
                catch (InterruptedException e) {
                    throw new EyesException("Long request interrupted!", (Throwable)e);
                }
                wait *= 2;
                wait = Math.min(10000, wait);
                response.close();
            }
            this.logger.verbose("exit (inside loop) (" + status + ")");
            return response;
        }
        this.logger.verbose("exit (" + status + ")");
        return response;
    }

    public String getString(String path, String accept) {
        ClientResponse response = this.sendHttpWebRequest(path, "GET", accept);
        return (String)response.getEntity(String.class);
    }

    private ClientResponse get(String path, String accept) {
        return this.sendHttpWebRequest(path, "GET", accept);
    }

    private ClientResponse get(String path) {
        return this.get(path, null);
    }

    private ClientResponse delete(String path, String accept) {
        return this.sendHttpWebRequest(path, "DELETE", accept);
    }

    private ClientResponse delete(String path) {
        return this.delete(path, null);
    }

    protected ClientResponse sendHttpWebRequest(String path, String method, String accept) {
        WebResource.Builder invocationBuilder = this.restClient.resource(path).accept(new String[]{accept});
        return (ClientResponse)invocationBuilder.method(method, ClientResponse.class);
    }

    protected String getReadResponseError(String errMsg, int statusCode, String statusPhrase, String responseBody) {
        ArgumentGuard.notNull((Object)statusPhrase, (String)"statusPhrase");
        if (errMsg == null) {
            errMsg = "";
        }
        if (responseBody == null) {
            responseBody = "";
        }
        return errMsg + " [" + statusCode + " " + statusPhrase + "] " + responseBody;
    }

    protected <T> T parseResponseWithJsonData(ClientResponse response, List<Integer> validHttpStatusCodes, Class<T> resultType) throws EyesException {
        Object resultObject;
        ArgumentGuard.notNull((Object)response, (String)"response");
        ArgumentGuard.notNull(validHttpStatusCodes, (String)"validHttpStatusCodes");
        ArgumentGuard.notNull(resultType, (String)"resultType");
        int statusCode = response.getStatus();
        String statusPhrase = ClientResponse.Status.fromStatusCode((int)response.getStatus()).getReasonPhrase();
        String data = (String)response.getEntity(String.class);
        response.close();
        if (!validHttpStatusCodes.contains(statusCode)) {
            String errorMessage = this.getReadResponseError("Invalid status code", statusCode, statusPhrase, data);
            if (statusCode == 401 || statusCode == 403) {
                errorMessage = errorMessage + "\nThis is most likely due to an invalid API key.";
            }
            throw new EyesException(errorMessage);
        }
        try {
            resultObject = this.jsonMapper.readValue(data, resultType);
        }
        catch (IOException e) {
            String errorMessage = this.getReadResponseError("Failed to de-serialize response body", statusCode, statusPhrase, data);
            throw new EyesException(errorMessage, (Throwable)e);
        }
        return (T)resultObject;
    }

    protected static interface HttpMethodCall {
        public ClientResponse call();
    }
}

