/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.IResourceUploadListener;
import com.applitools.eyes.AbstractProxySettings;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.IDownloadListener;
import com.applitools.eyes.IPutFuture;
import com.applitools.eyes.IServerConnector;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowData;
import com.applitools.eyes.RestClient;
import com.applitools.eyes.RunningSession;
import com.applitools.eyes.SessionStartInfo;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.Utils;
import com.applitools.eyes.visualgrid.PutFuture;
import com.applitools.eyes.visualgrid.ResourceFuture;
import com.applitools.eyes.visualgrid.model.RGridResource;
import com.applitools.eyes.visualgrid.model.RenderRequest;
import com.applitools.eyes.visualgrid.model.RenderStatus;
import com.applitools.eyes.visualgrid.model.RenderStatusResults;
import com.applitools.eyes.visualgrid.model.RenderingInfo;
import com.applitools.eyes.visualgrid.model.RunningRender;
import com.applitools.eyes.visualgrid.services.IResourceFuture;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.sun.jersey.api.client.AsyncWebResource;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.async.ITypeListener;
import com.sun.jersey.api.client.async.TypeListener;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.brotli.dec.BrotliInputStream;

public class ServerConnector
extends RestClient
implements IServerConnector {
    private static final int TIMEOUT = 300000;
    private static final String API_PATH = "/api/sessions/running";
    private static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final String RENDER_ID = "render-id";
    private String apiKey = null;
    private RenderingInfo renderingInfo;

    public ServerConnector(Logger logger, URI serverUrl) {
        super(logger, serverUrl, 300000);
        this.endPoint = this.endPoint.path(API_PATH);
    }

    public ServerConnector(Logger logger) {
        this(logger, GeneralUtils.geServerUrl());
    }

    public ServerConnector(URI serverUrl) {
        this(null, serverUrl);
    }

    public ServerConnector() {
        this((Logger)null);
    }

    public void setApiKey(String apiKey) {
        ArgumentGuard.notNull((Object)apiKey, (String)"apiKey");
        this.apiKey = apiKey;
    }

    public String getApiKey() {
        return this.apiKey != null ? this.apiKey : GeneralUtils.getEnvString((String)"APPLITOOLS_API_KEY");
    }

    public void setProxy(AbstractProxySettings abstractProxySettings) {
        this.setProxyBase(abstractProxySettings);
        this.endPoint = this.endPoint.path(API_PATH);
    }

    public AbstractProxySettings getProxy() {
        return this.getProxyBase();
    }

    public void setServerUrl(URI serverUrl) {
        this.setServerUrlBase(serverUrl);
        this.endPoint = this.endPoint.path(API_PATH);
    }

    public URI getServerUrl() {
        return this.getServerUrlBase();
    }

    public RunningSession startSession(SessionStartInfo sessionStartInfo) throws EyesException {
        ClientResponse response;
        String postData;
        ArgumentGuard.notNull((Object)sessionStartInfo, (String)"sessionStartInfo");
        this.logger.verbose("Using Jersey1 for REST API calls.");
        try {
            this.jsonMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
            postData = this.jsonMapper.writeValueAsString((Object)sessionStartInfo);
            this.jsonMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        }
        catch (IOException e) {
            throw new EyesException("Failed to convert sessionStartInfo into Json string!", (Throwable)e);
        }
        try {
            WebResource.Builder builder = this.endPoint.queryParam("apiKey", this.getApiKey()).accept(new String[]{"application/json"});
            response = this.sendLongRequest(builder, "POST", postData, "application/json");
        }
        catch (RuntimeException e) {
            this.logger.log("startSession(): Server request failed: " + e.getMessage());
            throw e;
        }
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
        validStatusCodes.add(ClientResponse.Status.OK.getStatusCode());
        validStatusCodes.add(ClientResponse.Status.CREATED.getStatusCode());
        RunningSession runningSession = this.parseResponseWithJsonData(response, validStatusCodes, RunningSession.class);
        int statusCode = response.getStatus();
        boolean isNewSession = statusCode == ClientResponse.Status.CREATED.getStatusCode();
        runningSession.setIsNewSession(isNewSession);
        return runningSession;
    }

    public TestResults stopSession(RunningSession runningSession, boolean isAborted, boolean save) throws EyesException {
        ArgumentGuard.notNull((Object)runningSession, (String)"runningSession");
        String sessionId = runningSession.getId();
        WebResource.Builder builder = this.endPoint.path(sessionId).queryParam("apiKey", this.getApiKey()).queryParam("aborted", String.valueOf(isAborted)).queryParam("updateBaseline", String.valueOf(save)).accept(new String[]{"application/json"});
        ClientResponse response = this.sendLongRequest(builder, "DELETE", null, null);
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
        validStatusCodes.add(ClientResponse.Status.OK.getStatusCode());
        TestResults result = this.parseResponseWithJsonData(response, validStatusCodes, TestResults.class);
        return result;
    }

    public void deleteSession(TestResults testResults) {
        ArgumentGuard.notNull((Object)testResults, (String)"testResults");
        WebResource sessionsResources = this.restClient.resource(this.serverUrl);
        WebResource.Builder builder = sessionsResources.path("/api/sessions/batches/").path(testResults.getBatchId()).path("/").path(testResults.getId()).queryParam("apiKey", this.getApiKey()).queryParam("AccessToken", testResults.getSecretToken()).accept(new String[]{"application/json"});
        builder.delete();
    }

    public MatchResult matchWindow(RunningSession runningSession, MatchWindowData matchData) throws EyesException {
        String jsonData;
        ArgumentGuard.notNull((Object)runningSession, (String)"runningSession");
        ArgumentGuard.notNull((Object)matchData, (String)"model");
        WebResource runningSessionsEndpoint = this.endPoint.path(runningSession.getId());
        try {
            jsonData = this.jsonMapper.writeValueAsString((Object)matchData);
        }
        catch (IOException e) {
            throw new EyesException("Failed to serialize model for matchWindow!", (Throwable)e);
        }
        WebResource.Builder request = runningSessionsEndpoint.queryParam("apiKey", this.getApiKey()).accept(new String[]{"application/json"});
        ClientResponse response = this.sendLongRequest(request, "POST", jsonData, "application/json");
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>(1);
        validStatusCodes.add(ClientResponse.Status.OK.getStatusCode());
        MatchResult result = this.parseResponseWithJsonData(response, validStatusCodes, MatchResult.class);
        return result;
    }

    public int uploadData(byte[] bytes, RenderingInfo renderingInfo, String targetUrl, String contentType, String mediaType) {
        WebResource target = this.restClient.resource(targetUrl);
        WebResource.Builder request = (WebResource.Builder)((WebResource.Builder)((WebResource.Builder)target.accept(new String[]{mediaType}).entity((Object)bytes, contentType)).header("X-Auth-Token", (Object)renderingInfo.getAccessToken())).header("x-ms-blob-type", (Object)"BlockBlob");
        ClientResponse response = (ClientResponse)request.put(ClientResponse.class);
        int statusCode = response.getStatus();
        response.close();
        this.logger.verbose("Upload Status Code: " + statusCode);
        return statusCode;
    }

    public void downloadString(URL uri, boolean isSecondRetry, final IDownloadListener<String> listener) {
        AsyncWebResource target = Client.create().asyncResource(uri.toString());
        AsyncWebResource.Builder request = target.accept(new String[]{"*/*"});
        request.get((ITypeListener)new TypeListener<ClientResponse>(ClientResponse.class){

            public void onComplete(Future<ClientResponse> f) {
                int status = 0;
                ClientResponse clientResponse = null;
                try {
                    clientResponse = f.get();
                    status = clientResponse.getStatus();
                    if (status > 300) {
                        ServerConnector.this.logger.verbose("Got response status code - " + status);
                        listener.onDownloadFailed();
                        return;
                    }
                    InputStream entityInputStream = clientResponse.getEntityInputStream();
                    StringWriter writer = new StringWriter();
                    IOUtils.copy((InputStream)entityInputStream, (Writer)writer, (String)ServerConnector.DEFAULT_CHARSET_NAME);
                    String theString = writer.toString();
                    listener.onDownloadComplete((Object)theString, null);
                }
                catch (Exception e) {
                    GeneralUtils.logExceptionStackTrace((Logger)ServerConnector.this.logger, (Throwable)e);
                    ServerConnector.this.logger.verbose("Failed to parse request(status= " + status + ") = " + (String)clientResponse.getEntity(String.class));
                    listener.onDownloadFailed();
                }
            }
        });
    }

    public IResourceFuture downloadResource(final URL url, String userAgent, ResourceFuture resourceFuture) {
        Client client = RestClient.buildRestClient(this.getTimeout(), this.getProxy());
        AsyncWebResource target = client.asyncResource(url.toString());
        AsyncWebResource.Builder request = target.accept(new String[]{"*/*"});
        request.header("User-Agent", (Object)userAgent);
        ResourceFuture newFuture = new ResourceFuture(url.toString(), this.logger, (IServerConnector)this, userAgent);
        Future responseFuture = request.get((ITypeListener)new TypeListener<ClientResponse>(ClientResponse.class, (IResourceFuture)newFuture){
            final /* synthetic */ IResourceFuture val$newFuture;
            {
                this.val$newFuture = iResourceFuture;
                super(x0);
            }

            public void onComplete(Future<ClientResponse> future) {
                ServerConnector.this.logger.verbose("GET callback  success");
                ClientResponse response = null;
                try {
                    response = future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    GeneralUtils.logExceptionStackTrace((Logger)ServerConnector.this.logger, (Throwable)e);
                }
                assert (response != null);
                int status = response.getStatus();
                List contentLengthHeaders = (List)response.getHeaders().get((Object)"Content-length");
                if (contentLengthHeaders != null) {
                    int contentLength = Integer.parseInt((String)contentLengthHeaders.get(0));
                    ServerConnector.this.logger.verbose("Content Length: " + contentLength);
                }
                ServerConnector.this.logger.verbose("downloading url - : " + url);
                if (status == 404) {
                    ServerConnector.this.logger.verbose("Status 404 on url - " + url);
                }
                if (status == 200 || status == 201) {
                    ServerConnector.this.logger.verbose("response: " + response);
                    byte[] content = ServerConnector.this.downloadFile(response);
                    String contentType = Utils.getResponseContentType(response);
                    String contentEncoding = Utils.getResponseContentEncoding(response);
                    if (contentEncoding != null && contentEncoding.contains("gzip")) {
                        try {
                            content = GeneralUtils.getUnGzipByteArrayOutputStream((byte[])content);
                        }
                        catch (IOException e) {
                            GeneralUtils.logExceptionStackTrace((Logger)ServerConnector.this.logger, (Throwable)e);
                        }
                    }
                    RGridResource rgResource = new RGridResource(url.toString(), contentType, content, ServerConnector.this.logger, "ResourceFuture");
                    this.val$newFuture.setResource(rgResource);
                }
                response.close();
                ServerConnector.this.logger.verbose("Response closed");
            }
        });
        newFuture.setResponseFuture(responseFuture);
        return newFuture;
    }

    public RenderingInfo getRenderInfo() {
        this.logger.verbose("enter");
        if (this.renderingInfo == null) {
            WebResource target = this.restClient.resource(this.serverUrl).path("api/sessions/renderinfo").queryParam("apiKey", this.getApiKey());
            WebResource.Builder request = target.accept(new String[]{"application/json"});
            ClientResponse response = this.sendLongRequest(request, "GET", null, null);
            ArrayList<Integer> validStatusCodes = new ArrayList<Integer>(1);
            validStatusCodes.add(ClientResponse.Status.OK.getStatusCode());
            this.renderingInfo = this.parseResponseWithJsonData(response, validStatusCodes, RenderingInfo.class);
        }
        return this.renderingInfo;
    }

    public List<RunningRender> render(RenderRequest ... renderRequests) {
        String renderId;
        ArgumentGuard.notNull((Object)renderRequests, (String)"renderRequests");
        this.logger.verbose("called with " + Arrays.toString(renderRequests));
        WebResource target = this.restClient.resource(this.renderingInfo.getServiceUrl()).path("/render");
        WebResource webResource = null;
        if (renderRequests.length > 1) {
            MultivaluedMapImpl params = new MultivaluedMapImpl();
            List<String> idsAsList = this.extractIdsFromRRequests(renderRequests);
            if (idsAsList != null && !idsAsList.isEmpty()) {
                params.put((Object)RENDER_ID, idsAsList);
                webResource = target.queryParams((MultivaluedMap)params);
            }
        } else if (renderRequests.length == 1 && (renderId = renderRequests[0].getRenderId()) != null) {
            webResource = target.queryParam(RENDER_ID, renderId);
        }
        WebResource.Builder builder = null;
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            objectMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
            byte[] bytes = objectMapper.writeValueAsString((Object)renderRequests).getBytes(StandardCharsets.UTF_8);
            if (webResource == null) {
                builder = target.getRequestBuilder();
                builder = (WebResource.Builder)builder.entity((Object)bytes, "application/json");
            } else {
                builder = webResource.entity((Object)bytes, "application/json");
            }
        }
        catch (JsonProcessingException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
        }
        assert (builder != null);
        WebResource.Builder request = (WebResource.Builder)((WebResource.Builder)builder.accept(new String[]{"application/json"})).header("X-Auth-Token", (Object)this.renderingInfo.getAccessToken());
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
        validStatusCodes.add(Response.Status.OK.getStatusCode());
        validStatusCodes.add(Response.Status.NOT_FOUND.getStatusCode());
        ClientResponse response = (ClientResponse)request.post(ClientResponse.class);
        if (validStatusCodes.contains(response.getStatus())) {
            RunningRender[] runningRenders = this.parseResponseWithJsonData(response, validStatusCodes, RunningRender[].class);
            return Arrays.asList(runningRenders);
        }
        return null;
    }

    private List<String> extractIdsFromRRequests(RenderRequest[] renderRequests) {
        ArrayList<String> ids = new ArrayList<String>();
        for (RenderRequest renderRequest : renderRequests) {
            String renderId = renderRequest.getRenderId();
            if (renderId == null) continue;
            ids.add(renderId);
        }
        return ids;
    }

    public boolean renderCheckResource(RunningRender runningRender, RGridResource resource) {
        ArgumentGuard.notNull((Object)runningRender, (String)"runningRender");
        ArgumentGuard.notNull((Object)resource, (String)"resource");
        this.logger.verbose("called with resource#" + resource.getSha256() + " for render: " + runningRender.getRenderId());
        WebResource target = this.restClient.resource(this.renderingInfo.getServiceUrl()).path("/resources/sha256/" + resource.getSha256()).queryParam(RENDER_ID, runningRender.getRenderId());
        WebResource.Builder request = target.accept(new String[]{"application/json"});
        ClientResponse response = request.head();
        return response.getStatus() == ClientResponse.Status.OK.getStatusCode();
    }

    public IPutFuture renderPutResource(RunningRender runningRender, RGridResource resource, String userAgent, IResourceUploadListener listener) {
        ArgumentGuard.notNull((Object)runningRender, (String)"runningRender");
        ArgumentGuard.notNull((Object)resource, (String)"resource");
        byte[] content = resource.getContent();
        ArgumentGuard.notNull((Object)content, (String)"resource.getContent()");
        String hash = resource.getSha256();
        String renderId = runningRender.getRenderId();
        this.logger.verbose("resource hash:" + hash + " ; url: " + resource.getUrl() + " ; render id: " + renderId);
        AsyncWebResource target = this.restClient.asyncResource(this.renderingInfo.getServiceUrl()).path("/resources/sha256/" + hash).queryParam(RENDER_ID, renderId);
        String contentType = resource.getContentType();
        AsyncWebResource.Builder builder = contentType != null && !"None".equalsIgnoreCase(contentType) ? target.entity((Object)content, contentType) : target.entity((Object)content, MediaType.APPLICATION_OCTET_STREAM_TYPE);
        builder = (AsyncWebResource.Builder)builder.header("X-Auth-Token", (Object)this.renderingInfo.getAccessToken());
        Future future = builder.put(ClientResponse.class);
        this.logger.verbose("future created.");
        PutFuture putFuture = new PutFuture(future, resource, runningRender, (IServerConnector)this, this.logger, userAgent);
        return putFuture;
    }

    public RenderStatusResults renderStatus(RunningRender runningRender) {
        List<RenderStatusResults> renderStatusResults = this.renderStatusById(runningRender.getRenderId());
        if (!renderStatusResults.isEmpty()) {
            return renderStatusResults.get(0);
        }
        return null;
    }

    public List<RenderStatusResults> renderStatusById(String ... renderIds) {
        try {
            ArgumentGuard.notNull((Object)renderIds, (String)"renderIds");
            this.logger.verbose("called for render: " + Arrays.toString(renderIds));
            WebResource.Builder target = this.restClient.resource(this.renderingInfo.getServiceUrl()).path("/render-status").header("X-Auth-Token", (Object)this.renderingInfo.getAccessToken());
            ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
            validStatusCodes.add(Response.Status.OK.getStatusCode());
            validStatusCodes.add(Response.Status.NOT_FOUND.getStatusCode());
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            objectMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
            try {
                String json = objectMapper.writeValueAsString((Object)renderIds);
                target = (WebResource.Builder)target.entity((Object)json, "application/json");
                ClientResponse response = (ClientResponse)target.post(ClientResponse.class);
                if (validStatusCodes.contains(response.getStatus())) {
                    this.logger.verbose("request succeeded");
                    RenderStatusResults[] renderStatusResults = this.parseResponseWithJsonData(response, validStatusCodes, RenderStatusResults[].class);
                    for (int i = 0; i < renderStatusResults.length; ++i) {
                        RenderStatusResults renderStatusResult = renderStatusResults[i];
                        if (renderStatusResult == null || renderStatusResult.getStatus() != RenderStatus.ERROR) continue;
                        this.logger.verbose("error on render id - " + renderStatusResult);
                    }
                    return Arrays.asList(renderStatusResults);
                }
            }
            catch (JsonProcessingException e) {
                this.logger.log("exception in render status");
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
            }
            return null;
        }
        catch (Exception e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
            return null;
        }
    }

    public IResourceFuture createResourceFuture(RGridResource gridResource, String userAgent) {
        return new ResourceFuture(gridResource, this.logger, (IServerConnector)this, userAgent);
    }

    public void setRenderingInfo(RenderingInfo renderInfo) {
        this.renderingInfo = renderInfo;
    }

    public void closeBatch(String batchId) {
        boolean dontCloseBatchesStr = GeneralUtils.getDontCloseBatches();
        if (dontCloseBatchesStr) {
            this.logger.log("APPLITOOLS_DONT_CLOSE_BATCHES environment variable set to true. Skipping batch close.");
            return;
        }
        ArgumentGuard.notNull((Object)batchId, (String)"batchId");
        this.logger.verbose("called with " + batchId);
        String url = String.format("api/sessions/batches/%s/close/bypointerid", batchId);
        WebResource target = this.restClient.resource(this.serverUrl).path(url).queryParam("apiKey", this.getApiKey());
        target.delete();
    }

    public void closeConnector() {
    }

    public boolean getDontCloseBatches() {
        return "true".equalsIgnoreCase(GeneralUtils.getEnvString((String)"APPLITOOLS_DONT_CLOSE_BATCHES"));
    }

    private byte[] downloadFile(ClientResponse response) {
        InputStream inputStream = (InputStream)response.getEntity(InputStream.class);
        Object contentEncoding = response.getHeaders().getFirst((Object)"Content-Encoding");
        byte[] bytes = new byte[]{};
        try {
            if ("br".equalsIgnoreCase((String)contentEncoding)) {
                inputStream = new BrotliInputStream(inputStream);
            }
            bytes = IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (IOException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
        }
        return bytes;
    }

    @Override
    protected ClientResponse sendHttpWebRequest(String path, String method, String accept) {
        WebResource.Builder invocationBuilder = this.restClient.resource(path).queryParam("apikey", this.getApiKey()).accept(new String[]{accept});
        return (ClientResponse)invocationBuilder.method(method, ClientResponse.class);
    }
}

