/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.connectivity.api;

import com.applitools.connectivity.api.Response;
import com.applitools.eyes.Logger;
import com.applitools.utils.ArgumentGuard;
import com.sun.jersey.api.client.ClientResponse;
import javax.ws.rs.core.MultivaluedMap;

public class ResponseImpl
extends Response {
    ClientResponse response;

    ResponseImpl(ClientResponse response, Logger logger) {
        super(logger);
        this.response = response;
        this.readEntity();
        this.logIfError();
    }

    public int getStatusCode() {
        return this.response.getStatus();
    }

    public String getStatusPhrase() {
        return ClientResponse.Status.fromStatusCode((int)this.response.getStatus()).getReasonPhrase();
    }

    public String getHeader(String name, boolean ignoreCase) {
        ArgumentGuard.notNullOrEmpty((String)name, (String)"name");
        MultivaluedMap headers = this.response.getHeaders();
        if (!ignoreCase) {
            return (String)headers.getFirst((Object)name);
        }
        for (String key : headers.keySet()) {
            if (!name.equalsIgnoreCase(key)) continue;
            return (String)headers.getFirst((Object)key);
        }
        return null;
    }

    public void readEntity() {
        this.body = (byte[])this.response.getEntity(byte[].class);
    }

    public void close() {
        this.response.close();
    }
}

