/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.connectivity.api;

import com.applitools.connectivity.api.AsyncRequest;
import com.applitools.connectivity.api.AsyncRequestCallback;
import com.applitools.connectivity.api.Response;
import com.applitools.connectivity.api.ResponseImpl;
import com.applitools.eyes.Logger;
import com.applitools.utils.ArgumentGuard;
import com.sun.jersey.api.client.AsyncWebResource;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.async.ITypeListener;
import com.sun.jersey.api.client.async.TypeListener;
import java.util.concurrent.Future;

public class AsyncRequestImpl
extends AsyncRequest {
    AsyncWebResource.Builder request;

    AsyncRequestImpl(AsyncWebResource.Builder request, Logger logger) {
        super(logger);
        this.request = request;
    }

    public AsyncRequest header(String name, String value) {
        ArgumentGuard.notNullOrEmpty((String)name, (String)"name");
        this.request = (AsyncWebResource.Builder)this.request.header(name, (Object)value);
        return this;
    }

    public Future<?> method(String method, final AsyncRequestCallback callback, Object data, String contentType, final boolean logIfError) {
        ArgumentGuard.notNullOrEmpty((String)method, (String)"method");
        if (data != null) {
            this.request = contentType == null ? (AsyncWebResource.Builder)this.request.entity(data) : (AsyncWebResource.Builder)this.request.entity(data, contentType);
        }
        return this.request.method(method, (ITypeListener)new TypeListener<ClientResponse>(ClientResponse.class){

            public void onComplete(Future<ClientResponse> f) {
                try {
                    callback.onComplete((Response)new ResponseImpl(f.get(), logIfError ? AsyncRequestImpl.this.logger : new Logger()));
                }
                catch (Exception e) {
                    callback.onFail((Throwable)e);
                }
            }
        });
    }
}

