/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.connectivity.api;

import com.applitools.connectivity.api.ConnectivityTarget;
import com.applitools.connectivity.api.ConnectivityTargetImpl;
import com.applitools.connectivity.api.HttpClient;
import com.applitools.eyes.AbstractProxySettings;
import com.applitools.eyes.Logger;
import com.applitools.eyes.logging.Stage;
import com.applitools.utils.NetworkUtils;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.client.apache4.config.DefaultApacheHttpClient4Config;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import java.io.IOException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.tuple.Pair;

public class HttpClientImpl
extends HttpClient {
    private final Client client;

    public HttpClientImpl(Logger logger, int timeout, final AbstractProxySettings abstractProxySettings) {
        super(logger, timeout, abstractProxySettings);
        logger.log(new HashSet(), Stage.GENERAL, new Pair[]{Pair.of((Object)"connectivityPackage", (Object)"jersey1x")});
        DefaultApacheHttpClient4Config clientConfig = new DefaultApacheHttpClient4Config();
        clientConfig.getProperties().put("com.sun.jersey.client.property.connectTimeout", timeout);
        clientConfig.getProperties().put("com.sun.jersey.client.property.readTimeout", timeout);
        try {
            SSLContext sslContext = NetworkUtils.getDisabledSSLContext();
            HTTPSProperties props = new HTTPSProperties(HttpsURLConnection.getDefaultHostnameVerifier(), sslContext);
            clientConfig.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", props);
        }
        catch (KeyManagementException | NoSuchAlgorithmException sslContext) {
            // empty catch block
        }
        if (abstractProxySettings == null) {
            this.client = Client.create((ClientConfig)clientConfig);
            return;
        }
        URI uri = URI.create(abstractProxySettings.getUri());
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)uri);
        boolean changed = false;
        if (uri.getScheme() == null && uri.getHost() == null && uri.getPath() != null) {
            uriBuilder.scheme("http");
            uriBuilder.host(uri.getPath());
            uriBuilder.replacePath(null);
            changed = true;
        }
        if (uri.getPort() != abstractProxySettings.getPort()) {
            uriBuilder.port(abstractProxySettings.getPort());
            changed = true;
        }
        if (changed) {
            uri = uriBuilder.build(new Object[0]);
        }
        final URI finalUri = uri;
        HttpURLConnectionFactory factory = new HttpURLConnectionFactory(){

            public HttpURLConnection getHttpURLConnection(URL url) throws IOException {
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(finalUri.getHost(), finalUri.getPort()));
                return (HttpURLConnection)url.openConnection(proxy);
            }
        };
        if (abstractProxySettings.getUsername() != null && abstractProxySettings.getPassword() != null) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(abstractProxySettings.getUsername(), abstractProxySettings.getPassword().toCharArray());
                }
            });
        }
        URLConnectionClientHandler clientHandler = new URLConnectionClientHandler(factory);
        this.client = new Client((ClientHandler)clientHandler, (ClientConfig)clientConfig);
    }

    public ConnectivityTarget target(URI baseUrl) {
        return new ConnectivityTargetImpl(this.client.resource(baseUrl), this.client.asyncResource(baseUrl), this.logger);
    }

    public ConnectivityTarget target(String path) {
        return new ConnectivityTargetImpl(this.client.resource(path), this.client.asyncResource(path), this.logger);
    }

    public void close() {
        this.isClosed = true;
    }
}

