/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.connectivity;

import com.applitools.connectivity.RestClient;
import com.applitools.connectivity.api.AsyncRequestCallback;
import com.applitools.connectivity.api.Response;
import com.applitools.eyes.EyesException;

class RequestPollingCallback
implements AsyncRequestCallback {
    private final RestClient restClient;
    private String pollingUrl;
    private final AsyncRequestCallback pollingFinishedCallback;
    private int sleepDuration = 500;
    private int requestCount = 0;

    RequestPollingCallback(RestClient restClient, String pollingUrl, AsyncRequestCallback pollingFinishedCallback) {
        this.restClient = restClient;
        this.pollingUrl = pollingUrl;
        this.pollingFinishedCallback = pollingFinishedCallback;
    }

    public void onComplete(Response response) {
        try {
            int status = response.getStatusCode();
            if (status == 201) {
                this.restClient.sendAsyncRequest(this.pollingFinishedCallback, response.getHeader("Location", true), "DELETE", new String[0]);
                return;
            }
            if (status != 200) {
                this.pollingFinishedCallback.onFail((Throwable)new EyesException(String.format("Got bad status code when polling from the server. Status code: %d", status)));
                return;
            }
        }
        finally {
            response.close();
        }
        String location = response.getHeader("Location", true);
        if (location != null) {
            this.pollingUrl = location;
        }
        int timeToWait = this.sleepDuration;
        String secondsToWait = response.getHeader("Retry-After", true);
        if (secondsToWait != null) {
            timeToWait = Integer.parseInt(secondsToWait) * 1000;
        } else if (this.requestCount++ >= 5) {
            this.sleepDuration *= 2;
            this.requestCount = 0;
            this.sleepDuration = Math.min(5000, this.sleepDuration);
        }
        try {
            Thread.sleep(timeToWait);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.restClient.sendAsyncRequest((AsyncRequestCallback)this, this.pollingUrl, "GET", new String[0]);
    }

    public void onFail(Throwable throwable) {
        this.pollingFinishedCallback.onFail(throwable);
    }
}

