/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.connectivity.api;

import com.applitools.connectivity.api.AsyncRequest;
import com.applitools.connectivity.api.AsyncRequestCallback;
import com.applitools.connectivity.api.Response;
import com.applitools.connectivity.api.ResponseImpl;
import com.applitools.eyes.Logger;
import com.applitools.utils.ArgumentGuard;
import java.util.concurrent.Future;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.InvocationCallback;

public class AsyncRequestImpl
extends AsyncRequest {
    Invocation.Builder request;

    AsyncRequestImpl(Invocation.Builder request, Logger logger) {
        super(logger);
        this.request = request;
    }

    public AsyncRequest header(String name, String value) {
        ArgumentGuard.notNullOrEmpty((String)name, (String)"header name");
        ArgumentGuard.notNullOrEmpty((String)value, (String)String.format("value of %s", name));
        this.request = this.request.header(name, (Object)value);
        return this;
    }

    public Future<?> method(String method, final AsyncRequestCallback callback, Object data, String contentType, final boolean logIfError) {
        ArgumentGuard.notNullOrEmpty((String)method, (String)"method");
        InvocationCallback<javax.ws.rs.core.Response> invocationCallback = new InvocationCallback<javax.ws.rs.core.Response>(){

            public void completed(javax.ws.rs.core.Response response) {
                try {
                    callback.onComplete((Response)new ResponseImpl(response, logIfError ? AsyncRequestImpl.this.logger : new Logger()));
                }
                catch (Exception e) {
                    callback.onFail((Throwable)e);
                }
            }

            public void failed(Throwable throwable) {
                callback.onFail(throwable);
            }
        };
        if (data == null || contentType == null) {
            return this.request.async().method(method, (InvocationCallback)invocationCallback);
        }
        return this.request.async().method(method, Entity.entity((Object)data, (String)contentType), (InvocationCallback)invocationCallback);
    }
}

