/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.images;

import com.applitools.eyes.Region;
import com.applitools.eyes.fluent.CheckSettings;
import com.applitools.eyes.images.IImagesCheckTarget;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.awt.image.BufferedImage;

@JsonIgnoreProperties(value={"image", "path"})
public class ImagesCheckSettings
extends CheckSettings
implements IImagesCheckTarget {
    private BufferedImage image;
    private String path;

    public ImagesCheckSettings(BufferedImage image) {
        this.image = image;
    }

    public ImagesCheckSettings(String path) {
        this.path = path;
    }

    public ImagesCheckSettings(BufferedImage image, Region region) {
        this.image = image;
        this.updateTargetRegion(region);
    }

    @Override
    public BufferedImage getImage() {
        return this.image;
    }

    public String getPath() {
        return this.path;
    }

    public ImagesCheckSettings clone() {
        ImagesCheckSettings clone = new ImagesCheckSettings(this.image);
        super.populateClone((CheckSettings)clone);
        clone.image = this.image;
        clone.path = this.path;
        return clone;
    }

    public ImagesCheckSettings densityMetrics(int xDpi, int yDpi) {
        return (ImagesCheckSettings)super.densityMetrics(xDpi, yDpi);
    }

    public ImagesCheckSettings densityMetrics(int xDpi, int yDpi, Double scaleRatio) {
        return (ImagesCheckSettings)super.densityMetrics(xDpi, yDpi, scaleRatio);
    }
}

