/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.images.universal.mapper;

import com.applitools.ICheckSettings;
import com.applitools.eyes.AccessibilitySettings;
import com.applitools.eyes.AutProxySettings;
import com.applitools.eyes.CutProvider;
import com.applitools.eyes.Region;
import com.applitools.eyes.config.Configuration;
import com.applitools.eyes.config.ContentInset;
import com.applitools.eyes.images.ImagesCheckSettings;
import com.applitools.eyes.images.universal.mapper.ImageCodedRegionReferenceMapper;
import com.applitools.eyes.images.universal.mapper.ImageTAccessibilityRegionMapper;
import com.applitools.eyes.images.universal.mapper.ImageTFloatingRegionMapper;
import com.applitools.eyes.options.LayoutBreakpointsOptions;
import com.applitools.eyes.universal.dto.CheckSettingsDto;
import com.applitools.eyes.universal.dto.DebugScreenshotHandlerDto;
import com.applitools.eyes.universal.dto.ICut;
import com.applitools.eyes.universal.dto.TRegion;
import com.applitools.eyes.universal.mapper.AccessibilitySettingsMapper;
import com.applitools.eyes.universal.mapper.LayoutBreakpointsMapper;
import com.applitools.eyes.universal.mapper.ProxyMapper;
import com.applitools.eyes.universal.mapper.RectangleRegionMapper;
import com.applitools.eyes.universal.mapper.SettingsMapper;
import com.applitools.eyes.universal.mapper.VisualGridOptionMapper;
import java.util.Arrays;
import java.util.List;

public class ImagesCheckSettingsMapper {
    public static CheckSettingsDto toCheckSettingsDto(ICheckSettings checkSettings, Configuration config) {
        if (!(checkSettings instanceof ImagesCheckSettings)) {
            return null;
        }
        ImagesCheckSettings imagesCheckSettings = (ImagesCheckSettings)checkSettings;
        CheckSettingsDto checkSettingsDto = new CheckSettingsDto();
        checkSettingsDto.setRegion(ImagesCheckSettingsMapper.toTRegionFromRegion(imagesCheckSettings.getTargetRegion()));
        checkSettingsDto.setFrames(null);
        checkSettingsDto.setFully(imagesCheckSettings.getStitchContent());
        checkSettingsDto.setScrollRootElement(null);
        checkSettingsDto.setStitchMode(imagesCheckSettings.getStitchMode() != null ? imagesCheckSettings.getStitchMode().getName() : (config.getStitchMode() != null ? config.getStitchMode().getName() : null));
        checkSettingsDto.setHideScrollbars(imagesCheckSettings.getHideScrollBars());
        checkSettingsDto.setHideCaret(imagesCheckSettings.getHideCaret());
        checkSettingsDto.setOverlap(config.getOverlap());
        checkSettingsDto.setWaitBeforeCapture(imagesCheckSettings.getWaitBeforeCapture());
        checkSettingsDto.setLazyLoad(imagesCheckSettings.getLazyLoadOptions());
        checkSettingsDto.setIgnoreDisplacements(imagesCheckSettings.isIgnoreDisplacements());
        checkSettingsDto.setNormalization(SettingsMapper.toNormalizationDto((ICut)SettingsMapper.toImageCropRect((CutProvider)config.getCutProvider(), (ContentInset)config.getContentInset()), (Integer)config.getRotation(), (Double)config.getScaleRatio()));
        checkSettingsDto.setDebugImages(new DebugScreenshotHandlerDto(config.getSaveDebugScreenshots(), config.getDebugScreenshotsPath(), config.getDebugScreenshotsPrefix()));
        checkSettingsDto.setName(imagesCheckSettings.getName());
        checkSettingsDto.setPageId(null);
        checkSettingsDto.setIgnoreRegions(ImageCodedRegionReferenceMapper.toCodedRegionReferenceList(Arrays.asList(imagesCheckSettings.getIgnoreRegions())));
        checkSettingsDto.setLayoutRegions(ImageCodedRegionReferenceMapper.toCodedRegionReferenceList(Arrays.asList(imagesCheckSettings.getLayoutRegions())));
        checkSettingsDto.setStrictRegions(ImageCodedRegionReferenceMapper.toCodedRegionReferenceList(Arrays.asList(imagesCheckSettings.getStrictRegions())));
        checkSettingsDto.setContentRegions(ImageCodedRegionReferenceMapper.toCodedRegionReferenceList(Arrays.asList(imagesCheckSettings.getContentRegions())));
        checkSettingsDto.setFloatingRegions(ImageTFloatingRegionMapper.toTFloatingRegionDtoList(Arrays.asList(imagesCheckSettings.getFloatingRegions())));
        checkSettingsDto.setAccessibilityRegions(ImageTAccessibilityRegionMapper.toTAccessibilityRegionDtoList(Arrays.asList(imagesCheckSettings.getAccessibilityRegions())));
        checkSettingsDto.setAccessibilitySettings(AccessibilitySettingsMapper.toAccessibilitySettingsDto((AccessibilitySettings)imagesCheckSettings.getAccessibilityValidation()));
        checkSettingsDto.setMatchLevel(imagesCheckSettings.getMatchLevel() == null ? null : imagesCheckSettings.getMatchLevel().getName());
        checkSettingsDto.setRetryTimeout(config.getMatchTimeout());
        checkSettingsDto.setSendDom(imagesCheckSettings.isSendDom());
        checkSettingsDto.setUseDom(imagesCheckSettings.isUseDom());
        checkSettingsDto.setEnablePatterns(imagesCheckSettings.isEnablePatterns());
        checkSettingsDto.setIgnoreCaret(imagesCheckSettings.getIgnoreCaret());
        checkSettingsDto.setUfgOptions(VisualGridOptionMapper.toVisualGridOptionDtoList((List)imagesCheckSettings.getVisualGridOptions()));
        checkSettingsDto.setLayoutBreakpoints(LayoutBreakpointsMapper.toLayoutBreakpointsDto((LayoutBreakpointsOptions)imagesCheckSettings.getLayoutBreakpointsOptions()));
        checkSettingsDto.setDisableBrowserFetching(imagesCheckSettings.isDisableBrowserFetching());
        checkSettingsDto.setAutProxy(ProxyMapper.toAutProxyDto((AutProxySettings)config.getAutProxy()));
        checkSettingsDto.setHooks(imagesCheckSettings.getScriptHooks());
        checkSettingsDto.setDensityMetrics(imagesCheckSettings.getDensityMetrics());
        return checkSettingsDto;
    }

    private static TRegion toTRegionFromRegion(Region region) {
        if (region != null) {
            return RectangleRegionMapper.toRectangleRegionDto((Region)region);
        }
        return null;
    }
}

