/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.playwright.universal.dto;

import com.applitools.eyes.WebDriverProxySettings;
import com.applitools.eyes.universal.Reference;
import com.applitools.eyes.universal.dto.ITargetDto;
import com.applitools.eyes.universal.dto.ProxyDto;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.microsoft.playwright.Page;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Driver
extends Reference
implements ITargetDto {
    private ProxyDto proxy = null;
    @JsonIgnore
    private Page page;
    @JsonIgnore
    private Reference root;

    public Driver() {
        this.root = new Reference();
        this.root.setApplitoolsRefId(UUID.randomUUID().toString());
    }

    public Driver(Page page) {
        this.page = page;
        this.root = new Driver();
        this.root.setApplitoolsRefId(UUID.randomUUID().toString());
    }

    public Page getPage() {
        return this.page;
    }

    public void setPage(Page page) {
        this.page = page;
    }

    public Reference getRoot() {
        return this.root;
    }

    public void setWebDriverProxy(WebDriverProxySettings webDriverProxy) {
        if (webDriverProxy == null) {
            return;
        }
        this.proxy = new ProxyDto();
        this.setUrl(webDriverProxy.getUrl());
        this.setUsername(webDriverProxy.getUsername());
        this.setPassword(webDriverProxy.getPassword());
    }

    public String getUrl() {
        return this.proxy != null ? this.proxy.getUrl() : null;
    }

    public void setUrl(String url) {
        if (this.proxy == null) {
            this.proxy = new ProxyDto();
        }
        this.proxy.setUrl(url);
    }

    public String getUsername() {
        return this.proxy != null ? this.proxy.getUsername() : null;
    }

    public void setUsername(String username) {
        if (this.proxy == null) {
            this.proxy = new ProxyDto();
        }
        this.proxy.setUsername(username);
    }

    public String getPassword() {
        return this.proxy != null ? this.proxy.getPassword() : null;
    }

    public void setPassword(String password) {
        if (this.proxy == null) {
            this.proxy = new ProxyDto();
        }
        this.proxy.setPassword(password);
    }
}

