/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.playwright.universal.mapper;

import com.applitools.eyes.playwright.universal.Refer;
import com.applitools.eyes.playwright.universal.dto.Element;
import com.applitools.eyes.playwright.universal.dto.FrameLocator;
import com.applitools.eyes.playwright.universal.dto.Selector;
import com.applitools.eyes.universal.Reference;
import com.applitools.eyes.universal.dto.ContextReferenceDto;
import com.applitools.eyes.universal.dto.TRegion;
import com.google.common.base.Strings;
import com.microsoft.playwright.ElementHandle;
import com.microsoft.playwright.Locator;
import java.util.List;
import java.util.stream.Collectors;

public class TFramesMapper {
    public static ContextReferenceDto toContextReferenceDto(FrameLocator frame, Refer refer, Reference root) {
        Element scrollElement;
        Selector scrollSelector;
        Selector frameSelector;
        Element frameElement;
        Integer frameIndex;
        if (frame == null) {
            return null;
        }
        ContextReferenceDto contextReferenceDto = new ContextReferenceDto();
        String frameNameOrId = frame.getFrameNameOrId();
        if (!Strings.isNullOrEmpty((String)frameNameOrId)) {
            contextReferenceDto.setFrame((Object)frameNameOrId);
        }
        if ((frameIndex = frame.getFrameIndex()) != null) {
            contextReferenceDto.setFrame((Object)frameIndex);
        }
        if ((frameElement = frame.getFrameElement()) != null) {
            ElementHandle elementHandle = frameElement.getElementHandle();
            frameElement.setApplitoolsRefId(refer.ref(elementHandle, root));
            contextReferenceDto.setFrame((Object)frameElement);
        }
        if ((frameSelector = frame.getFrameSelector()) != null) {
            if (frameSelector.getLocator() != null) {
                Locator locator = frameSelector.getLocator();
                frameSelector.setApplitoolsRefId(refer.ref(locator, root));
            }
            contextReferenceDto.setFrame((Object)frameSelector);
        }
        if ((scrollSelector = frame.getScrollRootSelector()) != null) {
            if (scrollSelector.getLocator() != null) {
                Locator locator = scrollSelector.getLocator();
                scrollSelector.setApplitoolsRefId(refer.ref(locator, root));
            }
            contextReferenceDto.setScrollRootElement((TRegion)scrollSelector);
        }
        if ((scrollElement = frame.getScrollRootElement()) != null) {
            ElementHandle elementHandle = scrollElement.getElementHandle();
            scrollElement.setApplitoolsRefId(refer.ref(elementHandle, root));
            contextReferenceDto.setScrollRootElement((TRegion)scrollElement);
        }
        return contextReferenceDto;
    }

    public static List<ContextReferenceDto> toTFramesFromCheckSettings(List<FrameLocator> frameChain, Refer refer, Reference root) {
        if (frameChain == null || frameChain.isEmpty()) {
            return null;
        }
        return frameChain.stream().map(frame -> TFramesMapper.toContextReferenceDto(frame, refer, root)).collect(Collectors.toList());
    }
}

