/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.playwright.universal.mapper;

import com.applitools.ICheckSettings;
import com.applitools.eyes.Region;
import com.applitools.eyes.playwright.fluent.PlaywrightCheckSettings;
import com.applitools.eyes.playwright.universal.Refer;
import com.applitools.eyes.playwright.universal.dto.Element;
import com.applitools.eyes.playwright.universal.dto.Selector;
import com.applitools.eyes.universal.Reference;
import com.applitools.eyes.universal.dto.TRegion;
import com.applitools.eyes.universal.mapper.RectangleRegionMapper;
import com.microsoft.playwright.ElementHandle;
import com.microsoft.playwright.Locator;

public class TRegionMapper {
    public static TRegion toTRegionFromCheckSettings(ICheckSettings checkSettings, Refer refer, Reference root) {
        if (!(checkSettings instanceof PlaywrightCheckSettings)) {
            return null;
        }
        PlaywrightCheckSettings playwrightCheckSettings = (PlaywrightCheckSettings)checkSettings;
        Reference element = playwrightCheckSettings.getTargetElement();
        if (element != null) {
            Selector selector;
            if (element instanceof Element) {
                ElementHandle elementHandle = ((Element)element).getElementHandle();
                element.setApplitoolsRefId(refer.ref(elementHandle, root));
            } else if (element instanceof Selector && (selector = (Selector)element).getLocator() != null) {
                Locator locator = selector.getLocator();
                element.setApplitoolsRefId(refer.ref(locator, root));
            }
            return element;
        }
        Region region = playwrightCheckSettings.getTargetRegion();
        if (region != null) {
            return RectangleRegionMapper.toRectangleRegionDto((Region)region);
        }
        return null;
    }

    public static TRegion toTRegionDtoFromSRE(Reference scrollRootElement, Refer refer, Reference root) {
        Selector selector;
        if (scrollRootElement == null) {
            return null;
        }
        if (scrollRootElement instanceof Element) {
            ElementHandle elementHandle = ((Element)scrollRootElement).getElementHandle();
            scrollRootElement.setApplitoolsRefId(refer.ref(elementHandle, root));
        } else if (scrollRootElement instanceof Selector && (selector = (Selector)scrollRootElement).getLocator() != null) {
            Locator locator = selector.getLocator();
            scrollRootElement.setApplitoolsRefId(refer.ref(locator, root));
        }
        return scrollRootElement;
    }
}

