/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.playwright.visualgrid;

import com.applitools.eyes.AbstractProxySettings;
import com.applitools.eyes.AutProxySettings;
import com.applitools.eyes.EyesRunner;
import com.applitools.eyes.Logger;
import com.applitools.eyes.exceptions.StaleElementReferenceException;
import com.applitools.eyes.playwright.PlaywrightRunnerSettings;
import com.applitools.eyes.playwright.universal.PlaywrightStaleElementReferenceException;
import com.applitools.eyes.playwright.universal.Refer;
import com.applitools.eyes.settings.EyesManagerSettings;
import com.applitools.eyes.universal.ManagerType;
import com.applitools.eyes.universal.settings.RunnerSettings;
import com.applitools.eyes.visualgrid.services.RunnerOptions;

public class VisualGridRunner
extends EyesRunner {
    private static final PlaywrightRunnerSettings runnerSettings = new PlaywrightRunnerSettings();
    static final int DEFAULT_CONCURRENCY = 5;
    private boolean isDisabled;
    private RunnerOptions runnerOptions;

    public VisualGridRunner() {
        this(new RunnerOptions().testConcurrency(5));
    }

    public VisualGridRunner(int testConcurrency) {
        super((RunnerSettings)runnerSettings);
        this.runnerOptions = new RunnerOptions().testConcurrency(testConcurrency);
        EyesManagerSettings managerSettings = new EyesManagerSettings(null, Integer.valueOf(testConcurrency), null);
        this.managerRef = this.commandExecutor.coreMakeManager(ManagerType.VISUAL_GRID.value, managerSettings);
    }

    public VisualGridRunner(RunnerOptions runnerOptions) {
        super((RunnerSettings)runnerSettings, runnerOptions);
        this.runnerOptions = runnerOptions;
        int testConcurrency = runnerOptions.getTestConcurrency() == null ? 5 : runnerOptions.getTestConcurrency();
        EyesManagerSettings managerSettings = new EyesManagerSettings(Integer.valueOf(testConcurrency), null, null);
        this.managerRef = this.commandExecutor.coreMakeManager(ManagerType.VISUAL_GRID.value, managerSettings);
    }

    public StaleElementReferenceException getStaleElementException() {
        return new PlaywrightStaleElementReferenceException();
    }

    public AbstractProxySettings getProxy() {
        return this.runnerOptions.getProxy();
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setProxy(AbstractProxySettings proxySettings) {
        if (proxySettings != null) {
            this.runnerOptions = this.runnerOptions.proxy(proxySettings);
        }
    }

    public void setAutProxy(AutProxySettings autProxy) {
        this.runnerOptions = this.runnerOptions.autProxy(autProxy);
    }

    public AutProxySettings getAutProxy() {
        return this.runnerOptions.getAutProxy();
    }

    public void setIsDisabled(boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    public boolean getIsDisabled() {
        return this.isDisabled;
    }

    protected Refer getRefer() {
        return runnerSettings.getListener().getRefer();
    }
}

