/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.playwright;

import com.applitools.ICheckSettings;
import com.applitools.eyes.AbstractProxySettings;
import com.applitools.eyes.AccessibilitySettings;
import com.applitools.eyes.BatchInfo;
import com.applitools.eyes.CutProvider;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesRunner;
import com.applitools.eyes.IEyesBase;
import com.applitools.eyes.ImageMatchSettings;
import com.applitools.eyes.LogHandler;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchLevel;
import com.applitools.eyes.NullLogHandler;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.UnscaledFixedCutProvider;
import com.applitools.eyes.config.Configuration;
import com.applitools.eyes.locators.BaseOcrRegion;
import com.applitools.eyes.locators.TextRegion;
import com.applitools.eyes.locators.TextRegionSettings;
import com.applitools.eyes.locators.VisualLocatorSettings;
import com.applitools.eyes.playwright.ClassicRunner;
import com.applitools.eyes.playwright.fluent.IPlaywrightCheckSettings;
import com.applitools.eyes.playwright.universal.Refer;
import com.applitools.eyes.playwright.universal.dto.Driver;
import com.applitools.eyes.playwright.universal.mapper.PlaywrightCheckSettingsMapper;
import com.applitools.eyes.playwright.universal.mapper.PlaywrightOCRExtractSettingsDtoMapper;
import com.applitools.eyes.selenium.StitchMode;
import com.applitools.eyes.settings.GetResultsSettings;
import com.applitools.eyes.universal.CommandExecutor;
import com.applitools.eyes.universal.Reference;
import com.applitools.eyes.universal.dto.CheckSettingsDto;
import com.applitools.eyes.universal.dto.CloseSettingsDto;
import com.applitools.eyes.universal.dto.ConfigurationDto;
import com.applitools.eyes.universal.dto.ITargetDto;
import com.applitools.eyes.universal.dto.OCRExtractSettingsDto;
import com.applitools.eyes.universal.dto.OCRSearchSettingsDto;
import com.applitools.eyes.universal.dto.OpenSettingsDto;
import com.applitools.eyes.universal.dto.VisualLocatorSettingsDto;
import com.applitools.eyes.universal.mapper.ConfigurationMapper;
import com.applitools.eyes.universal.mapper.LocateMapper;
import com.applitools.eyes.universal.mapper.OCRSearchSettingsMapper;
import com.applitools.eyes.universal.mapper.SettingsMapper;
import com.applitools.eyes.universal.mapper.TestResultsMapper;
import com.applitools.eyes.universal.mapper.VisualLocatorSettingsMapper;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.microsoft.playwright.Page;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Eyes
implements IEyesBase {
    private EyesRunner runner;
    private CommandExecutor commandExecutor;
    private Configuration configuration = new Configuration();
    private Reference eyesRef;
    private Driver driver;
    private boolean isOpen;

    public Eyes() {
        this(new ClassicRunner());
    }

    public Eyes(EyesRunner runner0) {
        this.runner = runner0 == null ? new ClassicRunner() : runner0;
        this.commandExecutor = this.runner.getCommandExecutor();
    }

    public Page open(Page page) {
        return this.open(page, this.configuration.getAppName(), this.configuration.getTestName());
    }

    public Page open(Page page, String appName, String testName) {
        return this.open(page, appName, testName, this.configuration.getViewportSize());
    }

    public Page open(Page page, String appName, String testName, RectangleSize viewportSize) {
        if (this.getIsDisabled().booleanValue()) {
            return page;
        }
        this.driver = new Driver(page);
        this.driver.setApplitoolsRefId(this.getRefer().ref(page, this.driver.getRoot()));
        this.driver.setWebDriverProxy(this.configuration.getWebDriverProxy());
        this.configuration.setAppName(appName).setTestName(testName);
        if (viewportSize != null && !viewportSize.isEmpty()) {
            this.configuration.setViewportSize(new RectangleSize(viewportSize));
        }
        ConfigurationDto configurationDto = ConfigurationMapper.toConfigurationDto((Configuration)this.configuration, (Boolean)this.runner.isDontCloseBatches());
        AbstractProxySettings proxy = this.configuration.getProxy();
        if (proxy == null) {
            proxy = this.runner.getProxy();
        }
        if (proxy != null) {
            this.setProxy(proxy);
        }
        OpenSettingsDto settingsDto = SettingsMapper.toOpenSettingsDto((Configuration)this.configuration, (AbstractProxySettings)proxy, (Boolean)this.runner.isDontCloseBatches());
        this.eyesRef = this.commandExecutor.managerOpenEyes(this.runner.getManagerRef(), (ITargetDto)this.driver, settingsDto, configurationDto);
        this.isOpen = true;
        return page;
    }

    public void check(ICheckSettings ... checkSettings) {
        for (ICheckSettings checkSettings1 : checkSettings) {
            this.check(checkSettings1);
        }
    }

    public void check(String tag, ICheckSettings checkSettings) {
        this.check(checkSettings.withName(tag));
    }

    public void check(ICheckSettings checkSettings) {
        if (this.getIsDisabled().booleanValue()) {
            return;
        }
        IPlaywrightCheckSettings playwrightCheckSettings = checkSettings instanceof IPlaywrightCheckSettings ? (IPlaywrightCheckSettings)checkSettings : null;
        ArgumentGuard.notNull((Object)playwrightCheckSettings, (String)"checkSettings");
        CheckSettingsDto checkSettingsDto = PlaywrightCheckSettingsMapper.toCheckSettingsDto(playwrightCheckSettings, this.configure(), this.getRefer(), this.driver.getRoot());
        this.checkDto(checkSettingsDto, this.driver);
    }

    public List<String> extractText(BaseOcrRegion ... ocrRegions) {
        if (!this.getIsOpen()) {
            this.abort();
            throw new EyesException("Eyes not open");
        }
        List<OCRExtractSettingsDto> ocrExtractSettingsDtoList = PlaywrightOCRExtractSettingsDtoMapper.toOCRExtractSettingsDtoList(Arrays.asList(ocrRegions), this.getRefer(), this.driver.getRoot());
        ConfigurationDto configurationDto = ConfigurationMapper.toConfigurationDto((Configuration)this.configure(), (Boolean)false);
        return this.extractTextDto(this.driver, ocrExtractSettingsDtoList, configurationDto);
    }

    public Map<String, List<TextRegion>> extractTextRegions(TextRegionSettings textRegionSettings) {
        OCRSearchSettingsDto ocrSearchSettingsDto = OCRSearchSettingsMapper.toOCRSearchSettingsDto((TextRegionSettings)textRegionSettings);
        ConfigurationDto configurationDto = ConfigurationMapper.toConfigurationDto((Configuration)this.configure(), (Boolean)false);
        return this.locateTextDto(this.driver, ocrSearchSettingsDto, configurationDto);
    }

    public Map<String, List<Region>> locate(VisualLocatorSettings visualLocatorSettings) {
        ArgumentGuard.notNull((Object)visualLocatorSettings, (String)"visualLocatorSettings");
        if (!this.getIsOpen()) {
            this.abort();
            throw new EyesException("Eyes not open");
        }
        VisualLocatorSettingsDto visualLocatorSettingsDto = VisualLocatorSettingsMapper.toVisualLocatorSettingsDto((VisualLocatorSettings)visualLocatorSettings);
        ConfigurationDto configurationDto = ConfigurationMapper.toConfigurationDto((Configuration)this.configure(), (Boolean)false);
        ITargetDto target = visualLocatorSettings.toTarget((ITargetDto)this.driver);
        return this.locateDto(target, visualLocatorSettingsDto, configurationDto);
    }

    public TestResults close() {
        return this.close(true);
    }

    public TestResults close(boolean shouldThrowException) {
        if (this.getIsDisabled().booleanValue()) {
            return null;
        }
        if (!this.getIsOpen()) {
            throw new EyesException("Eyes not open");
        }
        ConfigurationDto configurationDto = ConfigurationMapper.toConfigurationDto((Configuration)this.configuration, (Boolean)this.runner.isDontCloseBatches());
        CloseSettingsDto settings = SettingsMapper.toCloseSettingsDto((Configuration)this.getConfiguration());
        this.commandExecutor.close(this.eyesRef, settings, configurationDto);
        List<TestResults> testResults = this.getResults(shouldThrowException);
        this.isOpen = false;
        return testResults != null ? testResults.get(0) : null;
    }

    public Configuration configure() {
        return this.configuration;
    }

    public Configuration setAppName(String appName) {
        return this.configure().setAppName(appName);
    }

    public Configuration setTestName(String testName) {
        return this.configure().setTestName(testName);
    }

    public String getAppName() {
        return this.configure().getAppName();
    }

    public String getTestName() {
        return this.configure().getTestName();
    }

    public Configuration setBranchName(String branchName) {
        return this.configure().setBranchName(branchName);
    }

    public Configuration setAgentId(String agentId) {
        return this.configure().setAgentId(agentId);
    }

    public String getBranchName() {
        return this.configure().getBranchName();
    }

    public String getAgentId() {
        return this.configure().getAgentId();
    }

    public Configuration setParentBranchName(String branchName) {
        return this.configure().setParentBranchName(branchName);
    }

    public String getParentBranchName() {
        return this.configure().getParentBranchName();
    }

    public Configuration setBaselineBranchName(String branchName) {
        return this.configure().setBaselineBranchName(branchName);
    }

    public String getBaselineBranchName() {
        return this.configure().getBaselineBranchName();
    }

    public Configuration setSaveDiffs(Boolean saveDiffs) {
        return this.configure().setSaveDiffs(saveDiffs);
    }

    public Boolean getSaveDiffs() {
        return this.configure().getSaveDiffs();
    }

    public Configuration setMatchTimeout(int ms) {
        return this.configure().setMatchTimeout(Integer.valueOf(ms));
    }

    public int getMatchTimeout() {
        return this.configure().getMatchTimeout();
    }

    public Configuration setSaveNewTests(boolean saveNewTests) {
        return this.configure().setSaveNewTests(Boolean.valueOf(saveNewTests));
    }

    public boolean getSaveNewTests() {
        return this.configure().getSaveNewTests();
    }

    public Configuration setSaveFailedTests(boolean saveFailedTests) {
        return this.configure().setSaveFailedTests(Boolean.valueOf(saveFailedTests));
    }

    public boolean getSaveFailedTests() {
        return this.configure().getSaveFailedTests();
    }

    public Configuration setBatch(BatchInfo batch) {
        if (this.getIsDisabled().booleanValue()) {
            return this.configure();
        }
        return this.configure().setBatch(batch);
    }

    public BatchInfo getBatch() {
        return this.configure().getBatch();
    }

    public Configuration setDefaultMatchSettings(ImageMatchSettings defaultMatchSettings) {
        ArgumentGuard.notNull((Object)defaultMatchSettings, (String)"defaultMatchSettings");
        return this.configure().setDefaultMatchSettings(defaultMatchSettings);
    }

    public ImageMatchSettings getDefaultMatchSettings() {
        return this.configure().getDefaultMatchSettings();
    }

    public Configuration setMatchLevel(MatchLevel matchLevel) {
        Configuration config = this.configure();
        config.getDefaultMatchSettings().setMatchLevel(matchLevel);
        return config;
    }

    public Configuration setIgnoreDisplacements(boolean isIgnoreDisplacements) {
        return this.configure().setIgnoreDisplacements(Boolean.valueOf(isIgnoreDisplacements));
    }

    public Configuration setAccessibilityValidation(AccessibilitySettings accessibilityValidation) {
        return this.configure().setAccessibilityValidation(accessibilityValidation);
    }

    public Configuration setUseDom(boolean useDom) {
        return this.configure().setUseDom(Boolean.valueOf(useDom));
    }

    public Configuration setEnablePatterns(boolean enablePatterns) {
        return this.configure().setEnablePatterns(Boolean.valueOf(enablePatterns));
    }

    public MatchLevel getMatchLevel() {
        return this.configure().getDefaultMatchSettings().getMatchLevel();
    }

    public boolean getIgnoreDisplacements() {
        return this.configure().getIgnoreDisplacements();
    }

    public AccessibilitySettings getAccessibilityValidation() {
        return this.configure().getAccessibilityValidation();
    }

    public boolean getUseDom() {
        return this.configure().getUseDom();
    }

    public boolean getEnablePatterns() {
        return this.configure().getEnablePatterns();
    }

    public boolean getIgnoreCaret() {
        Boolean ignoreCaret = this.configure().getDefaultMatchSettings().getIgnoreCaret();
        return ignoreCaret == null || ignoreCaret != false;
    }

    public Configuration setIgnoreCaret(boolean value) {
        Configuration config = this.configure();
        this.configure().getDefaultMatchSettings().setIgnoreCaret(Boolean.valueOf(value));
        return config;
    }

    public int getStitchOverlap() {
        return this.configure().getStitchOverlap();
    }

    public Configuration setStitchOverlap(int pixels) {
        return this.configure().setStitchOverlap(Integer.valueOf(pixels));
    }

    public Configuration setHostOS(String hostOS) {
        Configuration config = this.configure();
        if (hostOS == null || hostOS.isEmpty()) {
            config.setHostOS(null);
        } else {
            config.setHostOS(hostOS.trim());
        }
        return config;
    }

    public String getHostOS() {
        return this.configure().getHostOS();
    }

    public Configuration setHostApp(String hostApp) {
        Configuration config = this.configure();
        if (hostApp == null || hostApp.isEmpty()) {
            config.setHostApp(null);
        } else {
            config.setHostApp(hostApp.trim());
        }
        return config;
    }

    public String getHostApp() {
        return this.configure().getHostApp();
    }

    public void setBaselineName(String baselineName) {
        this.setBaselineEnvName(baselineName);
    }

    public String getBaselineName() {
        return this.getBaselineEnvName();
    }

    public Configuration setBaselineEnvName(String baselineEnvName) {
        Configuration config = this.configure();
        if (baselineEnvName == null || baselineEnvName.isEmpty()) {
            config.setBaselineEnvName(null);
        } else {
            config.setBaselineEnvName(baselineEnvName.trim());
        }
        return config;
    }

    public Configuration setEnvironmentName(String environmentName) {
        return this.configure().setEnvironmentName(environmentName);
    }

    public String getBaselineEnvName() {
        return this.configure().getBaselineEnvName();
    }

    public String getEnvironmentName() {
        return this.configure().getEnvironmentName();
    }

    public void setEnvName(String envName) {
        if (envName == null || envName.isEmpty()) {
            this.configure().setEnvironmentName(null);
        } else {
            this.configure().setEnvironmentName(envName.trim());
        }
    }

    public String getEnvName() {
        return this.configure().getEnvironmentName();
    }

    @Deprecated
    public void setAppEnvironment(String hostOS, String hostApp) {
        if (this.getIsDisabled().booleanValue()) {
            return;
        }
        this.setHostOS(hostOS);
        this.setHostApp(hostApp);
    }

    public void setConfiguration(Configuration configuration) {
        AbstractProxySettings proxy;
        URI serverUrl;
        ArgumentGuard.notNull((Object)configuration, (String)"configuration");
        String apiKey = configuration.getApiKey();
        if (apiKey != null) {
            this.setApiKey(apiKey);
        }
        if ((serverUrl = configuration.getServerUrl()) != null) {
            this.setServerUrl(serverUrl.toString());
        }
        if ((proxy = configuration.getProxy()) == null) {
            proxy = this.runner.getProxy();
        }
        if (proxy != null) {
            this.setProxy(proxy);
        }
        this.configuration = new Configuration(configuration);
    }

    public Configuration getConfiguration() {
        return new Configuration(this.configuration);
    }

    public void setProxy(AbstractProxySettings proxySettings) {
        this.configure().setProxy(proxySettings);
    }

    public AbstractProxySettings getProxy() {
        return this.configure().getProxy();
    }

    public String getApiKey() {
        return this.configure().getApiKey();
    }

    public void setApiKey(String apiKey) {
        this.configure().setApiKey(apiKey);
    }

    public URI getServerUrl() {
        return this.configure().getServerUrl();
    }

    public void setServerUrl(String serverUrl) {
        this.configure().setServerUrl(serverUrl);
    }

    public void setIsDisabled(Boolean isDisabled) {
        this.configure().setIsDisabled(isDisabled);
    }

    public Boolean getIsDisabled() {
        return this.configure().getIsDisabled();
    }

    public String getFullAgentId() {
        return this.configure().getAgentId();
    }

    public boolean getIsOpen() {
        return this.isOpen;
    }

    public void setLogHandler(LogHandler logHandler) {
    }

    public LogHandler getLogHandler() {
        return new NullLogHandler();
    }

    public Logger getLogger() {
        return new Logger();
    }

    public void addProperty(String name, String value) {
        this.configure().addProperty(name, value);
    }

    public void clearProperties() {
        this.configure().clearProperties();
    }

    public TestResults abortIfNotClosed() {
        return this.abort();
    }

    public void closeAsync() {
        if (Boolean.TRUE.equals(this.getIsDisabled())) {
            return;
        }
        if (!this.getIsOpen()) {
            throw new EyesException("Eyes not open");
        }
        ConfigurationDto configurationDto = ConfigurationMapper.toConfigurationDto((Configuration)this.configuration, (Boolean)this.runner.isDontCloseBatches());
        CloseSettingsDto settings = SettingsMapper.toCloseSettingsDto((Configuration)this.getConfiguration());
        this.commandExecutor.close(this.eyesRef, settings, configurationDto);
        this.isOpen = false;
        this.getRefer().destroy(this.driver.getRoot());
    }

    public void abortAsync() {
        if (this.isOpen) {
            CloseSettingsDto settings = SettingsMapper.toCloseSettingsDto((Configuration)this.getConfiguration());
            this.commandExecutor.abort(this.eyesRef, settings);
            this.isOpen = false;
            this.getRefer().destroy(this.driver.getRoot());
        }
    }

    public TestResults abort() {
        if (this.isOpen) {
            CloseSettingsDto settings = SettingsMapper.toCloseSettingsDto((Configuration)this.getConfiguration());
            this.commandExecutor.abort(this.eyesRef, settings);
            GetResultsSettings getResultsSettings = new GetResultsSettings(false);
            List getResultsResponse = this.commandExecutor.eyesGetResults(this.eyesRef, getResultsSettings);
            this.isOpen = false;
            this.getRefer().destroy(this.driver.getRoot());
            List testResults = TestResultsMapper.toTestResultsList((List)getResultsResponse, (String)this.getApiKey(), (URI)this.getServerUrl(), (AbstractProxySettings)this.getProxy());
            if (testResults != null) {
                return testResults.isEmpty() ? null : (TestResults)testResults.get(0);
            }
        }
        return null;
    }

    public List<TestResults> getResults(boolean shouldThrowException) {
        GetResultsSettings getResultsSettings = new GetResultsSettings(shouldThrowException);
        List getResultsResponse = this.commandExecutor.eyesGetResults(this.eyesRef, getResultsSettings);
        List testResults = TestResultsMapper.toTestResultsList((List)getResultsResponse, (String)this.getApiKey(), (URI)this.getServerUrl(), (AbstractProxySettings)this.getProxy());
        if (testResults == null) {
            return null;
        }
        testResults.forEach(testResults1 -> this.runner.logSessionResultsAndThrowException(shouldThrowException, testResults1));
        return testResults;
    }

    public List<TestResults> getResults() {
        return this.getResults(true);
    }

    public void setImageCut(UnscaledFixedCutProvider unscaledFixedCutProvider) {
        this.configure().setCutProvider((CutProvider)unscaledFixedCutProvider);
    }

    public void setDebugScreenshotsPath(String pathToSave) {
        this.configure().setDebugScreenshotsPath(pathToSave);
    }

    public String getDebugScreenshotsPath() {
        return this.configure().getDebugScreenshotsPath();
    }

    public void setDebugScreenshotsPrefix(String prefix) {
        this.configure().setDebugScreenshotsPrefix(prefix);
    }

    public String getDebugScreenshotsPrefix() {
        return this.configure().getDebugScreenshotsPrefix();
    }

    public void setHideScrollbars(Boolean hideScrollbars) {
        this.configure().setHideScrollbars(hideScrollbars.booleanValue());
    }

    public void setHideCaret(Boolean hideCaret) {
        this.configure().setHideCaret(hideCaret.booleanValue());
    }

    public void setStitchMode(StitchMode stitchMode) {
        this.configure().setStitchMode(stitchMode);
    }

    private void checkDto(CheckSettingsDto checkSettingsDto, ITargetDto driverTargetDto) throws EyesException {
        if (this.getIsDisabled().booleanValue()) {
            return;
        }
        if (!this.getIsOpen()) {
            this.abort();
            throw new EyesException("you must call open() before checking");
        }
        ArgumentGuard.notNull((Object)checkSettingsDto, (String)"checkSettings");
        ConfigurationDto configurationDto = ConfigurationMapper.toConfigurationDto((Configuration)this.configuration, (Boolean)this.runner.isDontCloseBatches());
        this.commandExecutor.eyesCheck(this.eyesRef, driverTargetDto, checkSettingsDto, configurationDto);
    }

    private List<String> extractTextDto(ITargetDto target, List<OCRExtractSettingsDto> settings, ConfigurationDto config) throws EyesException {
        return this.commandExecutor.extractText(target, settings, config);
    }

    private Map<String, List<TextRegion>> locateTextDto(ITargetDto target, OCRSearchSettingsDto settings, ConfigurationDto config) {
        return this.commandExecutor.locateText(target, settings, config);
    }

    private Map<String, List<Region>> locateDto(ITargetDto target, VisualLocatorSettingsDto settings, ConfigurationDto config) {
        Map response = this.commandExecutor.locate(target, settings, config);
        return LocateMapper.toLocateFromDto((Map)response);
    }

    private Refer getRefer() {
        try {
            Method getRef = this.runner.getClass().getDeclaredMethod("getRefer", new Class[0]);
            getRef.setAccessible(true);
            return (Refer)((Object)getRef.invoke((Object)this.runner, new Object[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            String message = GeneralUtils.createErrorMessageFromExceptionWithText((Exception)e, (String)"got an error trying to getRef!");
            throw new EyesException(message);
        }
    }
}

