/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.playwright.deserializers;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.playwright.universal.dto.Element;
import com.applitools.eyes.playwright.universal.dto.Selector;
import com.applitools.eyes.universal.Reference;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExecuteScriptDeserializer
extends JsonDeserializer<Object> {
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode jsonNode = (JsonNode)jsonParser.readValueAsTree();
        if (jsonNode.isObject()) {
            return this.handleObject(jsonNode);
        }
        if (jsonNode.isArray()) {
            return this.handleArray(jsonNode);
        }
        if (jsonNode.isBoolean()) {
            return jsonParser.readValueAs(Boolean.class);
        }
        if (jsonNode.isNull()) {
            return null;
        }
        throw new EyesException("Unsupported type to deserialize!");
    }

    private Object handleObject(JsonNode jsonNode) {
        ObjectMapper mapper = new ObjectMapper();
        HashMap jsonObject = (HashMap)mapper.convertValue((Object)jsonNode, (TypeReference)new TypeReference<HashMap<String, JsonNode>>(){});
        if (jsonObject.get("applitools-ref-id") != null) {
            String type = ((JsonNode)jsonObject.get("type")).asText();
            if (type.equals("element")) {
                return mapper.convertValue((Object)jsonNode, Element.class);
            }
            if (type.equals("selector")) {
                return mapper.convertValue((Object)jsonNode, Selector.class);
            }
            return mapper.convertValue((Object)jsonNode, Reference.class);
        }
        HashMap object = new HashMap();
        for (Map.Entry innerJsonNode : jsonObject.entrySet()) {
            if (((JsonNode)innerJsonNode.getValue()).isObject()) {
                object.put(innerJsonNode.getKey(), this.handleObject((JsonNode)innerJsonNode.getValue()));
                continue;
            }
            if (((JsonNode)innerJsonNode.getValue()).isArray()) {
                object.put(innerJsonNode.getKey(), this.handleArray((JsonNode)innerJsonNode.getValue()));
                continue;
            }
            if (((JsonNode)innerJsonNode.getValue()).isBoolean()) {
                object.put(innerJsonNode.getKey(), ((JsonNode)innerJsonNode.getValue()).asBoolean());
                continue;
            }
            if (((JsonNode)innerJsonNode.getValue()).isInt()) {
                object.put(innerJsonNode.getKey(), ((JsonNode)innerJsonNode.getValue()).asInt());
                continue;
            }
            if (((JsonNode)innerJsonNode.getValue()).isDouble()) {
                object.put(innerJsonNode.getKey(), ((JsonNode)innerJsonNode.getValue()).asDouble());
                continue;
            }
            if (((JsonNode)innerJsonNode.getValue()).isNull()) {
                object.put(innerJsonNode.getKey(), null);
                continue;
            }
            object.put(innerJsonNode.getKey(), ((JsonNode)innerJsonNode.getValue()).asText());
        }
        return object;
    }

    private List<Object> handleArray(JsonNode jsonNode) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (JsonNode node : jsonNode) {
            if (node.isObject()) {
                objects.add(this.handleObject(node));
                continue;
            }
            if (node.isBoolean()) {
                objects.add(node.asBoolean());
                continue;
            }
            if (node.isInt()) {
                objects.add(node.asInt());
                continue;
            }
            if (node.isDouble()) {
                objects.add(node.asDouble());
                continue;
            }
            if (node.isNull()) {
                objects.add(null);
                continue;
            }
            if (node.isArray()) {
                objects.add(this.handleArray(node));
                continue;
            }
            objects.add(node.asText(null));
        }
        return objects;
    }
}

