/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.playwright.fluent;

import com.applitools.eyes.AccessibilityRegionByRectangle;
import com.applitools.eyes.AccessibilityRegionType;
import com.applitools.eyes.AccessibilitySettings;
import com.applitools.eyes.AutProxySettings;
import com.applitools.eyes.DynamicTextType;
import com.applitools.eyes.LazyLoadOptions;
import com.applitools.eyes.MatchLevel;
import com.applitools.eyes.Padding;
import com.applitools.eyes.Region;
import com.applitools.eyes.StitchOverlap;
import com.applitools.eyes.fluent.CheckSettings;
import com.applitools.eyes.fluent.FloatingRegionByRectangle;
import com.applitools.eyes.fluent.GetRegion;
import com.applitools.eyes.fluent.SimpleRegionByRectangle;
import com.applitools.eyes.options.LayoutBreakpointsOptions;
import com.applitools.eyes.playwright.fluent.AccessibilityElement;
import com.applitools.eyes.playwright.fluent.AccessibilitySelector;
import com.applitools.eyes.playwright.fluent.DynamicElement;
import com.applitools.eyes.playwright.fluent.DynamicSelector;
import com.applitools.eyes.playwright.fluent.FloatingRegionElement;
import com.applitools.eyes.playwright.fluent.FloatingRegionSelector;
import com.applitools.eyes.playwright.fluent.IPlaywrightCheckSettings;
import com.applitools.eyes.playwright.universal.dto.Element;
import com.applitools.eyes.playwright.universal.dto.FrameLocator;
import com.applitools.eyes.playwright.universal.dto.Selector;
import com.applitools.eyes.selenium.StitchMode;
import com.applitools.eyes.universal.Reference;
import com.applitools.eyes.visualgrid.model.VisualGridOption;
import com.microsoft.playwright.ElementHandle;
import com.microsoft.playwright.Locator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class PlaywrightCheckSettings
extends CheckSettings
implements IPlaywrightCheckSettings {
    private Reference targetElement;
    private Reference scrollRootElement;
    private final List<FrameLocator> frameChain = new ArrayList<FrameLocator>();

    @Override
    public PlaywrightCheckSettings region(@Nonnull Region region) {
        PlaywrightCheckSettings clone = this.clone();
        clone.updateTargetRegion(region);
        return clone;
    }

    @Override
    public PlaywrightCheckSettings region(@Nonnull String selector) {
        return this.region(new Selector(selector));
    }

    @Override
    public PlaywrightCheckSettings region(@Nonnull Locator locator) {
        return this.region(new Selector(locator));
    }

    @Override
    public PlaywrightCheckSettings region(@Nonnull ElementHandle element) {
        return this.region(new Element(element));
    }

    private PlaywrightCheckSettings region(Selector selector) {
        PlaywrightCheckSettings clone = this.clone();
        clone.targetElement = selector;
        return clone;
    }

    private PlaywrightCheckSettings region(Element element) {
        PlaywrightCheckSettings clone = this.clone();
        clone.targetElement = element;
        return clone;
    }

    @Override
    public PlaywrightCheckSettings frame(@Nonnull String frameNameOrId) {
        FrameLocator frameLocator = new FrameLocator();
        frameLocator.setFrameNameOrId(frameNameOrId);
        return this.frame(frameLocator);
    }

    @Override
    public PlaywrightCheckSettings frame(@Nonnull Integer frameIndex) {
        FrameLocator frameLocator = new FrameLocator();
        frameLocator.setFrameIndex(frameIndex);
        return this.frame(frameLocator);
    }

    @Override
    public PlaywrightCheckSettings frame(@Nonnull Locator frameLocator) {
        return this.frame(new Selector(frameLocator));
    }

    @Override
    public PlaywrightCheckSettings frame(@Nonnull ElementHandle frameElement) {
        return this.frame(new Element(frameElement));
    }

    private PlaywrightCheckSettings frame(Selector selector) {
        FrameLocator frameLocator = new FrameLocator();
        frameLocator.setFrameSelector(selector);
        return this.frame(frameLocator);
    }

    private PlaywrightCheckSettings frame(Element element) {
        FrameLocator frameLocator = new FrameLocator();
        frameLocator.setFrameElement(element);
        return this.frame(frameLocator);
    }

    private PlaywrightCheckSettings frame(FrameLocator frameLocator) {
        PlaywrightCheckSettings clone = this.clone();
        clone.frameChain.add(frameLocator);
        return clone;
    }

    @Override
    public PlaywrightCheckSettings ignore(@Nonnull String selector) {
        return this.ignore(new Selector(selector));
    }

    @Override
    public PlaywrightCheckSettings ignore(@Nonnull Locator locator) {
        return this.ignore(new Selector(locator));
    }

    @Override
    public PlaywrightCheckSettings ignore(@Nonnull ElementHandle element) {
        return this.ignore(new Element(element));
    }

    private PlaywrightCheckSettings ignore(Selector selector) {
        PlaywrightCheckSettings clone = this.clone();
        clone.ignoreRegions.add(selector);
        return clone;
    }

    private PlaywrightCheckSettings ignore(Element element) {
        PlaywrightCheckSettings clone = this.clone();
        clone.ignoreRegions.add(element);
        return clone;
    }

    @Override
    public PlaywrightCheckSettings ignore(@Nonnull String selector, @Nonnull String regionId) {
        return this.ignore(new Selector(selector), regionId);
    }

    @Override
    public PlaywrightCheckSettings ignore(@Nonnull Locator locator, @Nonnull String regionId) {
        return this.ignore(new Selector(locator), regionId);
    }

    @Override
    public PlaywrightCheckSettings ignore(@Nonnull ElementHandle element, @Nonnull String regionId) {
        return this.ignore(new Element(element), regionId);
    }

    private PlaywrightCheckSettings ignore(Selector selector, String regionId) {
        PlaywrightCheckSettings clone = this.clone();
        selector.setRegionId(regionId);
        clone.ignoreRegions.add(selector);
        return clone;
    }

    private PlaywrightCheckSettings ignore(Element element, String regionId) {
        PlaywrightCheckSettings clone = this.clone();
        element.setRegionId(regionId);
        clone.ignoreRegions.add(element);
        return clone;
    }

    @Override
    public PlaywrightCheckSettings ignore(@Nonnull String selector, @Nonnull Padding padding) {
        return this.ignore(new Selector(selector), padding);
    }

    @Override
    public PlaywrightCheckSettings ignore(@Nonnull Locator locator, @Nonnull Padding padding) {
        return this.ignore(new Selector(locator), padding);
    }

    @Override
    public PlaywrightCheckSettings ignore(@Nonnull ElementHandle element, @Nonnull Padding padding) {
        return this.ignore(new Element(element), padding);
    }

    private PlaywrightCheckSettings ignore(@Nonnull Selector selector, @Nonnull Padding padding) {
        PlaywrightCheckSettings clone = this.clone();
        selector.setPadding(padding);
        clone.ignoreRegions.add(selector);
        return clone;
    }

    private PlaywrightCheckSettings ignore(@Nonnull Element element, @Nonnull Padding padding) {
        PlaywrightCheckSettings clone = this.clone();
        element.setPadding(padding);
        clone.ignoreRegions.add(element);
        return clone;
    }

    public PlaywrightCheckSettings ignore(@Nonnull Region[] regions) {
        PlaywrightCheckSettings clone = this.clone();
        for (Region r : regions) {
            clone.ignore_(r);
        }
        return clone;
    }

    public PlaywrightCheckSettings ignore(@Nonnull Region region, Region ... regions) {
        PlaywrightCheckSettings clone = this.clone();
        clone.ignore_(region);
        for (Region r : regions) {
            clone.ignore_(r);
        }
        return clone;
    }

    protected void ignore_(Region region) {
        SimpleRegionByRectangle simpleRegionByRectangle = new SimpleRegionByRectangle(region);
        this.ignoreRegions.add(simpleRegionByRectangle);
    }

    @Override
    public PlaywrightCheckSettings layout(@Nonnull String selector) {
        return this.layout(new Selector(selector));
    }

    @Override
    public PlaywrightCheckSettings layout(@Nonnull Locator locator) {
        return this.layout(new Selector(locator));
    }

    @Override
    public PlaywrightCheckSettings layout(@Nonnull ElementHandle element) {
        return this.layout(new Element(element));
    }

    private PlaywrightCheckSettings layout(Selector selector) {
        PlaywrightCheckSettings clone = this.clone();
        clone.layoutRegions.add(selector);
        return clone;
    }

    private PlaywrightCheckSettings layout(Element element) {
        PlaywrightCheckSettings clone = this.clone();
        clone.layoutRegions.add(element);
        return clone;
    }

    @Override
    public PlaywrightCheckSettings layout(@Nonnull String selector, @Nonnull String regionId) {
        return this.layout(new Selector(selector), regionId);
    }

    @Override
    public PlaywrightCheckSettings layout(@Nonnull Locator locator, @Nonnull String regionId) {
        return this.layout(new Selector(locator), regionId);
    }

    @Override
    public PlaywrightCheckSettings layout(@Nonnull ElementHandle element, @Nonnull String regionId) {
        return this.layout(new Element(element), regionId);
    }

    private PlaywrightCheckSettings layout(Selector selector, String regionId) {
        PlaywrightCheckSettings clone = this.clone();
        selector.setRegionId(regionId);
        clone.layoutRegions.add(selector);
        return clone;
    }

    private PlaywrightCheckSettings layout(Element element, String regionId) {
        PlaywrightCheckSettings clone = this.clone();
        element.setRegionId(regionId);
        clone.layoutRegions.add(element);
        return clone;
    }

    @Override
    public PlaywrightCheckSettings layout(@Nonnull String selector, @Nonnull Padding padding) {
        return this.layout(new Selector(selector), padding);
    }

    @Override
    public PlaywrightCheckSettings layout(@Nonnull Locator locator, @Nonnull Padding padding) {
        return this.layout(new Selector(locator), padding);
    }

    @Override
    public PlaywrightCheckSettings layout(@Nonnull ElementHandle element, @Nonnull Padding padding) {
        return this.layout(new Element(element), padding);
    }

    private PlaywrightCheckSettings layout(@Nonnull Selector selector, @Nonnull Padding padding) {
        PlaywrightCheckSettings clone = this.clone();
        selector.setPadding(padding);
        clone.layoutRegions.add(selector);
        return clone;
    }

    private PlaywrightCheckSettings layout(@Nonnull Element element, @Nonnull Padding padding) {
        PlaywrightCheckSettings clone = this.clone();
        element.setPadding(padding);
        clone.layoutRegions.add(element);
        return clone;
    }

    public PlaywrightCheckSettings layout(@Nonnull Region[] regions) {
        PlaywrightCheckSettings clone = this.clone();
        for (Region r : regions) {
            clone.layout_(r);
        }
        return clone;
    }

    public PlaywrightCheckSettings layout(@Nonnull Region region, Region ... regions) {
        PlaywrightCheckSettings clone = this.clone();
        clone.layout_(region);
        for (Region r : regions) {
            clone.layout_(r);
        }
        return clone;
    }

    protected void layout_(Region region) {
        SimpleRegionByRectangle simpleRegionByRectangle = new SimpleRegionByRectangle(region);
        this.layoutRegions.add(simpleRegionByRectangle);
    }

    @Override
    public PlaywrightCheckSettings strict(@Nonnull String selector) {
        return this.strict(new Selector(selector));
    }

    @Override
    public PlaywrightCheckSettings strict(@Nonnull Locator locator) {
        return this.strict(new Selector(locator));
    }

    @Override
    public PlaywrightCheckSettings strict(@Nonnull ElementHandle element) {
        return this.strict(new Element(element));
    }

    private PlaywrightCheckSettings strict(@Nonnull Selector selector) {
        PlaywrightCheckSettings clone = this.clone();
        clone.strictRegions.add(selector);
        return clone;
    }

    private PlaywrightCheckSettings strict(@Nonnull Element element) {
        PlaywrightCheckSettings clone = this.clone();
        clone.strictRegions.add(element);
        return clone;
    }

    @Override
    public PlaywrightCheckSettings strict(@Nonnull String selector, @Nonnull String regionId) {
        return this.strict(new Selector(selector), regionId);
    }

    @Override
    public PlaywrightCheckSettings strict(@Nonnull Locator locator, @Nonnull String regionId) {
        return this.strict(new Selector(locator), regionId);
    }

    @Override
    public PlaywrightCheckSettings strict(@Nonnull ElementHandle element, @Nonnull String regionId) {
        return this.strict(new Element(element), regionId);
    }

    private PlaywrightCheckSettings strict(Selector selector, String regionId) {
        PlaywrightCheckSettings clone = this.clone();
        selector.setRegionId(regionId);
        clone.strictRegions.add(selector);
        return clone;
    }

    private PlaywrightCheckSettings strict(Element element, String regionId) {
        PlaywrightCheckSettings clone = this.clone();
        element.setRegionId(regionId);
        clone.strictRegions.add(element);
        return clone;
    }

    @Override
    public PlaywrightCheckSettings strict(@Nonnull String selector, @Nonnull Padding padding) {
        return this.strict(new Selector(selector), padding);
    }

    @Override
    public PlaywrightCheckSettings strict(@Nonnull Locator locator, @Nonnull Padding padding) {
        return this.strict(new Selector(locator), padding);
    }

    @Override
    public PlaywrightCheckSettings strict(@Nonnull ElementHandle element, @Nonnull Padding padding) {
        return this.strict(new Element(element), padding);
    }

    private PlaywrightCheckSettings strict(@Nonnull Selector selector, @Nonnull Padding padding) {
        PlaywrightCheckSettings clone = this.clone();
        selector.setPadding(padding);
        clone.strictRegions.add(selector);
        return clone;
    }

    private PlaywrightCheckSettings strict(@Nonnull Element element, @Nonnull Padding padding) {
        PlaywrightCheckSettings clone = this.clone();
        element.setPadding(padding);
        clone.strictRegions.add(element);
        return clone;
    }

    public PlaywrightCheckSettings strict(@Nonnull Region[] regions) {
        PlaywrightCheckSettings clone = this.clone();
        for (Region r : regions) {
            clone.strict_(r);
        }
        return clone;
    }

    public PlaywrightCheckSettings strict(@Nonnull Region region, Region ... regions) {
        PlaywrightCheckSettings clone = this.clone();
        clone.strict_(region);
        for (Region r : regions) {
            clone.strict_(r);
        }
        return clone;
    }

    protected void strict_(Region region) {
        SimpleRegionByRectangle simpleRegionByRectangle = new SimpleRegionByRectangle(region);
        this.strictRegions.add(simpleRegionByRectangle);
    }

    @Override
    public PlaywrightCheckSettings ignoreColors() {
        return (PlaywrightCheckSettings)super.ignoreColors();
    }

    @Override
    public PlaywrightCheckSettings ignoreColors(@Nonnull String selector) {
        return this.ignoreColors(new Selector(selector));
    }

    @Override
    public PlaywrightCheckSettings ignoreColors(@Nonnull Locator locator) {
        return this.ignoreColors(new Selector(locator));
    }

    @Override
    public PlaywrightCheckSettings ignoreColors(@Nonnull ElementHandle element) {
        return this.ignoreColors(new Element(element));
    }

    private PlaywrightCheckSettings ignoreColors(Selector selector) {
        PlaywrightCheckSettings clone = this.clone();
        clone.contentRegions.add(selector);
        return clone;
    }

    private PlaywrightCheckSettings ignoreColors(Element element) {
        PlaywrightCheckSettings clone = this.clone();
        clone.contentRegions.add(element);
        return clone;
    }

    @Override
    public PlaywrightCheckSettings ignoreColors(@Nonnull String selector, @Nonnull String regionId) {
        return this.ignoreColors(new Selector(selector), regionId);
    }

    @Override
    public PlaywrightCheckSettings ignoreColors(@Nonnull Locator locator, @Nonnull String regionId) {
        return this.ignoreColors(new Selector(locator), regionId);
    }

    @Override
    public PlaywrightCheckSettings ignoreColors(@Nonnull ElementHandle element, @Nonnull String regionId) {
        return this.ignoreColors(new Element(element), regionId);
    }

    private PlaywrightCheckSettings ignoreColors(Selector selector, String regionId) {
        PlaywrightCheckSettings clone = this.clone();
        selector.setRegionId(regionId);
        clone.contentRegions.add(selector);
        return clone;
    }

    private PlaywrightCheckSettings ignoreColors(Element element, String regionId) {
        PlaywrightCheckSettings clone = this.clone();
        element.setRegionId(regionId);
        clone.contentRegions.add(element);
        return clone;
    }

    @Override
    public PlaywrightCheckSettings ignoreColors(@Nonnull String selector, @Nonnull Padding padding) {
        return this.ignoreColors(new Selector(selector), padding);
    }

    @Override
    public PlaywrightCheckSettings ignoreColors(@Nonnull Locator locator, @Nonnull Padding padding) {
        return this.ignoreColors(new Selector(locator), padding);
    }

    @Override
    public PlaywrightCheckSettings ignoreColors(@Nonnull ElementHandle element, @Nonnull Padding padding) {
        return this.ignoreColors(new Element(element), padding);
    }

    private PlaywrightCheckSettings ignoreColors(Selector selector, Padding padding) {
        PlaywrightCheckSettings clone = this.clone();
        selector.setPadding(padding);
        clone.contentRegions.add(selector);
        return clone;
    }

    private PlaywrightCheckSettings ignoreColors(Element element, Padding padding) {
        PlaywrightCheckSettings clone = this.clone();
        element.setPadding(padding);
        clone.contentRegions.add(element);
        return clone;
    }

    public PlaywrightCheckSettings ignoreColors(@Nonnull Region[] regions) {
        PlaywrightCheckSettings clone = this.clone();
        for (Region r : regions) {
            clone.ignoreColors_(r);
        }
        return clone;
    }

    public PlaywrightCheckSettings ignoreColors(@Nonnull Region region, Region ... regions) {
        PlaywrightCheckSettings clone = this.clone();
        clone.ignoreColors_(region);
        for (Region r : regions) {
            clone.ignoreColors_(r);
        }
        return clone;
    }

    protected void ignoreColors_(Region region) {
        SimpleRegionByRectangle simpleRegionByRectangle = new SimpleRegionByRectangle(region);
        this.contentRegions.add(simpleRegionByRectangle);
    }

    @Override
    public PlaywrightCheckSettings floating(String selector, int maxUpOffset, int maxDownOffset, int maxLeftOffset, int maxRightOffset) {
        PlaywrightCheckSettings clone = this.clone();
        clone.floatingRegions.add(new FloatingRegionSelector(selector, maxUpOffset, maxDownOffset, maxLeftOffset, maxRightOffset));
        return clone;
    }

    @Override
    public PlaywrightCheckSettings floating(Locator locator, int maxUpOffset, int maxDownOffset, int maxLeftOffset, int maxRightOffset) {
        PlaywrightCheckSettings clone = this.clone();
        clone.floatingRegions.add(new FloatingRegionSelector(locator, maxUpOffset, maxDownOffset, maxLeftOffset, maxRightOffset));
        return clone;
    }

    @Override
    public PlaywrightCheckSettings floating(ElementHandle element, int maxUpOffset, int maxDownOffset, int maxLeftOffset, int maxRightOffset) {
        PlaywrightCheckSettings clone = this.clone();
        clone.floatingRegions.add(new FloatingRegionElement(element, maxUpOffset, maxDownOffset, maxLeftOffset, maxRightOffset));
        return clone;
    }

    @Override
    public PlaywrightCheckSettings floating(int maxOffset, String selector) {
        PlaywrightCheckSettings clone = this.clone();
        clone.floatingRegions.add(new FloatingRegionSelector(selector, maxOffset));
        return clone;
    }

    @Override
    public PlaywrightCheckSettings floating(int maxOffset, Locator locator) {
        PlaywrightCheckSettings clone = this.clone();
        clone.floatingRegions.add(new FloatingRegionSelector(locator, maxOffset));
        return clone;
    }

    @Override
    public PlaywrightCheckSettings floating(int maxOffset, ElementHandle element) {
        PlaywrightCheckSettings clone = this.clone();
        clone.floatingRegions.add(new FloatingRegionElement(element, maxOffset));
        return clone;
    }

    public PlaywrightCheckSettings floating(int maxOffset, Region ... regions) {
        PlaywrightCheckSettings clone = this.clone();
        for (Region r : regions) {
            clone.floating_(r, maxOffset, maxOffset, maxOffset, maxOffset);
        }
        return clone;
    }

    public PlaywrightCheckSettings floating(Region region, int maxUpOffset, int maxDownOffset, int maxLeftOffset, int maxRightOffset) {
        PlaywrightCheckSettings clone = this.clone();
        clone.floating_(region, maxUpOffset, maxDownOffset, maxLeftOffset, maxRightOffset);
        return clone;
    }

    protected void floating_(Region region, int maxUpOffset, int maxDownOffset, int maxLeftOffset, int maxRightOffset) {
        this.floatingRegions.add(new FloatingRegionByRectangle(region, maxUpOffset, maxDownOffset, maxLeftOffset, maxRightOffset));
    }

    @Override
    public PlaywrightCheckSettings accessibility(@Nonnull String selector, AccessibilityRegionType type) {
        return this.accessibility(new AccessibilitySelector(selector, type));
    }

    @Override
    public PlaywrightCheckSettings accessibility(@Nonnull Locator locator, AccessibilityRegionType type) {
        return this.accessibility(new AccessibilitySelector(locator, type));
    }

    @Override
    public PlaywrightCheckSettings accessibility(@Nonnull ElementHandle element, AccessibilityRegionType type) {
        return this.accessibility(new AccessibilityElement(element, type));
    }

    private PlaywrightCheckSettings accessibility(AccessibilitySelector accessibilitySelector) {
        PlaywrightCheckSettings clone = this.clone();
        clone.accessibilityRegions.add(accessibilitySelector);
        return clone;
    }

    private PlaywrightCheckSettings accessibility(AccessibilityElement accessibilityElement) {
        PlaywrightCheckSettings clone = this.clone();
        clone.accessibilityRegions.add(accessibilityElement);
        return clone;
    }

    public PlaywrightCheckSettings accessibility(Region region, AccessibilityRegionType regionType) {
        PlaywrightCheckSettings clone = this.clone();
        clone.accessibility_(region, regionType);
        return clone;
    }

    protected void accessibility_(Region rect, AccessibilityRegionType regionType) {
        this.accessibilityRegions.add(new AccessibilityRegionByRectangle(rect, regionType));
    }

    public PlaywrightCheckSettings dynamic(String locator, DynamicTextType ... textTypes) {
        PlaywrightCheckSettings clone = this.clone();
        clone.dynamicRegions.add(new DynamicSelector(locator, textTypes));
        return clone;
    }

    public PlaywrightCheckSettings dynamic(Locator locator, DynamicTextType ... textTypes) {
        PlaywrightCheckSettings clone = this.clone();
        clone.dynamicRegions.add(new DynamicSelector(locator, textTypes));
        return clone;
    }

    public PlaywrightCheckSettings dynamic(@Nonnull ElementHandle element, DynamicTextType ... textTypes) {
        PlaywrightCheckSettings clone = this.clone();
        clone.dynamicRegions.add(new DynamicElement(element, textTypes));
        return clone;
    }

    public PlaywrightCheckSettings dynamic(Region region, DynamicTextType ... textTypes) {
        return (PlaywrightCheckSettings)super.dynamic(region, textTypes);
    }

    @Override
    public PlaywrightCheckSettings scrollRootElement(@Nonnull String selector) {
        return this.scrollRootElement(new Selector(selector));
    }

    @Override
    public PlaywrightCheckSettings scrollRootElement(@Nonnull Locator locator) {
        return this.scrollRootElement(new Selector(locator));
    }

    @Override
    public PlaywrightCheckSettings scrollRootElement(@Nonnull ElementHandle element) {
        return this.scrollRootElement(new Element(element));
    }

    private PlaywrightCheckSettings scrollRootElement(Selector selector) {
        PlaywrightCheckSettings clone = this.clone();
        if (this.frameChain.size() == 0) {
            clone.scrollRootElement = selector;
        } else {
            this.frameChain.get(this.frameChain.size() - 1).setScrollRootSelector(selector);
        }
        return clone;
    }

    private PlaywrightCheckSettings scrollRootElement(Element element) {
        PlaywrightCheckSettings clone = this.clone();
        if (this.frameChain.size() == 0) {
            clone.scrollRootElement = element;
        } else {
            this.frameChain.get(this.frameChain.size() - 1).setScrollRootElement(element);
        }
        return clone;
    }

    public PlaywrightCheckSettings layoutBreakpoints(int[] breakpoints) {
        return (PlaywrightCheckSettings)super.layoutBreakpoints(breakpoints);
    }

    public PlaywrightCheckSettings layoutBreakpoints(Integer ... breakpoints) {
        return (PlaywrightCheckSettings)super.layoutBreakpoints(breakpoints);
    }

    public PlaywrightCheckSettings layoutBreakpoints(Boolean shouldSet) {
        return (PlaywrightCheckSettings)super.layoutBreakpoints(shouldSet);
    }

    public PlaywrightCheckSettings layoutBreakpoints(LayoutBreakpointsOptions layoutBreakpointsOptions) {
        return (PlaywrightCheckSettings)super.layoutBreakpoints(layoutBreakpointsOptions);
    }

    @Deprecated
    public PlaywrightCheckSettings setLayoutBreakpoints(int ... breakpoints) {
        return this.layoutBreakpoints(breakpoints);
    }

    @Deprecated
    public PlaywrightCheckSettings setLayoutBreakpoints(Integer ... breakpoints) {
        return this.layoutBreakpoints(breakpoints);
    }

    @Deprecated
    public PlaywrightCheckSettings setLayoutBreakpoints(Boolean shouldSet) {
        return this.layoutBreakpoints(shouldSet);
    }

    public List<Integer> getLayoutBreakpoints() {
        return super.getLayoutBreakpoints();
    }

    public Boolean isDefaultLayoutBreakpointsSet() {
        return super.isDefaultLayoutBreakpointsSet();
    }

    public PlaywrightCheckSettings fully() {
        return this.fully(true);
    }

    public PlaywrightCheckSettings fully(Boolean fully) {
        return (PlaywrightCheckSettings)super.fully(fully);
    }

    public PlaywrightCheckSettings withName(String name) {
        return (PlaywrightCheckSettings)super.withName(name);
    }

    public PlaywrightCheckSettings ignoreCaret(Boolean ignoreCaret) {
        return (PlaywrightCheckSettings)super.ignoreCaret(ignoreCaret);
    }

    public PlaywrightCheckSettings sendDom(Boolean sendDom) {
        return (PlaywrightCheckSettings)super.sendDom(sendDom);
    }

    public PlaywrightCheckSettings sendDom() {
        return (PlaywrightCheckSettings)super.sendDom();
    }

    public PlaywrightCheckSettings enablePatterns(Boolean enablePatterns) {
        return (PlaywrightCheckSettings)super.enablePatterns(enablePatterns);
    }

    public PlaywrightCheckSettings enablePatterns() {
        return (PlaywrightCheckSettings)super.enablePatterns();
    }

    public PlaywrightCheckSettings beforeRenderScreenshotHook(String hook) {
        return (PlaywrightCheckSettings)super.beforeRenderScreenshotHook(hook);
    }

    public PlaywrightCheckSettings timeout(Integer timeoutMilliseconds) {
        return (PlaywrightCheckSettings)super.timeout(timeoutMilliseconds);
    }

    public PlaywrightCheckSettings useDom(Boolean useDom) {
        return (PlaywrightCheckSettings)super.useDom(useDom);
    }

    public PlaywrightCheckSettings variationGroupId(String variationGroupId) {
        return (PlaywrightCheckSettings)super.variationGroupId(variationGroupId);
    }

    public PlaywrightCheckSettings visualGridOptions(VisualGridOption ... options) {
        return (PlaywrightCheckSettings)super.visualGridOptions(options);
    }

    public PlaywrightCheckSettings waitBeforeCapture(Integer milliSec) {
        return (PlaywrightCheckSettings)super.waitBeforeCapture(milliSec);
    }

    public PlaywrightCheckSettings setDisableBrowserFetching(Boolean disableBrowserFetching) {
        return (PlaywrightCheckSettings)super.setDisableBrowserFetching(disableBrowserFetching);
    }

    public PlaywrightCheckSettings autProxy(AutProxySettings autProxy) {
        return (PlaywrightCheckSettings)super.autProxy(autProxy);
    }

    public PlaywrightCheckSettings setAccessibilityValidation(AccessibilitySettings accessibilitySettings) {
        return (PlaywrightCheckSettings)super.setAccessibilityValidation(accessibilitySettings);
    }

    public PlaywrightCheckSettings stitchMode(StitchMode stitchMode) {
        return (PlaywrightCheckSettings)super.stitchMode(stitchMode);
    }

    public PlaywrightCheckSettings hideScrollBars(Boolean hideScrollBars) {
        return (PlaywrightCheckSettings)super.hideScrollBars(hideScrollBars);
    }

    public PlaywrightCheckSettings hideCaret(Boolean hideCaret) {
        return (PlaywrightCheckSettings)super.hideCaret(hideCaret);
    }

    public PlaywrightCheckSettings stitchOverlap(Integer overlap) {
        return (PlaywrightCheckSettings)super.stitchOverlap(overlap);
    }

    public PlaywrightCheckSettings stitchOverlap(StitchOverlap stitchOverlap) {
        return (PlaywrightCheckSettings)super.stitchOverlap(stitchOverlap);
    }

    public PlaywrightCheckSettings pageId(String pageId) {
        return (PlaywrightCheckSettings)super.pageId(pageId);
    }

    public PlaywrightCheckSettings ignoreDisplacements(Boolean ignoreDisplacements) {
        return (PlaywrightCheckSettings)super.ignoreDisplacements(ignoreDisplacements);
    }

    public PlaywrightCheckSettings ignoreDisplacements() {
        return (PlaywrightCheckSettings)super.ignoreDisplacements();
    }

    public PlaywrightCheckSettings ignoreCaret() {
        return (PlaywrightCheckSettings)super.ignoreCaret();
    }

    public PlaywrightCheckSettings matchLevel(MatchLevel matchLevel) {
        return (PlaywrightCheckSettings)super.matchLevel(matchLevel);
    }

    public PlaywrightCheckSettings strict() {
        return (PlaywrightCheckSettings)super.strict();
    }

    public PlaywrightCheckSettings layout() {
        return (PlaywrightCheckSettings)super.layout();
    }

    public PlaywrightCheckSettings dynamic() {
        return (PlaywrightCheckSettings)super.dynamic();
    }

    public PlaywrightCheckSettings exact() {
        return (PlaywrightCheckSettings)super.exact();
    }

    public PlaywrightCheckSettings lazyLoad() {
        return (PlaywrightCheckSettings)super.lazyLoad();
    }

    public PlaywrightCheckSettings lazyLoad(LazyLoadOptions lazyLoadOptions) {
        return (PlaywrightCheckSettings)super.lazyLoad(lazyLoadOptions);
    }

    public PlaywrightCheckSettings densityMetrics(int xDpi, int yDpi) {
        return (PlaywrightCheckSettings)super.densityMetrics(xDpi, yDpi);
    }

    public PlaywrightCheckSettings densityMetrics(int xDpi, int yDpi, Double scaleRatio) {
        return (PlaywrightCheckSettings)super.densityMetrics(xDpi, yDpi, scaleRatio);
    }

    public PlaywrightCheckSettings clone() {
        PlaywrightCheckSettings clone = new PlaywrightCheckSettings();
        super.populateClone((CheckSettings)clone);
        clone.targetElement = this.targetElement;
        clone.scrollRootElement = this.scrollRootElement;
        clone.frameChain.addAll(this.frameChain);
        return clone;
    }

    public Reference getTargetElement() {
        return this.targetElement;
    }

    public Reference getScrollRootElement() {
        return this.scrollRootElement;
    }

    public List<FrameLocator> getFrameChain() {
        return this.frameChain;
    }

    public LazyLoadOptions getLazyLoadOptions() {
        return super.getLazyLoadOptions();
    }

    public GetRegion[] getIgnoreRegions() {
        return this.ignoreRegions.toArray(new GetRegion[0]);
    }

    public GetRegion[] getLayoutRegions() {
        return this.layoutRegions.toArray(new GetRegion[0]);
    }

    public GetRegion[] getStrictRegions() {
        return this.strictRegions.toArray(new GetRegion[0]);
    }

    public GetRegion[] getContentRegions() {
        return this.contentRegions.toArray(new GetRegion[0]);
    }

    public GetRegion[] getFloatingRegions() {
        return this.floatingRegions.toArray(new GetRegion[0]);
    }

    public GetRegion[] getAccessibilityRegions() {
        return this.accessibilityRegions.toArray(new GetRegion[0]);
    }

    public GetRegion[] getDynamicRegions() {
        return this.dynamicRegions.toArray(new GetRegion[0]);
    }

    @Deprecated
    public PlaywrightCheckSettings content() {
        return this.ignoreColors();
    }

    @Override
    @Deprecated
    public PlaywrightCheckSettings content(String selector) {
        return this.ignoreColors(selector);
    }

    @Override
    @Deprecated
    public PlaywrightCheckSettings content(Locator locator) {
        return this.ignoreColors(locator.elementHandle());
    }

    @Override
    @Deprecated
    public PlaywrightCheckSettings content(ElementHandle element) {
        return this.ignoreColors(element);
    }

    @Override
    @Deprecated
    public PlaywrightCheckSettings content(String selector, String regionId) {
        return this.ignoreColors(selector, regionId);
    }

    @Override
    @Deprecated
    public PlaywrightCheckSettings content(Locator locator, String regionId) {
        return this.ignoreColors(locator, regionId);
    }

    @Override
    @Deprecated
    public PlaywrightCheckSettings content(ElementHandle element, String regionId) {
        return this.ignoreColors(element, regionId);
    }

    @Override
    @Deprecated
    public PlaywrightCheckSettings content(String selector, Padding padding) {
        return this.ignoreColors(selector, padding);
    }

    @Override
    @Deprecated
    public PlaywrightCheckSettings content(Locator locator, Padding padding) {
        return this.ignoreColors(locator.elementHandle(), padding);
    }

    @Override
    @Deprecated
    public PlaywrightCheckSettings content(ElementHandle element, Padding padding) {
        return this.ignoreColors(element, padding);
    }

    @Deprecated
    public PlaywrightCheckSettings content(Region[] regions) {
        return this.ignoreColors(regions);
    }

    @Deprecated
    public PlaywrightCheckSettings content(Region region, Region ... regions) {
        return this.ignoreColors(region, regions);
    }

    @Deprecated
    public PlaywrightCheckSettings setHideCaret(Boolean hideCaret) {
        return this.hideCaret(hideCaret);
    }

    @Deprecated
    public PlaywrightCheckSettings setHideScrollBars(Boolean hideScrollBars) {
        return this.hideScrollBars(hideScrollBars);
    }
}

