/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.playwright.universal;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.eyes.playwright.universal.Refer;
import com.applitools.eyes.playwright.universal.driver.SpecDriverPlaywright;
import com.applitools.eyes.playwright.universal.driver.dto.DriverCommandDto;
import com.applitools.eyes.playwright.universal.driver.dto.DriverInfoDto;
import com.applitools.eyes.playwright.universal.dto.Context;
import com.applitools.eyes.playwright.universal.dto.Element;
import com.applitools.eyes.universal.AbstractSDKListener;
import com.applitools.eyes.universal.Reference;
import com.applitools.eyes.universal.driver.ICookie;
import com.applitools.eyes.universal.dto.ErrorDto;
import com.applitools.eyes.universal.dto.LogResponseDto;
import com.applitools.eyes.universal.dto.RectangleSizeDto;
import com.applitools.eyes.universal.dto.RequestDto;
import com.applitools.eyes.universal.dto.ResponseDto;
import com.applitools.eyes.universal.dto.ResponsePayload;
import com.fasterxml.jackson.core.type.TypeReference;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;

public class PSDKListener
extends AbstractSDKListener {
    private static volatile PSDKListener instance;
    private final Refer ref = new Refer();
    private final SpecDriverPlaywright specDriver = new SpecDriverPlaywright(this.ref);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PSDKListener getInstance() {
        if (instance != null) return instance;
        Class<AbstractSDKListener> clazz = AbstractSDKListener.class;
        synchronized (AbstractSDKListener.class) {
            if (instance != null) return instance;
            instance = new PSDKListener();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private PSDKListener() {
    }

    public Refer getRefer() {
        return this.ref;
    }

    public void onTextFrame(String payload, boolean finalFragment, int rsv) {
        try {
            ResponseDto response = (ResponseDto)this.objectMapper.readValue(payload, ResponseDto.class);
            switch (response.getName()) {
                case "Driver.getDriverInfo": {
                    ResponseDto getDriverInfoResponse = new ResponseDto();
                    getDriverInfoResponse.setName(response.getName());
                    getDriverInfoResponse.setKey(response.getKey());
                    try {
                        DriverCommandDto target = (DriverCommandDto)((RequestDto)this.objectMapper.readValue(payload, (TypeReference)new TypeReference<RequestDto<DriverCommandDto>>(){})).getPayload();
                        this.logger.log(TraceLevel.Info, Stage.SPEC_DRIVER, String.format("Executing %s with target: %s", response.getName(), target));
                        DriverInfoDto driverInfo = this.specDriver.getDriverInfo(target.getDriver());
                        getDriverInfoResponse.setPayload(new ResponsePayload((Object)driverInfo, null));
                    }
                    catch (Exception e) {
                        ErrorDto err = new ErrorDto(e.getMessage(), Arrays.toString(e.getStackTrace()), "spec-driver", null);
                        getDriverInfoResponse.setPayload(new ResponsePayload(null, err));
                    }
                    this.logger.log(TraceLevel.Info, Stage.SPEC_DRIVER, String.format("Responding to %s with: %s", response.getName(), getDriverInfoResponse));
                    super.sendTextFrame(this.objectMapper.writeValueAsString((Object)getDriverInfoResponse));
                    break;
                }
                case "Driver.executeScript": {
                    ResponseDto executeScriptResponse = new ResponseDto();
                    executeScriptResponse.setName(response.getName());
                    executeScriptResponse.setKey(response.getKey());
                    try {
                        DriverCommandDto dto = (DriverCommandDto)((RequestDto)this.objectMapper.readValue(payload, (TypeReference)new TypeReference<RequestDto<DriverCommandDto>>(){})).getPayload();
                        try {
                            this.logger.log(TraceLevel.Info, Stage.SPEC_DRIVER, String.format("Executing %s with target: %s", response.getName(), dto));
                            Object handleObject = this.specDriver.executeScript(dto.getContext(), dto.getScript(), dto.getArg());
                            executeScriptResponse.setPayload(new ResponsePayload(handleObject, null));
                        }
                        catch (Exception ex) {
                            this.logger.log(TraceLevel.Error, Stage.SPEC_DRIVER, String.format("context: %s\nscript: %s\nargs: %s", dto.getContext().toString(), dto.getScript(), dto.getArg().toString()));
                            throw ex;
                        }
                    }
                    catch (Exception e) {
                        ErrorDto err = new ErrorDto(e.getMessage(), Arrays.toString(e.getStackTrace()), "spec-driver", null);
                        executeScriptResponse.setPayload(new ResponsePayload(null, err));
                    }
                    this.logger.log(TraceLevel.Info, Stage.SPEC_DRIVER, String.format("Responding to %s with: %s", response.getName(), executeScriptResponse));
                    super.sendTextFrame(this.objectMapper.writeValueAsString((Object)executeScriptResponse));
                    break;
                }
                case "Driver.getViewportSize": {
                    ResponseDto getViewportSizeResponse = new ResponseDto();
                    getViewportSizeResponse.setName(response.getName());
                    getViewportSizeResponse.setKey(response.getKey());
                    try {
                        DriverCommandDto target = (DriverCommandDto)((RequestDto)this.objectMapper.readValue(payload, (TypeReference)new TypeReference<RequestDto<DriverCommandDto>>(){})).getPayload();
                        this.logger.log(TraceLevel.Info, Stage.SPEC_DRIVER, String.format("Executing %s with target: %s", response.getName(), target));
                        RectangleSizeDto viewportSize = this.specDriver.getViewportSize(target.getDriver());
                        getViewportSizeResponse.setPayload(new ResponsePayload((Object)viewportSize, null));
                    }
                    catch (Exception e) {
                        ErrorDto err = new ErrorDto(e.getMessage(), Arrays.toString(e.getStackTrace()), "spec-driver", null);
                        getViewportSizeResponse.setPayload(new ResponsePayload(null, err));
                    }
                    this.logger.log(TraceLevel.Info, Stage.SPEC_DRIVER, String.format("Responding to %s with: %s", response.getName(), getViewportSizeResponse));
                    super.sendTextFrame(this.objectMapper.writeValueAsString((Object)getViewportSizeResponse));
                    break;
                }
                case "Driver.setViewportSize": {
                    ResponseDto setViewportSize = new ResponseDto();
                    setViewportSize.setName(response.getName());
                    setViewportSize.setKey(response.getKey());
                    try {
                        DriverCommandDto target = (DriverCommandDto)((RequestDto)this.objectMapper.readValue(payload, (TypeReference)new TypeReference<RequestDto<DriverCommandDto>>(){})).getPayload();
                        this.logger.log(TraceLevel.Info, Stage.SPEC_DRIVER, String.format("Executing %s with target: %s", response.getName(), target));
                        this.specDriver.setViewportSize(target.getDriver(), target.getSize());
                        setViewportSize.setPayload(new ResponsePayload((Object)"complete", null));
                    }
                    catch (Exception e) {
                        ErrorDto err = new ErrorDto(e.getMessage(), Arrays.toString(e.getStackTrace()), "spec-driver", null);
                        setViewportSize.setPayload(new ResponsePayload(null, err));
                    }
                    this.logger.log(TraceLevel.Info, Stage.SPEC_DRIVER, String.format("Responding to %s with: %s", response.getName(), setViewportSize));
                    super.sendTextFrame(this.objectMapper.writeValueAsString((Object)setViewportSize));
                    break;
                }
                case "Driver.findElement": {
                    ResponseDto findElement = new ResponseDto();
                    findElement.setName(response.getName());
                    findElement.setKey(response.getKey());
                    try {
                        DriverCommandDto target = (DriverCommandDto)((RequestDto)this.objectMapper.readValue(payload, (TypeReference)new TypeReference<RequestDto<DriverCommandDto>>(){})).getPayload();
                        this.logger.log(TraceLevel.Info, Stage.SPEC_DRIVER, String.format("Executing %s with target: %s", response.getName(), target));
                        Element element = this.specDriver.findElement(target.getContext(), target.getSelector(), target.getParent());
                        findElement.setPayload(new ResponsePayload((Object)element, null));
                    }
                    catch (Exception e) {
                        ErrorDto err = new ErrorDto(e.getMessage(), Arrays.toString(e.getStackTrace()), "spec-driver", null);
                        findElement.setPayload(new ResponsePayload(null, err));
                    }
                    this.logger.log(TraceLevel.Info, Stage.SPEC_DRIVER, String.format("Responding to %s with: %s", response.getName(), findElement));
                    super.sendTextFrame(this.objectMapper.writeValueAsString((Object)findElement));
                    break;
                }
                case "Driver.findElements": {
                    ResponseDto findElements = new ResponseDto();
                    findElements.setName(response.getName());
                    findElements.setKey(response.getKey());
                    try {
                        DriverCommandDto target = (DriverCommandDto)((RequestDto)this.objectMapper.readValue(payload, (TypeReference)new TypeReference<RequestDto<DriverCommandDto>>(){})).getPayload();
                        this.logger.log(TraceLevel.Info, Stage.SPEC_DRIVER, String.format("Executing %s with target: %s", response.getName(), target));
                        List<Reference> elements = this.specDriver.findElements(target.getContext(), target.getSelector(), target.getParent());
                        findElements.setPayload(new ResponsePayload(elements, null));
                    }
                    catch (Exception e) {
                        ErrorDto err = new ErrorDto(e.getMessage(), Arrays.toString(e.getStackTrace()), "spec-driver", null);
                        findElements.setPayload(new ResponsePayload(null, err));
                    }
                    this.logger.log(TraceLevel.Info, Stage.SPEC_DRIVER, String.format("Responding to %s with: %s", response.getName(), findElements));
                    super.sendTextFrame(this.objectMapper.writeValueAsString((Object)findElements));
                    break;
                }
                case "Driver.takeScreenshot": {
                    ResponseDto takeScreenshot = new ResponseDto();
                    takeScreenshot.setName(response.getName());
                    takeScreenshot.setKey(response.getKey());
                    try {
                        DriverCommandDto target = (DriverCommandDto)((RequestDto)this.objectMapper.readValue(payload, (TypeReference)new TypeReference<RequestDto<DriverCommandDto>>(){})).getPayload();
                        this.logger.log(TraceLevel.Info, Stage.SPEC_DRIVER, String.format("Executing %s with target: %s", response.getName(), target));
                        byte[] screenshot = this.specDriver.takeScreenshot(target.getDriver());
                        takeScreenshot.setPayload(new ResponsePayload((Object)Base64.getEncoder().encodeToString(screenshot), null));
                    }
                    catch (Exception e) {
                        ErrorDto err = new ErrorDto(e.getMessage(), Arrays.toString(e.getStackTrace()), "spec-driver", null);
                        takeScreenshot.setPayload(new ResponsePayload(null, err));
                    }
                    this.logger.log(TraceLevel.Info, Stage.SPEC_DRIVER, String.format("Responding to %s with: %s", response.getName(), takeScreenshot));
                    super.sendTextFrame(this.objectMapper.writeValueAsString((Object)takeScreenshot));
                    break;
                }
                case "Driver.getTitle": {
                    ResponseDto getTitle = new ResponseDto();
                    getTitle.setName(response.getName());
                    getTitle.setKey(response.getKey());
                    try {
                        DriverCommandDto target = (DriverCommandDto)((RequestDto)this.objectMapper.readValue(payload, (TypeReference)new TypeReference<RequestDto<DriverCommandDto>>(){})).getPayload();
                        this.logger.log(TraceLevel.Info, Stage.SPEC_DRIVER, String.format("Executing %s with target: %s", response.getName(), target));
                        String title = this.specDriver.getTitle(target.getDriver());
                        getTitle.setPayload(new ResponsePayload((Object)title, null));
                    }
                    catch (Exception e) {
                        ErrorDto err = new ErrorDto(e.getMessage(), Arrays.toString(e.getStackTrace()), "spec-driver", null);
                        getTitle.setPayload(new ResponsePayload(null, err));
                    }
                    this.logger.log(TraceLevel.Info, Stage.SPEC_DRIVER, String.format("Responding to %s with: %s", response.getName(), getTitle));
                    super.sendTextFrame(this.objectMapper.writeValueAsString((Object)getTitle));
                    break;
                }
                case "Driver.getUrl": {
                    ResponseDto getUrl = new ResponseDto();
                    getUrl.setName(response.getName());
                    getUrl.setKey(response.getKey());
                    try {
                        DriverCommandDto target = (DriverCommandDto)((RequestDto)this.objectMapper.readValue(payload, (TypeReference)new TypeReference<RequestDto<DriverCommandDto>>(){})).getPayload();
                        this.logger.log(TraceLevel.Info, Stage.SPEC_DRIVER, String.format("Executing %s with target: %s", response.getName(), target));
                        String url = this.specDriver.getUrl(target.getDriver());
                        getUrl.setPayload(new ResponsePayload((Object)url, null));
                    }
                    catch (Exception e) {
                        ErrorDto err = new ErrorDto(e.getMessage(), Arrays.toString(e.getStackTrace()), "spec-driver", null);
                        getUrl.setPayload(new ResponsePayload(null, err));
                    }
                    this.logger.log(TraceLevel.Info, Stage.SPEC_DRIVER, String.format("Responding to %s with: %s", response.getName(), getUrl));
                    super.sendTextFrame(this.objectMapper.writeValueAsString((Object)getUrl));
                    break;
                }
                case "Driver.visit": {
                    ResponseDto visit = new ResponseDto();
                    visit.setName(response.getName());
                    visit.setKey(response.getKey());
                    try {
                        DriverCommandDto target = (DriverCommandDto)((RequestDto)this.objectMapper.readValue(payload, (TypeReference)new TypeReference<RequestDto<DriverCommandDto>>(){})).getPayload();
                        this.logger.log(TraceLevel.Info, Stage.SPEC_DRIVER, String.format("Executing %s with target: %s", response.getName(), target));
                        this.specDriver.visit(target.getDriver(), target.getUrl());
                        visit.setPayload(new ResponsePayload((Object)"complete", null));
                    }
                    catch (Exception e) {
                        ErrorDto err = new ErrorDto(e.getMessage(), Arrays.toString(e.getStackTrace()), "spec-driver", null);
                        visit.setPayload(new ResponsePayload(null, err));
                    }
                    this.logger.log(TraceLevel.Info, Stage.SPEC_DRIVER, String.format("Responding to %s with: %s", response.getName(), visit));
                    super.sendTextFrame(this.objectMapper.writeValueAsString((Object)visit));
                    break;
                }
                case "Driver.getCookies": {
                    ResponseDto getCookies = new ResponseDto();
                    getCookies.setName(response.getName());
                    getCookies.setKey(response.getKey());
                    try {
                        DriverCommandDto target = (DriverCommandDto)((RequestDto)this.objectMapper.readValue(payload, (TypeReference)new TypeReference<RequestDto<DriverCommandDto>>(){})).getPayload();
                        this.logger.log(TraceLevel.Info, Stage.SPEC_DRIVER, String.format("Executing %s with target: %s", response.getName(), target));
                        List<ICookie> cookies = this.specDriver.getCookies(target.getDriver(), target.getContext());
                        getCookies.setPayload(new ResponsePayload(cookies, null));
                    }
                    catch (Exception e) {
                        ErrorDto err = new ErrorDto(e.getMessage(), Arrays.toString(e.getStackTrace()), "spec-driver", null);
                        getCookies.setPayload(new ResponsePayload(null, err));
                    }
                    this.logger.log(TraceLevel.Info, Stage.SPEC_DRIVER, String.format("Responding to %s with: %s", response.getName(), getCookies));
                    super.sendTextFrame(this.objectMapper.writeValueAsString((Object)getCookies));
                    break;
                }
                case "Driver.childContext": {
                    ResponseDto childContext = new ResponseDto();
                    childContext.setName(response.getName());
                    childContext.setKey(response.getKey());
                    try {
                        DriverCommandDto target = (DriverCommandDto)((RequestDto)this.objectMapper.readValue(payload, (TypeReference)new TypeReference<RequestDto<DriverCommandDto>>(){})).getPayload();
                        this.logger.log(TraceLevel.Info, Stage.SPEC_DRIVER, String.format("Executing %s with target: %s", response.getName(), target));
                        Context context = this.specDriver.childContext(target.getContext(), target.getElement());
                        childContext.setPayload(new ResponsePayload((Object)context, null));
                    }
                    catch (Exception e) {
                        ErrorDto err = new ErrorDto(e.getMessage(), Arrays.toString(e.getStackTrace()), "spec-driver", null);
                        childContext.setPayload(new ResponsePayload(null, err));
                    }
                    this.logger.log(TraceLevel.Info, Stage.SPEC_DRIVER, String.format("Responding to %s with: %s", response.getName(), childContext));
                    super.sendTextFrame(this.objectMapper.writeValueAsString((Object)childContext));
                    break;
                }
                case "Driver.mainContext": {
                    ResponseDto mainContext = new ResponseDto();
                    mainContext.setName(response.getName());
                    mainContext.setKey(response.getKey());
                    try {
                        DriverCommandDto target = (DriverCommandDto)((RequestDto)this.objectMapper.readValue(payload, (TypeReference)new TypeReference<RequestDto<DriverCommandDto>>(){})).getPayload();
                        this.logger.log(TraceLevel.Info, Stage.SPEC_DRIVER, String.format("Executing %s with target: %s", response.getName(), target));
                        Context context = this.specDriver.mainContext(target.getContext());
                        mainContext.setPayload(new ResponsePayload((Object)context, null));
                    }
                    catch (Exception e) {
                        ErrorDto err = new ErrorDto(e.getMessage(), Arrays.toString(e.getStackTrace()), "spec-driver", null);
                        mainContext.setPayload(new ResponsePayload(null, err));
                    }
                    this.logger.log(TraceLevel.Info, Stage.SPEC_DRIVER, String.format("Responding to %s with: %s", response.getName(), mainContext));
                    super.sendTextFrame(this.objectMapper.writeValueAsString((Object)mainContext));
                    break;
                }
                case "Driver.parentContext": {
                    ResponseDto parentContext = new ResponseDto();
                    parentContext.setName(response.getName());
                    parentContext.setKey(response.getKey());
                    try {
                        DriverCommandDto target = (DriverCommandDto)((RequestDto)this.objectMapper.readValue(payload, (TypeReference)new TypeReference<RequestDto<DriverCommandDto>>(){})).getPayload();
                        this.logger.log(TraceLevel.Info, Stage.SPEC_DRIVER, String.format("Executing %s with target: %s", response.getName(), target));
                        Context context = this.specDriver.parentContext(target.getContext());
                        parentContext.setPayload(new ResponsePayload((Object)context, null));
                    }
                    catch (Exception e) {
                        ErrorDto err = new ErrorDto(e.getMessage(), Arrays.toString(e.getStackTrace()), "spec-driver", null);
                        parentContext.setPayload(new ResponsePayload(null, err));
                    }
                    this.logger.log(TraceLevel.Info, Stage.SPEC_DRIVER, String.format("Responding to %s with: %s", response.getName(), parentContext));
                    super.sendTextFrame(this.objectMapper.writeValueAsString((Object)parentContext));
                    break;
                }
                case "Core.makeManager": 
                case "Core.locate": 
                case "Core.locateText": 
                case "Core.extractText": 
                case "Core.getViewportSize": 
                case "Core.deleteTest": 
                case "Core.closeBatch": 
                case "EyesManager.openEyes": 
                case "Eyes.check": 
                case "Eyes.close": 
                case "Eyes.abort": 
                case "Eyes.getResults": 
                case "EyesManager.getResults": 
                case "Debug.getHistory": {
                    this.handleResponse(payload, (TypeReference)typeReferences.get(response.getName()));
                    break;
                }
                case "Logger.log": {
                    try {
                        LogResponseDto serverLogResponse = (LogResponseDto)this.objectMapper.readValue(payload, (TypeReference)new TypeReference<LogResponseDto>(){});
                        String message = "eyes | " + String.valueOf(new Timestamp(System.currentTimeMillis())) + " | [" + serverLogResponse.getPayload().getLevel() + "] | " + serverLogResponse.getPayload().getMessage();
                        this.logger.log(TraceLevel.Debug, Stage.GENERAL, message);
                        System.out.println(message);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                default: {
                    throw new EyesException("Unknown server command " + response.getName());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

