/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.playwright.universal.driver;

import com.applitools.eyes.playwright.universal.Refer;
import com.applitools.eyes.playwright.universal.driver.TCookie;
import com.applitools.eyes.playwright.universal.driver.dto.DriverInfoDto;
import com.applitools.eyes.playwright.universal.dto.Context;
import com.applitools.eyes.playwright.universal.dto.Element;
import com.applitools.eyes.playwright.universal.dto.Selector;
import com.applitools.eyes.universal.ISpecDriver;
import com.applitools.eyes.universal.Reference;
import com.applitools.eyes.universal.driver.ICookie;
import com.applitools.eyes.universal.dto.RectangleSizeDto;
import com.microsoft.playwright.ElementHandle;
import com.microsoft.playwright.Frame;
import com.microsoft.playwright.JSHandle;
import com.microsoft.playwright.Locator;
import com.microsoft.playwright.Page;
import com.microsoft.playwright.impl.PageImpl;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SpecDriverPlaywright
implements ISpecDriver {
    private Refer refer;

    public SpecDriverPlaywright(Refer ref) {
        this.refer = ref;
    }

    public Boolean isDriver(Object driver) {
        return driver instanceof Page;
    }

    public Boolean isContext(Reference context) {
        return super.isContext(context);
    }

    public Boolean isElement(Reference element) {
        return super.isElement(element);
    }

    public Boolean isSelector(Reference selector) {
        return super.isSelector(selector);
    }

    public Context mainContext(Reference context) {
        Frame mainFrame = this.extractContextUtil(context);
        while (mainFrame.parentFrame() != null) {
            mainFrame = mainFrame.parentFrame();
        }
        Context frameContext = new Context();
        frameContext.setApplitoolsRefId(this.refer.ref(mainFrame, context));
        return frameContext;
    }

    public Context parentContext(Reference context) {
        Frame frame = this.extractContextUtil(context);
        if (frame.parentFrame() == null) {
            return null;
        }
        Context frameContext = new Context();
        frameContext.setApplitoolsRefId(this.refer.ref(frame.parentFrame(), context));
        return frameContext;
    }

    public Context childContext(Reference context, Reference element) {
        Object root = this.refer.deref(element);
        if (root instanceof ElementHandle) {
            Context frameContext = new Context();
            Frame frame = ((ElementHandle)root).contentFrame();
            frameContext.setApplitoolsRefId(this.refer.ref(frame, element));
            return frameContext;
        }
        return null;
    }

    public Object executeScript(Reference context, String script, Object arg) {
        Object ctx = this.refer.deref(context);
        JSHandle res = null;
        Object args = this.derefArgsUtil(arg);
        if (ctx instanceof Frame) {
            res = ((Frame)ctx).evaluateHandle(script, args);
        } else if (ctx instanceof Page) {
            res = ((Page)ctx).evaluateHandle(script, args);
        }
        return this.handlerToObjectUtil(res, context);
    }

    public Element findElement(Reference driver, Reference selector, Reference parent) {
        Object context = this.refer.deref(driver);
        Object root = parent == null ? context : this.refer.deref(parent);
        Object locator = this.refer.deref(selector);
        ElementHandle elementHandle = null;
        String _selector = ((Selector)selector).getSelector();
        if (locator instanceof Locator) {
            elementHandle = ((Locator)locator).elementHandle();
        } else if (root instanceof Frame) {
            elementHandle = ((Frame)root).querySelector(_selector);
        } else if (root instanceof Page) {
            elementHandle = ((Page)root).querySelector(_selector);
        }
        if (elementHandle == null) {
            return null;
        }
        Element element = new Element();
        element.setApplitoolsRefId(this.refer.ref(elementHandle, driver));
        return element;
    }

    public List<Reference> findElements(Reference context, Reference selector, Reference parent) {
        Object ctx = this.refer.deref(context);
        Object root = parent == null ? ctx : this.refer.deref(parent);
        Object locator = this.refer.deref(selector);
        List elementHandles = new ArrayList();
        String _selector = ((Selector)selector).getSelector();
        if (locator instanceof Locator) {
            elementHandles = ((Locator)locator).elementHandles();
        } else if (root instanceof Frame) {
            elementHandles = ((Frame)root).querySelectorAll(_selector);
        } else if (root instanceof Page) {
            elementHandles = ((Page)root).querySelectorAll(_selector);
        }
        return elementHandles.stream().map(elementHandle -> {
            Element element = new Element((ElementHandle)elementHandle);
            element.setApplitoolsRefId(this.refer.ref(elementHandle, context));
            return element;
        }).collect(Collectors.toList());
    }

    public void setViewportSize(Reference driver, RectangleSizeDto windowSize) {
        Object page = this.refer.deref(driver);
        ((Page)page).setViewportSize(windowSize.getWidth().intValue(), windowSize.getHeight().intValue());
    }

    public RectangleSizeDto getViewportSize(Reference driver) {
        Object page = this.refer.deref(driver);
        RectangleSizeDto viewportSize = new RectangleSizeDto();
        viewportSize.setWidth(Integer.valueOf(((Page)page).viewportSize().width));
        viewportSize.setHeight(Integer.valueOf(((Page)page).viewportSize().height));
        return viewportSize;
    }

    public List<ICookie> getCookies(Reference driver, Reference context) {
        Page ctx = (Page)this.refer.deref(driver);
        List cookies = ctx.context().cookies();
        return cookies.stream().map(TCookie::new).collect(Collectors.toList());
    }

    public DriverInfoDto getDriverInfo(Reference driver) {
        return new DriverInfoDto();
    }

    public String getTitle(Reference driver) {
        Page context = (Page)this.refer.deref(driver);
        return context.title();
    }

    public String getUrl(Reference driver) {
        Page context = (Page)this.refer.deref(driver);
        return context.url();
    }

    public void visit(Reference driver, String url) {
        Page context = (Page)this.refer.deref(driver);
        context.navigate(url);
    }

    public byte[] takeScreenshot(Reference driver) {
        Page context = (Page)this.refer.deref(driver);
        return context.screenshot(new Page.ScreenshotOptions().setTimeout(60000.0));
    }

    public static String[] getMethodNames() {
        Method[] methods = SpecDriverPlaywright.class.getDeclaredMethods();
        return (String[])Stream.of(methods).map(Method::getName).filter(name -> !name.contains("getMethodNames") && !name.contains("Util")).toArray(String[]::new);
    }

    private Object handlerToObjectUtil(JSHandle jsHandle, Reference context) {
        if (jsHandle == null) {
            return null;
        }
        String type = "";
        Pattern pattern = Pattern.compile("(?:.+@)?(\\w*)(?:\\(\\d+\\))?", 2);
        Matcher matcher = pattern.matcher(jsHandle.toString());
        if (matcher.find()) {
            type = matcher.group(0).toLowerCase();
        }
        if (type.matches("array\\(\\d+\\)")) {
            Map map = jsHandle.getProperties();
            ArrayList<Object> arrayValues = new ArrayList<Object>();
            for (JSHandle jsHandle1 : map.values()) {
                arrayValues.add(this.handlerToObjectUtil(jsHandle1, context));
            }
            return arrayValues;
        }
        if (type.equals("object")) {
            Map map = jsHandle.getProperties();
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            for (Map.Entry entry : map.entrySet()) {
                resultMap.put((String)entry.getKey(), this.handlerToObjectUtil((JSHandle)entry.getValue(), context));
            }
            return resultMap;
        }
        if (type.equals("jshandle@node")) {
            Element element = new Element();
            element.setApplitoolsRefId(this.refer.ref(jsHandle.asElement(), context));
            return element;
        }
        return jsHandle.jsonValue();
    }

    private Object derefArgsUtil(Object arg) {
        if (arg == null) {
            return null;
        }
        ArrayList<Object> derefArg = new ArrayList<Object>();
        if (arg instanceof ArrayList) {
            for (Object argument : (ArrayList)arg) {
                if (argument instanceof ArrayList) {
                    derefArg.add(this.derefArgsUtil(argument));
                    continue;
                }
                derefArg.add(this.refer.deref(argument));
            }
            return derefArg;
        }
        if (arg instanceof HashMap) {
            HashMap map = new HashMap();
            for (Map.Entry entry : ((HashMap)arg).entrySet()) {
                map.put(entry.getKey(), this.derefArgsUtil(entry.getValue()));
            }
            return map;
        }
        return this.refer.deref(arg);
    }

    private Frame extractContextUtil(Reference context) {
        Object root = this.refer.deref(context);
        return this.isDriver(root) != false ? ((PageImpl)root).mainFrame() : (Frame)root;
    }
}

