/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.playwright.universal.mapper;

import com.applitools.ICheckSettings;
import com.applitools.eyes.AccessibilitySettings;
import com.applitools.eyes.AutProxySettings;
import com.applitools.eyes.CutProvider;
import com.applitools.eyes.config.Configuration;
import com.applitools.eyes.config.ContentInset;
import com.applitools.eyes.options.LayoutBreakpointsOptions;
import com.applitools.eyes.playwright.fluent.PlaywrightCheckSettings;
import com.applitools.eyes.playwright.universal.Refer;
import com.applitools.eyes.playwright.universal.mapper.CodedRegionReferenceMapper;
import com.applitools.eyes.playwright.universal.mapper.TAccessibilityRegionMapper;
import com.applitools.eyes.playwright.universal.mapper.TDynamicRegionMapper;
import com.applitools.eyes.playwright.universal.mapper.TFloatingRegionMapper;
import com.applitools.eyes.playwright.universal.mapper.TFramesMapper;
import com.applitools.eyes.playwright.universal.mapper.TRegionMapper;
import com.applitools.eyes.universal.Reference;
import com.applitools.eyes.universal.dto.CheckSettingsDto;
import com.applitools.eyes.universal.dto.DebugScreenshotHandlerDto;
import com.applitools.eyes.universal.dto.ICut;
import com.applitools.eyes.universal.mapper.AccessibilitySettingsMapper;
import com.applitools.eyes.universal.mapper.LayoutBreakpointsMapper;
import com.applitools.eyes.universal.mapper.ProxyMapper;
import com.applitools.eyes.universal.mapper.SettingsMapper;
import com.applitools.eyes.universal.mapper.VisualGridOptionMapper;
import java.util.Arrays;
import java.util.List;

public class PlaywrightCheckSettingsMapper {
    public static CheckSettingsDto toCheckSettingsDto(ICheckSettings checkSettings, Configuration config, Refer refer, Reference root) {
        if (!(checkSettings instanceof PlaywrightCheckSettings)) {
            return null;
        }
        PlaywrightCheckSettings playwrightCheckSettings = (PlaywrightCheckSettings)checkSettings;
        CheckSettingsDto checkSettingsDto = new CheckSettingsDto();
        checkSettingsDto.setRegion(TRegionMapper.toTRegionFromCheckSettings(playwrightCheckSettings, refer, root));
        checkSettingsDto.setFrames(TFramesMapper.toTFramesFromCheckSettings(playwrightCheckSettings.getFrameChain(), refer, root));
        checkSettingsDto.setFully(playwrightCheckSettings.getStitchContent());
        checkSettingsDto.setScrollRootElement(TRegionMapper.toTRegionDtoFromSRE(playwrightCheckSettings.getScrollRootElement(), refer, root));
        checkSettingsDto.setStitchMode(playwrightCheckSettings.getStitchMode() != null ? playwrightCheckSettings.getStitchMode().getName() : (config.getStitchMode() != null ? config.getStitchMode().getName() : null));
        checkSettingsDto.setHideScrollbars(playwrightCheckSettings.getHideScrollBars());
        checkSettingsDto.setHideCaret(playwrightCheckSettings.getHideCaret());
        checkSettingsDto.setOverlap(playwrightCheckSettings.getStitchOverlap());
        checkSettingsDto.setWaitBeforeCapture(playwrightCheckSettings.getWaitBeforeCapture());
        checkSettingsDto.setLazyLoad(playwrightCheckSettings.getLazyLoadOptions());
        checkSettingsDto.setIgnoreDisplacements(playwrightCheckSettings.isIgnoreDisplacements());
        checkSettingsDto.setNormalization(SettingsMapper.toNormalizationDto((ICut)SettingsMapper.toImageCropRect((CutProvider)config.getCutProvider(), (ContentInset)config.getContentInset()), (Integer)config.getRotation(), (Double)config.getScaleRatio()));
        checkSettingsDto.setDebugImages(new DebugScreenshotHandlerDto(config.getSaveDebugScreenshots(), config.getDebugScreenshotsPath(), config.getDebugScreenshotsPrefix()));
        checkSettingsDto.setName(playwrightCheckSettings.getName());
        checkSettingsDto.setPageId(playwrightCheckSettings.getPageId());
        checkSettingsDto.setIgnoreRegions(CodedRegionReferenceMapper.toCodedRegionReferenceList(Arrays.asList(playwrightCheckSettings.getIgnoreRegions()), refer, root));
        checkSettingsDto.setLayoutRegions(CodedRegionReferenceMapper.toCodedRegionReferenceList(Arrays.asList(playwrightCheckSettings.getLayoutRegions()), refer, root));
        checkSettingsDto.setStrictRegions(CodedRegionReferenceMapper.toCodedRegionReferenceList(Arrays.asList(playwrightCheckSettings.getStrictRegions()), refer, root));
        checkSettingsDto.setContentRegions(CodedRegionReferenceMapper.toCodedRegionReferenceList(Arrays.asList(playwrightCheckSettings.getContentRegions()), refer, root));
        checkSettingsDto.setFloatingRegions(TFloatingRegionMapper.toTFloatingRegionDtoList(Arrays.asList(playwrightCheckSettings.getFloatingRegions()), refer, root));
        checkSettingsDto.setAccessibilityRegions(TAccessibilityRegionMapper.toTAccessibilityRegionDtoList(Arrays.asList(playwrightCheckSettings.getAccessibilityRegions()), refer, root));
        checkSettingsDto.setAccessibilitySettings(AccessibilitySettingsMapper.toAccessibilitySettingsDto((AccessibilitySettings)((PlaywrightCheckSettings)checkSettings).getAccessibilityValidation()));
        checkSettingsDto.setDynamicRegions(TDynamicRegionMapper.toTDynamicRegionDtoList(Arrays.asList(playwrightCheckSettings.getDynamicRegions()), refer, root));
        checkSettingsDto.setMatchLevel(playwrightCheckSettings.getMatchLevel() == null ? null : playwrightCheckSettings.getMatchLevel().getName());
        checkSettingsDto.setRetryTimeout(config.getMatchTimeout());
        checkSettingsDto.setSendDom(playwrightCheckSettings.isSendDom());
        checkSettingsDto.setUseDom(playwrightCheckSettings.isUseDom());
        checkSettingsDto.setEnablePatterns(playwrightCheckSettings.isEnablePatterns());
        checkSettingsDto.setIgnoreCaret(playwrightCheckSettings.getIgnoreCaret());
        checkSettingsDto.setUfgOptions(VisualGridOptionMapper.toVisualGridOptionDtoList((List)playwrightCheckSettings.getVisualGridOptions()));
        checkSettingsDto.setLayoutBreakpoints(LayoutBreakpointsMapper.toLayoutBreakpointsDto((LayoutBreakpointsOptions)playwrightCheckSettings.getLayoutBreakpointsOptions()));
        checkSettingsDto.setDisableBrowserFetching(playwrightCheckSettings.isDisableBrowserFetching());
        checkSettingsDto.setAutProxy(ProxyMapper.toAutProxyDto((AutProxySettings)config.getAutProxy()));
        checkSettingsDto.setHooks(playwrightCheckSettings.getScriptHooks());
        checkSettingsDto.setUserCommandId(playwrightCheckSettings.getVariationGroupId());
        checkSettingsDto.setDensityMetrics(playwrightCheckSettings.getDensityMetrics());
        return checkSettingsDto;
    }
}

